/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.logging.Logger;
import java.util.stream.DoubleStream;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.filter.function.StandardDeviationFunction;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class StandardDeviationFunctionTest
extends FunctionTestSupport {
    private static final Logger LOGGER = Logging.getLogger(StandardDeviationFunctionTest.class);

    @Test
    public void testInstance() {
        Function stdDev = this.ff.function("StandardDeviation", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        Assert.assertNotNull((Object)stdDev);
    }

    @Test
    public void testGetName() {
        Function equInt = this.ff.function("StandardDeviation", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        LOGGER.finer("testGetName");
        Assert.assertEquals((Object)"StandardDeviation", (Object)equInt.getName());
    }

    @Test
    public void testSetNumberOfClasses() throws Exception {
        LOGGER.finer("testSetNumberOfClasses");
        Literal classes = this.ff.literal(3);
        PropertyName exp = this.ff.property("foo");
        StandardDeviationFunction func = (StandardDeviationFunction)this.ff.function("StandardDeviation", new Expression[]{exp, classes});
        Assert.assertEquals((long)3L, (long)func.getClasses());
        classes = this.ff.literal(12);
        func = (StandardDeviationFunction)this.ff.function("StandardDeviation", new Expression[]{exp, classes});
        Assert.assertEquals((long)12L, (long)func.getClasses());
    }

    @Test
    public void testGetValue() throws Exception {
        Literal classes = this.ff.literal(5);
        PropertyName exp = this.ff.property("foo");
        Function standardDeviation = this.ff.function("StandardDeviation", new Expression[]{exp, classes});
        Assert.assertNotNull((String)"step 1 - standard deviation function", (Object)standardDeviation);
        Classifier classifer = (Classifier)standardDeviation.evaluate((Object)this.featureCollection, Classifier.class);
        this.featureCollection.accepts(f -> {
            SimpleFeature feature = (SimpleFeature)f;
            Object value = feature.getAttribute("foo");
            Assert.assertNotNull((String)(feature.getID() + " foo"), (Object)value);
            int slot = classifer.classify(value);
            Assert.assertNotNull((String)("Slot " + slot), (Object)classifer.getTitle(slot));
        }, null);
        Function classify = this.ff.function("classify", new Expression[]{exp, this.ff.literal((Object)classifer)});
        Assert.assertNotNull((String)"step 2 - classify function", (Object)classify);
        try (SimpleFeatureIterator it = this.featureCollection.features();){
            SimpleFeature f2 = (SimpleFeature)it.next();
            Integer slot = (Integer)classify.evaluate((Object)f2, Integer.class);
            Assert.assertEquals((String)("value " + String.valueOf(f2.getAttribute("foo"))), (long)1L, (long)slot.intValue());
            f2 = (SimpleFeature)it.next();
            slot = (Integer)classify.evaluate((Object)f2, Integer.class);
            Assert.assertEquals((String)("value " + String.valueOf(f2.getAttribute("foo"))), (long)4L, (long)slot.intValue());
            f2 = (SimpleFeature)it.next();
            slot = (Integer)classify.evaluate((Object)f2, Integer.class);
            Assert.assertEquals((String)("value " + String.valueOf(f2.getAttribute("foo"))), (long)2L, (long)slot.intValue());
            f2 = (SimpleFeature)it.next();
            slot = (Integer)classify.evaluate((Object)f2, Integer.class);
            Assert.assertEquals((String)("value " + String.valueOf(f2.getAttribute("foo"))), (long)2L, (long)slot.intValue());
            f2 = (SimpleFeature)it.next();
            slot = (Integer)classify.evaluate((Object)f2, Integer.class);
            Assert.assertEquals((String)("value " + String.valueOf(f2.getAttribute("foo"))), (long)2L, (long)slot.intValue());
            f2 = (SimpleFeature)it.next();
            slot = (Integer)classify.evaluate((Object)f2, Integer.class);
            Assert.assertEquals((String)("value " + String.valueOf(f2.getAttribute("foo"))), (long)3L, (long)slot.intValue());
            f2 = (SimpleFeature)it.next();
            slot = (Integer)classify.evaluate((Object)f2, Integer.class);
            Assert.assertEquals((String)("value " + String.valueOf(f2.getAttribute("foo"))), (long)1L, (long)slot.intValue());
            f2 = (SimpleFeature)it.next();
            slot = (Integer)classify.evaluate((Object)f2, Integer.class);
            Assert.assertEquals((String)("value " + String.valueOf(f2.getAttribute("foo"))), (long)1L, (long)slot.intValue());
        }
    }

    @Test
    public void testConstantValuesNumeric() {
        Function function = this.ff.function("StandardDeviation", new Expression[]{this.ff.property("v"), this.ff.literal(12)});
        RangedClassifier classifier = (RangedClassifier)function.evaluate((Object)this.constantCollection);
        Assert.assertNotNull((Object)classifier);
        Assert.assertEquals((long)1L, (long)classifier.getSize());
        Assert.assertEquals((double)123.123, (double)((Double)classifier.getMin(0)), (double)0.0);
        Assert.assertEquals((double)123.123, (double)((Double)classifier.getMax(0)), (double)0.0);
    }

    @Test
    public void testPercentagesOddClassNum() {
        Literal classes = this.ff.literal(5);
        PropertyName exp = this.ff.property("foo");
        Function standardDeviation = this.ff.function("StandardDeviation", new Expression[]{exp, classes, this.ff.literal(true)});
        Assert.assertNotNull((String)"step 1 - standard deviation function", (Object)standardDeviation);
        Classifier classifier = (Classifier)standardDeviation.evaluate((Object)this.stddevCollection, Classifier.class);
        double[] percentages = classifier.getPercentages();
        Assert.assertNotNull((Object)percentages);
        Assert.assertEquals((long)5L, (long)percentages.length);
        Assert.assertEquals((double)10.0, (double)percentages[0], (double)0.0);
        Assert.assertEquals((double)0.0, (double)percentages[1], (double)0.0);
        Assert.assertEquals((double)70.0, (double)percentages[2], (double)0.0);
        Assert.assertEquals((double)10.0, (double)percentages[3], (double)0.0);
        Assert.assertEquals((double)10.0, (double)percentages[4], (double)0.0);
        Assert.assertEquals((double)100.0, (double)DoubleStream.of(percentages).sum(), (double)0.0);
    }

    @Test
    public void testPercentagesEvenClassNum() {
        Literal classes = this.ff.literal(6);
        PropertyName exp = this.ff.property("foo");
        Function standardDeviation = this.ff.function("StandardDeviation", new Expression[]{exp, classes, this.ff.literal(true)});
        Assert.assertNotNull((String)"step 1 - standard deviation function", (Object)standardDeviation);
        Classifier classifier = (Classifier)standardDeviation.evaluate((Object)this.stddevCollection, Classifier.class);
        double[] percentages = classifier.getPercentages();
        Assert.assertNotNull((Object)percentages);
        Assert.assertEquals((long)6L, (long)percentages.length);
        Assert.assertEquals((double)10.0, (double)percentages[0], (double)0.0);
        Assert.assertEquals((double)0.0, (double)percentages[1], (double)0.0);
        Assert.assertEquals((double)50.0, (double)percentages[2], (double)0.0);
        Assert.assertEquals((double)30.0, (double)percentages[3], (double)0.0);
        Assert.assertEquals((double)0.0, (double)percentages[4], (double)0.0);
        Assert.assertEquals((double)10.0, (double)percentages[5], (double)0.0);
        Assert.assertEquals((double)100.0, (double)DoubleStream.of(percentages).sum(), (double)0.0);
    }
}

