/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.filter.function.ExplicitClassifier;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.UniqueIntervalFunction;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class UniqueIntervalFunctionTest
extends FunctionTestSupport {
    @Test
    public void testInstance() {
        Function equInt = this.ff.function("UniqueInterval", new Expression[]{this.ff.literal((Object)this.featureCollection)});
        Assert.assertNotNull((Object)equInt);
    }

    @Test
    public void testGetName() {
        Function equInt = this.ff.function("UniqueInterval", new Expression[]{this.ff.literal((Object)this.featureCollection)});
        Assert.assertEquals((Object)"UniqueInterval", (Object)equInt.getName());
    }

    @Test
    public void testSetClasses() throws Exception {
        Literal classes = this.ff.literal(3);
        PropertyName exp = this.ff.property("foo");
        UniqueIntervalFunction func = (UniqueIntervalFunction)this.ff.function("UniqueInterval", new Expression[]{exp, classes});
        Assert.assertEquals((long)3L, (long)func.getClasses());
        func.setClasses(12);
        Assert.assertEquals((long)12L, (long)func.getClasses());
    }

    @Test
    public void testEvaluate() throws Exception {
        Literal classes = this.ff.literal(2);
        PropertyName exp = this.ff.property("foo");
        UniqueIntervalFunction func = (UniqueIntervalFunction)this.ff.function("UniqueInterval", new Expression[]{exp, classes});
        Object result = func.evaluate((Object)this.featureCollection);
        Assert.assertTrue((boolean)(result instanceof ExplicitClassifier));
        ExplicitClassifier classifier = (ExplicitClassifier)result;
        Assert.assertEquals((long)2L, (long)classifier.getSize());
        Assert.assertEquals((long)classifier.values[0].size(), (long)classifier.values[1].size());
        Assert.assertFalse((boolean)classifier.values[0].removeAll(classifier.values[1]));
    }

    @Test
    public void testConstantValuesNumeric() {
        Function function = this.ff.function("UniqueInterval", new Expression[]{this.ff.property("v"), this.ff.literal(12)});
        ExplicitClassifier classifier = (ExplicitClassifier)function.evaluate((Object)this.constantCollection);
        Assert.assertNotNull((Object)classifier);
        Assert.assertEquals((long)1L, (long)classifier.getSize());
        Assert.assertEquals((long)1L, (long)classifier.getValues(0).size());
        Assert.assertEquals((Object)123.123, classifier.getValues(0).iterator().next());
    }

    @Test
    public void testConstantValuesString() {
        Function function = this.ff.function("UniqueInterval", new Expression[]{this.ff.property("s"), this.ff.literal(12)});
        ExplicitClassifier classifier = (ExplicitClassifier)function.evaluate((Object)this.constantCollection);
        Assert.assertNotNull((Object)classifier);
        Assert.assertEquals((long)1L, (long)classifier.getSize());
        Assert.assertEquals((long)1L, (long)classifier.getValues(0).size());
        Assert.assertEquals((Object)"abc", classifier.getValues(0).iterator().next());
    }

    @Test
    public void testEvaluateNumericalWithPercentages() {
        Literal classes = this.ff.literal(2);
        PropertyName exp = this.ff.property("foo");
        UniqueIntervalFunction func = (UniqueIntervalFunction)this.ff.function("UniqueInterval", new Expression[]{exp, classes, this.ff.literal(true)});
        Object result = func.evaluate((Object)this.featureCollection);
        Assert.assertTrue((boolean)(result instanceof ExplicitClassifier));
        ExplicitClassifier classifier = (ExplicitClassifier)result;
        double[] percentages = classifier.getPercentages();
        Assert.assertEquals((long)2L, (long)percentages.length);
        Assert.assertEquals((double)50.0, (double)percentages[0], (double)0.0);
        Assert.assertEquals((double)50.0, (double)percentages[0], (double)0.0);
    }

    @Test
    public void testEvaluateNotNumericalWithPercentages() {
        Literal classes = this.ff.literal(2);
        PropertyName exp = this.ff.property("s");
        UniqueIntervalFunction func = (UniqueIntervalFunction)this.ff.function("UniqueInterval", new Expression[]{exp, classes, this.ff.literal(true)});
        Object result = func.evaluate((Object)this.constantCollection);
        Assert.assertTrue((boolean)(result instanceof ExplicitClassifier));
        ExplicitClassifier classifier = (ExplicitClassifier)result;
        double[] percentages = classifier.getPercentages();
        Assert.assertEquals((long)1L, (long)percentages.length);
        Assert.assertEquals((double)100.0, (double)percentages[0], (double)0.0);
    }
}

