/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.math;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.math.ModuloFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class ModuloFunctionTest {
    private FilterFactory ff;
    private String functionName;

    @Before
    public void setUp() throws Exception {
        this.ff = CommonFactoryFinder.getFilterFactory2(null);
        this.functionName = ModuloFunction.NAME.getName();
    }

    @Test
    public void testModuloInvalidInitNoArgs() {
        try {
            this.ff.function(this.functionName, new Expression[0]);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)("Unable to find function " + this.functionName), (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"Exception not thrown");
    }

    @Test
    public void testModuloInvalidInitOneArg() {
        try {
            this.ff.function(this.functionName, new Expression[]{this.ff.literal(13)});
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)("Unable to find function " + this.functionName), (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"Exception not thrown");
    }

    @Test
    public void testModuloInvalidInitThreeArgs() {
        try {
            this.ff.function(this.functionName, new Expression[]{this.ff.literal(13), this.ff.literal(14), this.ff.literal(15)});
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)("Unable to find function " + this.functionName), (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"Exception not thrown");
    }

    @Test
    public void testModulo() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(13), this.ff.literal(4)});
        Assert.assertEquals((Object)1, (Object)function.evaluate(null));
    }

    @Test
    public void testModuloNegativeDividend() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(-13), this.ff.literal(4)});
        Assert.assertEquals((Object)3, (Object)function.evaluate(null));
    }

    @Test
    public void testModuloNegativeDivisor() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(13), this.ff.literal(-4)});
        Assert.assertEquals((Object)-3, (Object)function.evaluate(null));
    }

    @Test
    public void testModuloFloat() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(13.6), this.ff.literal(4)});
        Assert.assertEquals((Object)1, (Object)function.evaluate(null));
    }

    @Test
    public void testModuloOneDivisor() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(13), this.ff.literal(1)});
        Assert.assertEquals((Object)0, (Object)function.evaluate(null));
    }

    @Test
    public void testModuloZeroDivisor() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(13), this.ff.literal(0)});
        try {
            function.evaluate(null);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"IllegalArgumentException not thrown");
    }
}

