/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.spatial.DefaultCRSFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BBOX3D;
import org.opengis.geometry.BoundingBox3D;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;

public class DefaultCRSFilterVisitorTest {
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();

    @Test
    public void force3DCRS2DEnvelope() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4939", (boolean)true);
        SingleCRS hcrs = CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
        BBOX bbox = this.ff.bbox("the_geom", -180.0, -90.0, 180.0, 90.0, null);
        DefaultCRSFilterVisitor visitor = new DefaultCRSFilterVisitor(this.ff, crs);
        BBOX filtered = (BBOX)bbox.accept((FilterVisitor)visitor, null);
        Literal box = (Literal)filtered.getExpression2();
        ReferencedEnvelope re = (ReferencedEnvelope)box.evaluate(null);
        Assert.assertEquals((Object)hcrs, (Object)re.getCoordinateReferenceSystem());
    }

    @Test
    public void force3DCRS3DEnvelope() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4939", (boolean)true);
        BBOX3D bbox = this.ff.bbox((Expression)this.ff.property("the_geom"), (BoundingBox3D)new ReferencedEnvelope3D(-180.0, 180.0, -90.0, 90.0, 0.0, 100.0, null));
        DefaultCRSFilterVisitor visitor = new DefaultCRSFilterVisitor(this.ff, crs);
        BBOX filtered = (BBOX)bbox.accept((FilterVisitor)visitor, null);
        Literal box = (Literal)filtered.getExpression2();
        ReferencedEnvelope re = (ReferencedEnvelope)box.evaluate(null);
        Assert.assertEquals((Object)crs, (Object)re.getCoordinateReferenceSystem());
    }
}

