/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.temporal;

import org.geotools.filter.temporal.BegunByImpl;
import org.geotools.filter.temporal.TemporalFilterTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.expression.Expression;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.TemporalPrimitive;

public class BegunByImplTest
extends TemporalFilterTestSupport {
    @Test
    public void test() throws Exception {
        Instant i1 = this.instant("2001-07-05T12:08:56.235-0700");
        Instant i2 = this.instant("2001-07-04T12:08:56.235-0700");
        this.doAssert((TemporalPrimitive)i1, (TemporalPrimitive)i2, false);
        this.doAssert((TemporalPrimitive)i2, (TemporalPrimitive)i1, false);
        this.doAssert((TemporalPrimitive)i1, (TemporalPrimitive)i1, false);
        Period p1 = this.period("2001-07-05T12:08:56.235-0700", "2001-07-06T12:08:56.235-0700");
        this.doAssert((TemporalPrimitive)i1, (TemporalPrimitive)p1, false);
        this.doAssert((TemporalPrimitive)p1, (TemporalPrimitive)i1, true);
        Period p2 = this.period("2001-07-05T12:08:56.235-0700", "2001-07-06T12:08:57.235-0700");
        Period p3 = this.period("2001-07-05T12:08:56.235-0700", "2001-07-06T12:08:55.235-0700");
        this.doAssert((TemporalPrimitive)p1, (TemporalPrimitive)p1, false);
        this.doAssert((TemporalPrimitive)p1, (TemporalPrimitive)p2, false);
        this.doAssert((TemporalPrimitive)p1, (TemporalPrimitive)p3, true);
        this.doAssert((TemporalPrimitive)p2, (TemporalPrimitive)p1, true);
        this.doAssert((TemporalPrimitive)p3, (TemporalPrimitive)p1, false);
    }

    void doAssert(TemporalPrimitive tp1, TemporalPrimitive tp2, boolean b) {
        BegunByImpl a = new BegunByImpl((Expression)ff.literal((Object)tp1), (Expression)ff.literal((Object)tp2));
        Assert.assertEquals((Object)b, (Object)a.evaluate(null));
        Assert.assertFalse((boolean)a.toString().contains(BegunByImpl.class.getName()));
        Assert.assertTrue((boolean)a.toString().contains("BegunBy"));
    }
}

