/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.FilterFunction_geometryType;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.locationtech.jts.geom.Envelope;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.Boundary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.Precision;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.Complex;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class AbstractPostPreProcessFilterSplittingVisitorTests {
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected TestAccessor accessor;
    protected static final String typeName = "test";
    protected static final String geomAtt = "geom";
    protected static final String nameAtt = "name";
    protected static final String numAtt = "num";

    @Before
    public void setUp() throws Exception {
    }

    protected PostPreProcessFilterSplittingVisitor newVisitor(FilterCapabilities supportedCaps) throws SchemaException {
        return new PostPreProcessFilterSplittingVisitor(supportedCaps, DataUtilities.createType((String)typeName, (String)"geom:Point,name:String,num:int"), (ClientTransactionAccessor)this.accessor);
    }

    protected PropertyIsEqualTo createPropertyIsEqualToFilter(String attr, String value) throws IllegalFilterException {
        return this.ff.equals((Expression)this.ff.property(attr), (Expression)this.ff.literal((Object)value));
    }

    protected Envelope createTestEnvelope() {
        return new Envelope(10.0, 20.0, 10.0, 20.0);
    }

    protected void runTest(Filter filter, FilterCapabilities supportedCaps, String attToEdit) throws SchemaException {
        PostPreProcessFilterSplittingVisitor visitor = this.newVisitor(new FilterCapabilities());
        if (this.accessor != null) {
            this.accessor.setUpdate("", null);
        }
        filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)filter, (Object)visitor.getFilterPost());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)visitor.getFilterPre());
        visitor = this.newVisitor(supportedCaps);
        filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)visitor.getFilterPost());
        Assert.assertEquals((Object)filter, (Object)visitor.getFilterPre());
        if (attToEdit != null && this.accessor != null) {
            HashSet<FeatureId> idSet = new HashSet<FeatureId>();
            idSet.add(this.ff.featureId("fid"));
            Id updateFilter = this.ff.id(idSet);
            this.accessor.setUpdate(attToEdit, (Filter)updateFilter);
            visitor = this.newVisitor(supportedCaps);
            filter.accept((FilterVisitor)visitor, null);
            Assert.assertEquals((Object)filter, (Object)visitor.getFilterPost());
            Assert.assertEquals((Object)this.ff.or(filter, (Filter)updateFilter), (Object)visitor.getFilterPre());
        }
    }

    protected PropertyIsEqualTo createFunctionFilter() throws Exception {
        FilterFunction_geometryType geomTypeExpr = new FilterFunction_geometryType();
        geomTypeExpr.setParameters(Arrays.asList(this.ff.property(geomAtt)));
        PropertyIsEqualTo filter = this.ff.equals((Expression)geomTypeExpr, (Expression)this.ff.literal((Object)"Polygon"));
        return filter;
    }

    class MockGeometryImpl
    implements Geometry {
        MockGeometryImpl() {
        }

        public boolean contains(DirectPosition arg0) {
            return false;
        }

        public boolean contains(TransfiniteSet arg0) {
            return false;
        }

        public TransfiniteSet difference(TransfiniteSet arg0) {
            return null;
        }

        public boolean equals(TransfiniteSet arg0) {
            return false;
        }

        public Boundary getBoundary() {
            return null;
        }

        public Geometry getBuffer(double arg0) {
            return null;
        }

        public DirectPosition getCentroid() {
            return null;
        }

        public Complex getClosure() {
            return null;
        }

        public Geometry getConvexHull() {
            return null;
        }

        public int getCoordinateDimension() {
            return 0;
        }

        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return null;
        }

        public int getDimension(DirectPosition arg0) {
            return 0;
        }

        public double getDistance(Geometry arg0) {
            return this.distance(arg0);
        }

        public double distance(Geometry arg0) {
            return 0.0;
        }

        public org.opengis.geometry.Envelope getEnvelope() {
            return null;
        }

        public Set<Complex> getMaximalComplex() {
            return null;
        }

        public Geometry getMbRegion() {
            return null;
        }

        public DirectPosition getRepresentativePoint() {
            return null;
        }

        public TransfiniteSet intersection(TransfiniteSet arg0) {
            return null;
        }

        public boolean intersects(TransfiniteSet arg0) {
            return false;
        }

        public boolean isCycle() {
            return false;
        }

        public boolean isMutable() {
            return false;
        }

        public boolean isSimple() {
            return false;
        }

        public TransfiniteSet symmetricDifference(TransfiniteSet arg0) {
            return null;
        }

        public Geometry toImmutable() {
            return null;
        }

        public Geometry transform(CoordinateReferenceSystem arg0) throws TransformException {
            return null;
        }

        public Geometry transform(CoordinateReferenceSystem arg0, MathTransform arg1) throws TransformException {
            return null;
        }

        public TransfiniteSet union(TransfiniteSet arg0) {
            return null;
        }

        public MockGeometryImpl clone() throws CloneNotSupportedException {
            return (MockGeometryImpl)super.clone();
        }

        public Precision getPrecision() {
            return null;
        }

        public String toString() {
            return "MOCKGEOM";
        }
    }

    public class TestAccessor
    implements ClientTransactionAccessor {
        private Filter updateFilter;
        private String attribute;

        public Filter getDeleteFilter() {
            return null;
        }

        public Filter getUpdateFilter(String attributePath) {
            if (attributePath.equals(this.attribute)) {
                return this.updateFilter;
            }
            return null;
        }

        public void setUpdate(String attribute, Filter updateFilter) {
            this.attribute = attribute;
            this.updateFilter = updateFilter;
        }
    }
}

