/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.expression.InternalVolatileFunction;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.InternalFunction;

public class DuplicatorFilterVisitorTest {
    FilterFactory fac;

    @Before
    public void setUp() throws Exception {
        this.fac = CommonFactoryFinder.getFilterFactory(null);
    }

    @Test
    public void testLogicFilterDuplication() throws IllegalFilterException {
        ArrayList<PropertyIsGreaterThan> filters = new ArrayList<PropertyIsGreaterThan>();
        PropertyIsGreaterThan filter1 = this.fac.greater((Expression)this.fac.literal(2), (Expression)this.fac.literal(1));
        filters.add(filter1);
        PropertyIsGreaterThan filter2 = this.fac.greater((Expression)this.fac.literal(4), (Expression)this.fac.literal(3));
        filters.add(filter2);
        And oldFilter = this.fac.and(filters);
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor((FilterFactory2)this.fac);
        Filter newFilter = (Filter)oldFilter.accept((FilterVisitor)visitor, null);
        Assert.assertNotNull((Object)newFilter);
    }

    @Test
    public void testDuplicateInternalFunction() throws IllegalFilterException {
        class TestInternalFunction
        extends InternalVolatileFunction {
            TestInternalFunction() {
            }

            public Object evaluate(Object object) {
                return null;
            }

            public InternalFunction duplicate(Expression ... parameters) {
                return new TestInternalFunction();
            }
        }
        TestInternalFunction internalFunction = new TestInternalFunction();
        PropertyIsNull filter = this.fac.isNull((Expression)internalFunction);
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor((FilterFactory2)this.fac);
        Filter newFilter = (Filter)filter.accept((FilterVisitor)visitor, null);
        Assert.assertTrue((boolean)(newFilter instanceof PropertyIsNull));
        Expression newExpression = ((PropertyIsNull)newFilter).getExpression();
        Assert.assertNotNull((Object)newExpression);
        Assert.assertTrue((boolean)(newExpression instanceof TestInternalFunction));
        Assert.assertNotSame((Object)((Object)internalFunction), (Object)newExpression);
    }
}

