/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.IdCollectorFilterVisitor;
import org.geotools.feature.visitor.IdFinderFilterVisitor;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.filter.visitor.NullFilterVisitor;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public class FilterVisitorTest {
    private static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);

    @Test
    public void testDefaultFilterVisitorFeatureIdExample() {
        Id myFilter = ff.id(Collections.singleton(ff.featureId("fred")));
        DefaultFilterVisitor allFids = new DefaultFilterVisitor(){

            public Object visit(Id filter, Object data) {
                Set set = (Set)data;
                set.addAll(filter.getIDs());
                return set;
            }
        };
        Set set = (Set)myFilter.accept((FilterVisitor)allFids, new HashSet());
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testDefaultFilterVisitorPropertyNameExample() {
        PropertyIsGreaterThan myFilter = ff.greater((Expression)ff.add((Expression)ff.property("foo"), (Expression)ff.property("bar")), (Expression)ff.literal(1));
        class FindNames
        extends DefaultFilterVisitor {
            FindNames() {
            }

            public Object visit(PropertyName expression, Object data) {
                Set set = (Set)data;
                set.add(expression.getPropertyName());
                return set;
            }
        }
        Set set = (Set)myFilter.accept((FilterVisitor)new FindNames(), new HashSet());
        Assert.assertTrue((boolean)set.contains("foo"));
    }

    @Test
    public void testNullFilterVisitor() {
        PropertyIsNull filter = ff.isNull((Expression)ff.property("name"));
        Assert.assertEquals((Object)1, (Object)filter.accept((FilterVisitor)NullFilterVisitor.NULL_VISITOR, (Object)1));
        filter = Filter.INCLUDE;
        Assert.assertEquals((Object)1, (Object)filter.accept((FilterVisitor)NullFilterVisitor.NULL_VISITOR, (Object)1));
        NullFilterVisitor allFids = new NullFilterVisitor(){

            public Object visit(Id filter, Object data) {
                if (data == null) {
                    return null;
                }
                Set set = (Set)data;
                set.addAll(filter.getIDs());
                return set;
            }
        };
        Id myFilter = ff.id(Collections.singleton(ff.featureId("fred")));
        Set set = (Set)myFilter.accept((FilterVisitor)allFids, new HashSet());
        Assert.assertNotNull((Object)set);
        Set set2 = (Set)myFilter.accept((FilterVisitor)allFids, null);
        Assert.assertNull((Object)set2);
    }

    @Test
    public void testIdFinderFilterVisitor() {
        PropertyIsNull filter = ff.isNull((Expression)ff.property("name"));
        boolean found = (Boolean)filter.accept((FilterVisitor)new IdFinderFilterVisitor(), null);
        Assert.assertFalse((boolean)found);
        filter = ff.id(Collections.singleton(ff.featureId("eclesia")));
        found = (Boolean)filter.accept((FilterVisitor)new IdFinderFilterVisitor(), null);
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testIdCollector() {
        PropertyIsNull filter = ff.isNull((Expression)ff.property("name"));
        Set fids = (Set)filter.accept((FilterVisitor)IdCollectorFilterVisitor.ID_COLLECTOR, new HashSet());
        Assert.assertTrue((boolean)fids.isEmpty());
        Assert.assertFalse((boolean)fids.contains("eclesia"));
        filter = ff.id(Collections.singleton(ff.featureId("eclesia")));
        fids = (Set)filter.accept((FilterVisitor)IdCollectorFilterVisitor.ID_COLLECTOR, new HashSet());
        Assert.assertFalse((boolean)fids.isEmpty());
        Assert.assertTrue((boolean)fids.contains("eclesia"));
    }
}

