/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.GeometryBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeometryCoordinateSequenceTransformerTest {
    private GeometryFactory geomFact = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
    private GeometryBuilder gb = new GeometryBuilder(this.geomFact);
    private static final double ORD_TOLERANCE = 1.0E-6;

    @Test
    public void testLineString() throws Exception {
        this.checkTransform((Geometry)this.gb.lineStringZ(new double[]{10.0, 11.0, 1.0, 20.0, 21.0, 2.0}));
        this.checkTransform((Geometry)this.gb.lineString(new double[]{10.0, 11.0, 20.0, 21.0}));
    }

    @Test
    public void testPoint() throws Exception {
        this.checkTransform((Geometry)this.gb.point(10.0, 11.0));
        this.checkTransform((Geometry)this.gb.pointZ(10.0, 11.0, 1.0));
    }

    @Test
    public void testPolygon() throws Exception {
        this.checkTransform((Geometry)this.gb.circle(10.0, 10.0, 5.0, 20));
        this.checkTransform((Geometry)this.gb.boxZ(10.0, 10.0, 20.0, 20.0, 99.0));
        this.checkTransform((Geometry)this.gb.polygon(this.gb.boxZ(10.0, 10.0, 20.0, 20.0, 99.0), this.gb.boxZ(11.0, 11.0, 19.0, 19.0, 99.0)));
    }

    @Test
    public void testMulti() throws Exception {
        this.checkTransform((Geometry)this.gb.multiPoint(10.0, 10.0, 5.0, 20.0));
        this.checkTransform((Geometry)this.gb.multiLineString(new LineString[]{this.gb.lineString(new double[]{10.0, 10.0, 20.0, 20.0}), this.gb.lineString(new double[]{10.0, 10.0, 20.0, 20.0})}));
        this.checkTransform((Geometry)this.gb.multiPolygon(new Polygon[]{this.gb.boxZ(10.0, 10.0, 20.0, 20.0, 99.0), this.gb.boxZ(11.0, 11.0, 19.0, 19.0, 99.0)}));
    }

    @Test
    public void testGeometryCollection() throws Exception {
        this.checkTransform((Geometry)this.gb.geometryCollection(new Geometry[]{this.gb.point(10.0, 11.0), this.gb.lineString(new double[]{10.0, 10.0, 20.0, 20.0}), this.gb.box(10.0, 10.0, 20.0, 20.0)}));
    }

    @Test
    public void testFlipAxisOnCurved() throws Exception {
        CircularString cs = (CircularString)new CurvedGeometryFactory(0.1).createCurvedGeometry(2, new double[]{0.0, 1.0, 1.0, 2.0, 2.0, 1.0});
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
        CoordinateReferenceSystem crsLatLon = CRS.decode((String)"urn:ogc:def:crs:EPSG:4326");
        CoordinateReferenceSystem crsLonLat = CRS.decode((String)"EPSG:4326", (boolean)true);
        transformer.setCoordinateReferenceSystem(crsLatLon);
        MathTransform trans = CRS.findMathTransform((CoordinateReferenceSystem)crsLonLat, (CoordinateReferenceSystem)crsLatLon);
        transformer.setMathTransform(trans);
        Geometry transformed = transformer.transform((Geometry)cs);
        Assert.assertTrue((boolean)(transformed instanceof CircularString));
        CircularString tcs = (CircularString)transformed;
        Assert.assertArrayEquals((double[])new double[]{1.0, 0.0, 2.0, 1.0, 1.0, 2.0}, (double[])tcs.getControlPoints(), (double)0.0);
    }

    @Test
    public void testFullTransformOnCurved() throws Exception {
        CircularString cs = (CircularString)new CurvedGeometryFactory(0.1).createCurvedGeometry(2, new double[]{0.0, 1.0, 1.0, 2.0, 2.0, 1.0});
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:3857");
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326", (boolean)true);
        transformer.setCoordinateReferenceSystem(targetCRS);
        MathTransform trans = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        transformer.setMathTransform(trans);
        Geometry transformed = transformer.transform((Geometry)cs);
        Assert.assertFalse((boolean)(transformed instanceof CircularString));
        LineString ls = (LineString)transformed;
        Assert.assertTrue((ls.getCoordinateSequence().size() > 3 ? 1 : 0) != 0);
    }

    @Test
    public void testDifferentDimensionsFailure() throws Exception {
        Polygon g1 = this.gb.box(10.0, 10.0, 20.0, 20.0);
        Polygon g2 = this.gb.boxZ(10.0, 10.0, 20.0, 20.0, 99.0);
        Assert.assertFalse((boolean)this.hasSameValuesAndStructure((Geometry)g1, (Geometry)g2));
    }

    private void checkTransform(Geometry g) throws TransformException {
        GeometryCoordinateSequenceTransformer gcsTrans = new GeometryCoordinateSequenceTransformer();
        gcsTrans.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        LinearTransform trans = ProjectiveTransform.createTranslation((int)2, (double)100.0);
        gcsTrans.setMathTransform((MathTransform)trans);
        GeometryCoordinateSequenceTransformer gcsTransInv = new GeometryCoordinateSequenceTransformer();
        gcsTransInv.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        LinearTransform transInv = ProjectiveTransform.createTranslation((int)2, (double)-100.0);
        gcsTransInv.setMathTransform((MathTransform)transInv);
        Geometry gTrans = gcsTrans.transform(g);
        Geometry g2 = gcsTransInv.transform(gTrans);
        Assert.assertNotSame((Object)g, (Object)g2);
        Assert.assertTrue((boolean)this.hasSameValuesAndStructure(g, g2));
    }

    boolean hasSameValuesAndStructure(Geometry g1, Geometry g2) {
        if (!g1.equalsExact(g2, 1.0E-6)) {
            return false;
        }
        if (g1.getFactory() != g2.getFactory()) {
            return false;
        }
        CoordinateSequence seq = CoordinateSequenceFinder.find(g1);
        return CoordinateSequenceSchemaChecker.check(g2, seq.getClass(), seq.getDimension());
    }

    static class CoordinateSequenceSchemaChecker
    implements CoordinateSequenceFilter {
        private Class coordSeqClass;
        private int dimension;
        private boolean isSame = true;

        public static boolean check(Geometry g, Class coordSeqClass, int dimension) {
            CoordinateSequenceSchemaChecker checkCS = new CoordinateSequenceSchemaChecker(coordSeqClass, dimension);
            g.apply((CoordinateSequenceFilter)checkCS);
            return checkCS.isSame();
        }

        public CoordinateSequenceSchemaChecker(Class coordSeqClass, int dimension) {
            this.coordSeqClass = coordSeqClass;
            this.dimension = dimension;
        }

        public boolean isSame() {
            return this.isSame;
        }

        public void filter(CoordinateSequence seq, int i) {
            if (seq.getClass() != this.coordSeqClass) {
                this.isSame = false;
            }
            if (seq.getDimension() != this.dimension) {
                this.isSame = false;
            }
        }

        public boolean isDone() {
            return !this.isSame;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }

    static class CoordinateSequenceFinder
    implements CoordinateSequenceFilter {
        private CoordinateSequence firstSeqFound = null;

        CoordinateSequenceFinder() {
        }

        public static CoordinateSequence find(Geometry g) {
            CoordinateSequenceFinder finder = new CoordinateSequenceFinder();
            g.apply((CoordinateSequenceFilter)finder);
            return finder.getSeq();
        }

        public CoordinateSequence getSeq() {
            return this.firstSeqFound;
        }

        public void filter(CoordinateSequence seq, int i) {
            if (this.firstSeqFound == null) {
                this.firstSeqFound = seq;
            }
        }

        public boolean isDone() {
            return this.firstSeqFound != null;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }
}

