/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.geometry.BoundingBox3D;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReferencedEnvelope3DTest {
    @Test
    public void testEverything() {
        ReferencedEnvelope3D everything = ReferencedEnvelope3D.EVERYTHING;
        ReferencedEnvelope3D world = new ReferencedEnvelope3D(ReferencedEnvelope3D.EVERYTHING);
        Assert.assertEquals((long)world.getDimension(), (long)3L);
        Assert.assertSame((Object)everything, (Object)ReferencedEnvelope3D.EVERYTHING);
        Assert.assertNotSame((Object)everything, (Object)world);
        Assert.assertEquals((Object)everything, (Object)world);
        Assert.assertEquals((Object)world, (Object)everything);
        Assert.assertFalse((String)"This is not an empty 3d envelope", (boolean)everything.isEmpty());
        Assert.assertTrue((String)"This is a null 3d envelope", (boolean)everything.isNull());
        Coordinate center = everything.centre();
        Assert.assertNotNull((Object)center);
        double volume = everything.getVolume();
        Assert.assertTrue((String)("volume=" + volume), (boolean)Double.isInfinite(volume));
        volume = world.getVolume();
        Assert.assertTrue((String)("volume=" + volume), (boolean)Double.isInfinite(volume));
        double area = everything.getArea();
        Assert.assertTrue((String)("area=" + area), (boolean)Double.isInfinite(area));
        area = world.getArea();
        Assert.assertTrue((String)("area=" + area), (boolean)Double.isInfinite(area));
        try {
            everything.setBounds((BoundingBox3D)new ReferencedEnvelope3D());
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        everything.setToNull();
        everything.translate(1.0, 1.0, 1.0);
        Assert.assertEquals((Object)everything, (Object)world);
        Assert.assertEquals((Object)world, (Object)everything);
        Assert.assertEquals((double)world.getMaximum(0), (double)everything.getMaximum(0), (double)0.0);
        Assert.assertEquals((double)world.getMaximum(1), (double)everything.getMaximum(1), (double)0.0);
        Assert.assertEquals((double)world.getMaximum(2), (double)everything.getMaximum(2), (double)0.0);
        Assert.assertEquals((double)world.getMinimum(0), (double)everything.getMinimum(0), (double)0.0);
        Assert.assertEquals((double)world.getMinimum(1), (double)everything.getMinimum(1), (double)0.0);
        Assert.assertEquals((double)world.getMinimum(2), (double)everything.getMinimum(2), (double)0.0);
        Assert.assertEquals((double)world.getMedian(0), (double)everything.getMedian(0), (double)0.0);
        Assert.assertEquals((double)world.getMedian(1), (double)everything.getMedian(1), (double)0.0);
        Assert.assertEquals((double)world.getMedian(2), (double)everything.getMedian(2), (double)0.0);
    }

    @Test
    public void intersection() throws Exception {
        ReferencedEnvelope3D australia = new ReferencedEnvelope3D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
        australia.include(40.0, 110.0, 0.0);
        australia.include(10.0, 150.0, 10.0);
        ReferencedEnvelope3D newZealand = new ReferencedEnvelope3D((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_3D);
        newZealand.include(50.0, 165.0, 0.0);
        newZealand.include(33.0, 180.0, 5.0);
        try {
            australia.intersection(newZealand);
            Assert.fail((String)"Expected a mismatch of CoordinateReferenceSystem");
        }
        catch (MismatchedReferenceSystemException mismatchedReferenceSystemException) {
            // empty catch block
        }
    }

    @Test
    public void include() throws Exception {
        ReferencedEnvelope3D australia = new ReferencedEnvelope3D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
        australia.include(40.0, 110.0, 0.0);
        australia.include(10.0, 150.0, 10.0);
        ReferencedEnvelope3D newZealand = new ReferencedEnvelope3D((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_3D);
        newZealand.include(50.0, 165.0, 0.0);
        newZealand.include(33.0, 180.0, 5.0);
        try {
            australia.expandToInclude(newZealand);
            Assert.fail((String)"Expected a mismatch of CoordinateReferenceSystem");
        }
        catch (MismatchedReferenceSystemException mismatchedReferenceSystemException) {
            // empty catch block
        }
        try {
            australia.include((BoundingBox3D)newZealand);
            Assert.fail((String)"Expected a mismatch of CoordinateReferenceSystem");
        }
        catch (MismatchedReferenceSystemException mismatchedReferenceSystemException) {
            // empty catch block
        }
    }

    @Test
    public void empty() {
        ReferencedEnvelope3D bbox = new ReferencedEnvelope3D();
        Assert.assertNull((Object)bbox.getCoordinateReferenceSystem());
        ReferencedEnvelope3D australia = new ReferencedEnvelope3D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
        australia.include(40.0, 110.0, 0.0);
        australia.include(10.0, 150.0, 10.0);
        bbox.include((BoundingBox3D)australia);
        Assert.assertEquals((Object)australia.getCoordinateReferenceSystem(), (Object)bbox.getCoordinateReferenceSystem());
        Assert.assertEquals((double)0.0, (double)bbox.getMinZ(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)bbox.getMaxZ(), (double)0.0);
    }

    @Test
    public void testTransformToWGS84() throws Exception {
        String wkt = "GEOGCS[\"GDA94\", DATUM[\"Geocentric Datum of Australia 1994\",  SPHEROID[\"GRS 1980\", 6378137.0, 298.257222101, AUTHORITY[\"EPSG\",\"7019\"]],  TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],  AUTHORITY[\"EPSG\",\"6283\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AXIS[\"Ellipsoidal height\", UP],  AUTHORITY[\"EPSG\",\"4939\"]]";
        CoordinateReferenceSystem gda94 = CRS.parseWKT((String)wkt);
        ReferencedEnvelope3D bounds = new ReferencedEnvelope3D(130.875825803896, 130.898939990319, -16.4491956225999, -16.4338185791628, 0.0, 0.0, gda94);
        ReferencedEnvelope worldBounds3D = bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D, true);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84_3D, (Object)worldBounds3D.getCoordinateReferenceSystem());
        ReferencedEnvelope worldBounds2D = bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)worldBounds2D.getCoordinateReferenceSystem());
    }

    @Test
    public void testDistanceWhenMinZOfThisIsGreaterThanMaxZOfOther() {
        DefaultEngineeringCRS crs = DefaultEngineeringCRS.CARTESIAN_3D;
        ReferencedEnvelope3D a = new ReferencedEnvelope3D(2.0, 3.0, 2.0, 3.0, 2.0, 3.0, (CoordinateReferenceSystem)crs);
        ReferencedEnvelope3D b = new ReferencedEnvelope3D(0.0, 1.0, 0.0, 1.0, 0.0, 0.5, (CoordinateReferenceSystem)crs);
        Assert.assertEquals((double)Math.sqrt(4.25), (double)a.distance(b), (double)1.0E-5);
    }

    @Test
    public void testIntersectXYZ() {
        ReferencedEnvelope3D envelope = new ReferencedEnvelope3D();
        Assert.assertTrue((boolean)envelope.isNull());
        Assert.assertFalse((boolean)envelope.intersects(1.0, 2.0, 3.0));
        double x_min = 10.0;
        double x_max = 20.0;
        double x_ave = (x_min + x_max) / 2.0;
        double y_min = 30.0;
        double y_max = 40.0;
        double y_ave = (y_min + y_max) / 2.0;
        double z_min = 50.0;
        double z_max = 60.0;
        double z_ave = (z_min + z_max) / 2.0;
        envelope.init(x_min, x_max, y_min, y_max, z_min, z_max);
        Assert.assertTrue((boolean)envelope.intersects(x_ave, y_ave, z_ave));
        Assert.assertTrue((boolean)envelope.intersects(x_min, y_min, z_min));
        Assert.assertTrue((boolean)envelope.intersects(x_max, y_max, z_max));
        Assert.assertFalse((boolean)envelope.intersects(-x_ave, -y_ave, -z_ave));
        double delta = 0.1;
        Assert.assertFalse((boolean)envelope.intersects(x_min - delta, y_ave, z_ave));
        Assert.assertFalse((boolean)envelope.intersects(x_max + delta, y_ave, z_ave));
        Assert.assertFalse((boolean)envelope.intersects(x_ave, y_min - delta, z_ave));
        Assert.assertFalse((boolean)envelope.intersects(x_ave, y_max + delta, z_ave));
        Assert.assertFalse((boolean)envelope.intersects(x_ave, y_ave, z_min - delta));
        Assert.assertFalse((boolean)envelope.intersects(x_ave, y_ave, z_max + delta));
    }
}

