/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.net.URL;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.styling.StyleBuilder;
import org.junit.Assert;
import org.junit.Test;

public class GraphicImplTest {
    @Test
    public void testWithExternalGraphics() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        URL urlExternal = this.getClass().getResource("/data/sld/blob.gif");
        ExternalGraphic extg = sb.createExternalGraphic(urlExternal, "image/svg+xml");
        Graphic graphic = sb.createGraphic(extg, null, null);
        Assert.assertEquals((long)1L, (long)graphic.graphicalSymbols().size());
    }

    @Test
    public void testDisplacement() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Graphic graphic = sb.createGraphic();
        Displacement disp = sb.createDisplacement(10.1, -5.5);
        graphic.setDisplacement((org.opengis.style.Displacement)disp);
        disp = graphic.getDisplacement();
        Assert.assertNotNull((Object)disp);
        Assert.assertEquals((Object)disp.getDisplacementX().toString(), (Object)"10.1");
        Assert.assertEquals((Object)disp.getDisplacementY().toString(), (Object)"-5.5");
    }
}

