/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import org.geotools.api.geometry.Position;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransformFactory;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.GeneralPosition;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.transform.EarthGravitationalModel;
import org.junit.Assert;
import org.junit.Test;

public class EarthGravitationalModelTest {
    @Test
    public void testHeightOffsetWGS84() throws Exception {
        EarthGravitationalModel gh = new EarthGravitationalModel();
        gh.load("EGM180.nor");
        Assert.assertEquals((double)1.505, (double)gh.heightOffset(45.0, 45.0, 0.0), (double)0.001);
        Assert.assertEquals((double)1.515, (double)gh.heightOffset(45.0, 45.0, 1000.0), (double)0.001);
        Assert.assertEquals((double)46.908, (double)gh.heightOffset(0.0, 45.0, 0.0), (double)0.001);
    }

    @Test
    public void testHeightOffsetWGS72() throws Exception {
        EarthGravitationalModel gh = new EarthGravitationalModel(180, false);
        gh.load("EGM180.nor");
        Assert.assertEquals((double)1.475, (double)gh.heightOffset(45.0, 45.0, 0.0), (double)0.001);
        Assert.assertEquals((double)46.879, (double)gh.heightOffset(0.0, 45.0, 0.0), (double)0.001);
        Assert.assertEquals((double)23.324, (double)gh.heightOffset(3.0, 10.0, 10.0), (double)0.001);
        Assert.assertEquals((double)0.38, (double)gh.heightOffset(75.0, -30.0, 0.0), (double)0.001);
    }

    @Test
    public void testMathTransform() throws FactoryException, TransformException {
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup p = mtFactory.getDefaultParameters("Earth gravitational model");
        MathTransform mt = mtFactory.createParameterizedTransform(p);
        GeneralPosition pos = new GeneralPosition(new double[]{45.0, 45.0, 1000.0});
        pos = mt.transform((Position)pos, (Position)pos);
        Assert.assertEquals((double)45.0, (double)pos.getOrdinate(0), (double)0.001);
        Assert.assertEquals((double)45.0, (double)pos.getOrdinate(1), (double)0.001);
        Assert.assertEquals((double)1001.515, (double)pos.getOrdinate(2), (double)0.001);
    }
}

