/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.solr;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.data.solr.FieldLayerMapper;
import org.geotools.data.solr.FilterToSolr;
import org.geotools.data.solr.IndexesConfig;
import org.geotools.data.solr.SolrAttribute;
import org.geotools.data.solr.SolrFeatureSource;
import org.geotools.data.solr.SolrLayerConfiguration;
import org.geotools.data.solr.SolrLayerMapper;
import org.geotools.data.solr.SolrUtils;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;

public class SolrDataStore
extends ContentDataStore {
    private URL url;
    private SolrLayerMapper layerMapper;
    private List<Name> nativeTypeNames;
    private ArrayList<SolrAttribute> solrAttributes = new ArrayList();
    private SolrAttribute pk = null;
    private Map<String, SolrLayerConfiguration> solrConfigurations = new ConcurrentHashMap<String, SolrLayerConfiguration>();
    HttpSolrClient solrServer;
    private final Map<String, SimpleFeatureType> defaultFeatureTypes = new HashMap<String, SimpleFeatureType>();

    public SolrDataStore(URL url, SolrLayerMapper layerMapper, IndexesConfig indexesConfig) {
        this(url, layerMapper);
        indexesConfig.getIndexesNames().forEach(indexName -> {
            ArrayList<SolrAttribute> solrAttributes = this.getSolrAttributes((String)indexName);
            SimpleFeatureType defaultFeatureType = indexesConfig.buildFeatureType((String)indexName, (List<SolrAttribute>)solrAttributes);
            this.defaultFeatureTypes.put((String)indexName, defaultFeatureType);
        });
    }

    public SolrDataStore(URL url, String field) {
        this(url, new FieldLayerMapper(field));
    }

    public SolrDataStore(URL url, SolrLayerMapper layerMapper) {
        this.url = url;
        this.layerMapper = layerMapper;
        this.solrServer = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder().withBaseSolrUrl(url.toString()).allowCompression(true).withConnectionTimeout(10000)).withSocketTimeout(10000)).build();
        this.solrServer.setFollowRedirects(true);
    }

    public ArrayList<SolrAttribute> getSolrAttributes(String layerName) {
        if (this.solrAttributes.isEmpty()) {
            this.solrAttributes = new ArrayList();
            try {
                LukeRequest lq = new LukeRequest();
                lq.setShowSchema(true);
                LukeResponse processSchema = (LukeResponse)lq.process((SolrClient)this.solrServer);
                lq = new LukeRequest();
                lq.setShowSchema(false);
                LukeResponse processField = (LukeResponse)lq.process((SolrClient)this.solrServer);
                Map fis = processField.getFieldInfo();
                TreeSet keys = new TreeSet(fis.keySet());
                for (String k : keys) {
                    LukeResponse.FieldInfo fieldInfo = (LukeResponse.FieldInfo)fis.get(k);
                    String name = fieldInfo.getName();
                    String type = fieldInfo.getType();
                    LukeResponse.FieldTypeInfo fty = processSchema.getFieldTypeInfo(type);
                    if (fty == null) continue;
                    String solrTypeName = fty.getClassName();
                    Class<?> objType = SolrUtils.decodeSolrFieldType(solrTypeName);
                    if (objType != null) {
                        SolrUtils.ExtendedFieldSchemaInfo extendedFieldSchemaInfo = new SolrUtils.ExtendedFieldSchemaInfo(processSchema, processField, name);
                        SolrAttribute at = new SolrAttribute(name, objType);
                        at.setSolrType(solrTypeName);
                        if (extendedFieldSchemaInfo.getUniqueKey().booleanValue()) {
                            at.setPk(true);
                            at.setUse(true);
                        }
                        if (extendedFieldSchemaInfo.getMultivalued().booleanValue() && !Geometry.class.isAssignableFrom(at.getType())) {
                            at.setType(String.class);
                        }
                        at.setEmpty(fieldInfo.getDocs() == 0);
                        this.solrAttributes.add(at);
                        continue;
                    }
                    if (!this.LOGGER.isLoggable(Level.FINE)) continue;
                    this.LOGGER.log(Level.FINE, "Skipping attribute " + fty.getName() + " as we don't know how to map its type to a java object " + fty.getClassName());
                }
                Comparator<SolrAttribute> sortFields = this.getEmptyComparator();
                this.solrAttributes.sort(sortFields);
            }
            catch (Exception ex) {
                this.LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return this.solrAttributes;
    }

    private Comparator<SolrAttribute> getEmptyComparator() {
        return new BeanComparator("empty").thenComparing((Comparator)new BeanComparator("name"));
    }

    protected List<Name> createTypeNames() throws IOException {
        try {
            if (this.nativeTypeNames == null || this.nativeTypeNames.isEmpty()) {
                ArrayList<Name> temp = new ArrayList<Name>();
                for (String name : this.layerMapper.createTypeNames(this.solrServer)) {
                    temp.add((Name)new NameImpl(this.namespaceURI, name));
                }
                this.nativeTypeNames = temp;
            }
        }
        catch (Exception ex) {
            this.LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        TreeSet<Name> names = new TreeSet<Name>(this.nativeTypeNames);
        for (SolrLayerConfiguration conf : this.solrConfigurations.values()) {
            String name = conf.getLayerName();
            names.add((Name)new NameImpl(this.namespaceURI, name));
        }
        return new ArrayList<Name>(names);
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        ContentEntry type = this.ensureEntry(entry.getName());
        return new SolrFeatureSource(type, this.defaultFeatureTypes);
    }

    public FilterFactory getFilterFactory() {
        return CommonFactoryFinder.getFilterFactory();
    }

    public FilterCapabilities getFilterCapabilities() {
        FilterToSolr f2s = new FilterToSolr(null);
        return f2s.getCapabilities();
    }

    public Map<String, SolrLayerConfiguration> getSolrConfigurations() {
        return this.solrConfigurations;
    }

    public void setSolrConfigurations(SolrLayerConfiguration configuration) {
        this.entries.remove(new NameImpl(this.namespaceURI, configuration.getLayerName()));
        this.solrConfigurations.put(configuration.getLayerName(), configuration);
    }

    public URL getUrl() {
        return this.url;
    }

    public SolrLayerMapper getLayerMapper() {
        return this.layerMapper;
    }

    public SolrAttribute getPrimaryKey(String layerName) {
        if (this.pk == null) {
            ArrayList<SolrAttribute> attributes = this.getSolrAttributes(layerName);
            for (SolrAttribute at : attributes) {
                if (!at.isPk().booleanValue()) continue;
                this.pk = at;
                break;
            }
        }
        return this.pk;
    }

    protected SolrQuery select(SimpleFeatureType featureType, Query q) {
        SolrQuery query = new SolrQuery();
        query.setParam("omitHeader", true);
        try {
            if (q.getPropertyNames() != null) {
                for (String prop : q.getPropertyNames()) {
                    query.addField(prop);
                }
            }
            query.setQuery("*:*");
            if (q.getStartIndex() != null && q.getStartIndex() >= 0) {
                query.setStart(q.getStartIndex());
            }
            if (q.getMaxFeatures() > 0) {
                query.setRows(Integer.valueOf(q.getMaxFeatures()));
            }
            SolrQuery.ORDER naturalSortOrder = SolrQuery.ORDER.asc;
            if (q.getSortBy() != null) {
                for (SortBy sort : q.getSortBy()) {
                    if (sort.getPropertyName() != null) {
                        query.addSort(sort.getPropertyName().getPropertyName(), sort.getSortOrder().equals((Object)SortOrder.ASCENDING) ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
                        continue;
                    }
                    naturalSortOrder = sort.getSortOrder().equals((Object)SortOrder.ASCENDING) ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
                }
            }
            query.addSort(this.getPrimaryKey(featureType.getTypeName()).getName(), naturalSortOrder);
            FilterToSolr f2s = this.initializeFilterToSolr(featureType);
            String fq = this.layerMapper.prepareFilterQuery(featureType);
            Filter simplified = SimplifyingFilterVisitor.simplify((Filter)q.getFilter(), (FeatureType)featureType);
            String ffq = f2s.encodeToString(simplified);
            if (ffq != null && !ffq.isEmpty()) {
                fq = fq != null ? fq + " AND " + ffq : ffq;
            }
            query.setFilterQueries(new String[]{fq});
            this.addViewparams(q, query);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return query;
    }

    protected SolrQuery selectUniqueValues(SimpleFeatureType featureType, Query q, UniqueVisitor visitor) {
        SolrQuery query = this.select(featureType, q);
        query.setFields(new String[0]);
        query.setParam("group", true);
        PropertyName pname = (PropertyName)visitor.getExpression();
        query.setParam("group.field", new String[]{pname.getPropertyName()});
        query.setParam("group.limit", new String[]{"0"});
        return query;
    }

    protected SolrQuery count(SimpleFeatureType featureType, Query q) {
        SolrQuery query = new SolrQuery();
        query.setParam("omitHeader", true);
        query.setQuery("*:*");
        query.setFields(new String[]{this.getPrimaryKey(featureType.getName().getLocalPart()).getName()});
        try {
            if (q.getStartIndex() != null && q.getStartIndex() >= 0) {
                query.setStart(q.getStartIndex());
            }
            query.setRows(Integer.valueOf(0));
            FilterToSolr f2s = this.initializeFilterToSolr(featureType);
            String fq = this.layerMapper.prepareFilterQuery(featureType);
            String ffq = f2s.encodeToString(q.getFilter());
            if (ffq != null && !ffq.isEmpty()) {
                fq = fq != null ? fq + " AND " + ffq : ffq;
            }
            query.setFilterQueries(new String[]{fq});
            this.addViewparams(q, query);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return query;
    }

    private FilterToSolr initializeFilterToSolr(SimpleFeatureType featureType) {
        FilterToSolr f2s = new FilterToSolr(featureType);
        f2s.setPrimaryKey(this.getPrimaryKey(featureType.getName().getLocalPart()));
        f2s.setFeatureTypeName(featureType.getName().getLocalPart());
        return f2s;
    }

    private void addViewparams(Query q, SolrQuery query) {
        Map parameters;
        String qViewParamers = null;
        String fqViewParamers = null;
        Hints hints = q.getHints();
        if (hints != null && (parameters = (Map)hints.get((Object)Hints.VIRTUAL_TABLE_PARAMETERS)) != null) {
            for (String param : parameters.keySet()) {
                if (param.equalsIgnoreCase("q")) {
                    qViewParamers = (String)parameters.get(param);
                }
                if (!param.equalsIgnoreCase("fq")) continue;
                fqViewParamers = (String)parameters.get(param);
            }
        }
        if (qViewParamers != null && !qViewParamers.isEmpty()) {
            query.set("q", new String[]{query.get("q").concat(" AND ").concat(qViewParamers)});
        }
        if (fqViewParamers != null && !fqViewParamers.isEmpty()) {
            query.addFilterQuery(new String[]{fqViewParamers});
        }
    }

    HttpSolrClient getSolrServer() {
        return this.solrServer;
    }

    public void dispose() {
        try {
            this.solrServer.close();
        }
        catch (IOException ex) {
            this.LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            super.dispose();
        }
    }
}

