/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.kml.KML;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class MultiGeometryTypeBinding
extends AbstractComplexBinding {
    GeometryFactory geometryFactory;

    public MultiGeometryTypeBinding(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public QName getTarget() {
        return KML.MultiGeometryType;
    }

    public Class getType() {
        return GeometryCollection.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List geometries = node.getChildValues(Geometry.class);
        if (geometries.isEmpty()) {
            return this.geometryFactory.createGeometryCollection(new Geometry[0]);
        }
        Class<?> geometryClass = null;
        for (Geometry g : geometries) {
            Class<?> clazz = g.getClass();
            if (geometryClass == null) {
                geometryClass = clazz;
                continue;
            }
            if (clazz.isAssignableFrom(geometryClass) || geometryClass.isAssignableFrom(clazz)) continue;
            geometryClass = null;
            break;
        }
        if (geometryClass != null) {
            if (geometryClass == Point.class) {
                return this.geometryFactory.createMultiPoint(geometries.toArray(new Point[geometries.size()]));
            }
            if (geometryClass == LineString.class || geometryClass == LinearRing.class) {
                return this.geometryFactory.createMultiLineString(geometries.toArray(new LineString[geometries.size()]));
            }
            if (geometryClass == Polygon.class) {
                return this.geometryFactory.createMultiPolygon(geometries.toArray(new Polygon[geometries.size()]));
            }
        }
        return this.geometryFactory.createGeometryCollection(geometries.toArray(new Geometry[geometries.size()]));
    }

    public Object getProperty(Object object, QName name) throws Exception {
        GeometryCollection gc = (GeometryCollection)object;
        if (KML.Geometry.getLocalPart().equals(name.getLocalPart())) {
            Geometry[] g = new Geometry[gc.getNumGeometries()];
            for (int i = 0; i < g.length; ++i) {
                g[i] = gc.getGeometryN(i);
            }
            return g;
        }
        return null;
    }
}

