/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.config.BaseConfiguration;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.MockConfigurationResourceProvider;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.diskquota.jdbc.JDBCQuotaStore;
import org.geowebcache.diskquota.jdbc.MockSystemUtils;
import org.geowebcache.diskquota.jdbc.OnlineTestRule;
import org.geowebcache.diskquota.jdbc.SQLDialect;
import org.geowebcache.diskquota.storage.PageStats;
import org.geowebcache.diskquota.storage.PageStatsPayload;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.StorageUnit;
import org.geowebcache.diskquota.storage.SystemUtils;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.context.ApplicationContext;

public abstract class JDBCQuotaStoreTest {
    JDBCQuotaStore store;
    File targetDir;
    DefaultStorageFinder cacheDirFinder;
    TileLayerDispatcher layerDispatcher;
    TilePageCalculator tilePageCalculator;
    private BasicDataSource dataSource;
    private TileSet testTileSet;
    private StorageBroker storageBroker;
    public MockWepAppContextRule extensions = new MockWepAppContextRule();
    public OnlineTestRule fixtureRule = this.makeFixtureRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.extensions).around((TestRule)this.fixtureRule);
    Map<String, Set<String>> parameterIdsMap;
    Map<String, Set<Map<String, String>>> parametersMap;
    private Collection<TileSet> expectedTileSets;
    private String[] paramIds;

    protected JDBCFixtureRule makeFixtureRule() {
        return new JDBCFixtureRule(this.getFixtureId());
    }

    protected abstract SQLDialect getDialect();

    protected abstract String getFixtureId();

    protected BasicDataSource getDataSource() throws IOException, SQLException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.fixtureRule.getFixture().getProperty("driver"));
        dataSource.setUrl(this.fixtureRule.getFixture().getProperty("url"));
        dataSource.setUsername(this.fixtureRule.getFixture().getProperty("username"));
        dataSource.setPassword(this.fixtureRule.getFixture().getProperty("password"));
        dataSource.setPoolPreparedStatements(true);
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        dataSource.setMinIdle(1);
        dataSource.setMaxActive(4);
        dataSource.setMaxWait(5000L);
        this.cleanupDatabase((DataSource)dataSource);
        return dataSource;
    }

    protected void cleanupDatabase(DataSource dataSource) throws SQLException {
        try (Connection cx = dataSource.getConnection();
             Statement st = cx.createStatement();){
            try {
                st.execute("DROP TABLE TILEPAGE CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                st.execute("DROP TABLE TILESET CASCADE");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private XMLConfiguration loadXMLConfig() throws Exception {
        return new XMLConfiguration(null, (ConfigurationResourceProvider)new MockConfigurationResourceProvider(() -> XMLConfiguration.class.getResourceAsStream("geowebcache_130.xml")));
    }

    @Test
    public void testTableSetup() throws Exception {
        Quota global = this.store.getGloballyUsedQuota();
        Assert.assertNotNull((Object)global);
        Assert.assertEquals((Object)"___GLOBAL_QUOTA___", (Object)global.getTileSetId());
        Assert.assertEquals((long)0L, (long)global.getBytes().longValue());
        Set tileSets = this.store.getTileSets();
        Assert.assertNotNull((Object)tileSets);
        Assert.assertEquals((long)this.expectedTileSets.size(), (long)tileSets.size());
        for (TileSet tileSet : this.expectedTileSets) {
            Assert.assertTrue((boolean)tileSets.contains(tileSet));
            this.assertQuotaZero(tileSet);
        }
        this.assertQuotaZero("topp:states");
        this.assertQuotaZero("topp:states2");
        this.assertQuotaZero("topp:states3");
        this.layerDispatcher.removeLayer("topp:states");
        this.store.close();
        this.store.setDataSource((DataSource)this.getDataSource());
        this.store.initialize();
        tileSets = this.store.getTileSets();
        Assert.assertNotNull((Object)tileSets);
        Assert.assertEquals((long)4L, (long)tileSets.size());
        TileSet tileSet = new TileSet("topp:states2", "EPSG:2163", "image/png", null);
        Assert.assertTrue((boolean)tileSets.contains(tileSet));
        this.assertQuotaZero(tileSet);
        tileSet = new TileSet("topp:states2", "EPSG:2163", "image/jpeg", null);
        Assert.assertTrue((boolean)tileSets.contains(tileSet));
        this.assertQuotaZero(tileSet);
    }

    @Test
    public void testRenameLayer() throws InterruptedException {
        Assert.assertEquals((long)16L, (long)this.countTileSetsByLayerName("topp:states"));
        this.store.renameLayer("topp:states", "states_renamed");
        Assert.assertEquals((long)0L, (long)this.countTileSetsByLayerName("topp:states"));
        Assert.assertEquals((long)16L, (long)this.countTileSetsByLayerName("states_renamed"));
    }

    @Test
    public void testRenameLayer2() throws InterruptedException {
        String oldLayerName = (String)this.tilePageCalculator.getLayerNames().iterator().next();
        String newLayerName = "renamed_layer";
        Quota usedQuota = this.store.getUsedQuotaByLayerName(oldLayerName);
        Assert.assertNotNull((Object)usedQuota);
        TileSet tileSet = (TileSet)this.tilePageCalculator.getTileSetsFor(oldLayerName).iterator().next();
        TilePage page = new TilePage(tileSet.getId(), 0, 0, 0);
        this.store.addHitsAndSetAccesTime(Collections.singleton(new PageStatsPayload(page)));
        this.store.addToQuotaAndTileCounts(tileSet, new Quota(BigInteger.valueOf(1024L)), Collections.emptyList());
        Quota expectedQuota = this.store.getUsedQuotaByLayerName(oldLayerName);
        Assert.assertEquals((long)1024L, (long)expectedQuota.getBytes().longValue());
        Assert.assertNotNull((Object)this.store.getTileSetById(tileSet.getId()));
        this.store.renameLayer(oldLayerName, "renamed_layer");
        Assert.assertNull((Object)this.store.getLeastRecentlyUsedPage(Collections.singleton(oldLayerName)));
        usedQuota = this.store.getUsedQuotaByLayerName(oldLayerName);
        Assert.assertNotNull((Object)usedQuota);
        Assert.assertEquals((long)0L, (long)usedQuota.getBytes().longValue());
        Quota newLayerUsedQuota = this.store.getUsedQuotaByLayerName("renamed_layer");
        Assert.assertEquals((Object)expectedQuota.getBytes(), (Object)newLayerUsedQuota.getBytes());
    }

    @Test
    public void testDeleteGridSet() throws InterruptedException {
        String layerName1 = "topp:states";
        String layerName2 = "topp:states3";
        TileSet tset1 = new TileSet(layerName1, "EPSG:4326", "image/jpeg", this.paramIds[0]);
        TileSet tset2 = new TileSet(layerName1, "EPSG:900913", "image/jpeg", this.paramIds[0]);
        TileSet tset3 = new TileSet(layerName2, "EPSG:4326", "image/png", null);
        TileSet tset4 = new TileSet(layerName1, "EPSG:4326", "image/png", this.paramIds[0]);
        this.addToQuotaStore(tset1);
        this.addToQuotaStore(tset2);
        this.addToQuotaStore(tset3);
        this.addToQuotaStore(tset4);
        Quota tset1Quota = this.store.getUsedQuotaByTileSetId(tset1.getId());
        Quota tset2Quota = this.store.getUsedQuotaByTileSetId(tset2.getId());
        Quota tset3Quota = this.store.getUsedQuotaByTileSetId(tset3.getId());
        Quota tset4Quota = this.store.getUsedQuotaByTileSetId(tset4.getId());
        Quota globalQuota = this.store.getGloballyUsedQuota();
        Quota sum = new Quota();
        sum.add(tset1Quota);
        sum.add(tset2Quota);
        sum.add(tset3Quota);
        sum.add(tset4Quota);
        Assert.assertEquals((Object)globalQuota.getBytes(), (Object)sum.getBytes());
        Assert.assertThat((Object)this.store.getTileSets(), (Matcher)Matchers.containsInAnyOrder((Collection)this.expectedTileSets.stream().map(Matchers::equalTo).collect(Collectors.toSet())));
        this.store.deleteGridSubset(layerName1, "EPSG:4326");
        Assert.assertThat((Object)this.store.getTileSets(), (Matcher)Matchers.containsInAnyOrder((Collection)this.expectedTileSets.stream().filter(ts -> !ts.getGridsetId().equals("EPSG:4326") || !ts.getLayerName().equals(layerName1)).map(Matchers::equalTo).collect(Collectors.toSet())));
        Quota newTset1Quota = this.store.getUsedQuotaByTileSetId(tset1.getId());
        Quota newTset2Quota = this.store.getUsedQuotaByTileSetId(tset2.getId());
        Quota newTset3Quota = this.store.getUsedQuotaByTileSetId(tset3.getId());
        Quota newTset4Quota = this.store.getUsedQuotaByTileSetId(tset4.getId());
        Assert.assertNotNull((Object)newTset1Quota);
        Assert.assertEquals((Object)BigInteger.valueOf(0L), (Object)newTset1Quota.getBytes());
        Assert.assertNotNull((Object)newTset2Quota);
        Assert.assertEquals((Object)tset2Quota.getBytes(), (Object)newTset2Quota.getBytes());
        Assert.assertNotNull((Object)newTset3Quota);
        Assert.assertEquals((Object)tset3Quota.getBytes(), (Object)newTset3Quota.getBytes());
        Assert.assertNotNull((Object)newTset4Quota);
        Assert.assertEquals((Object)BigInteger.valueOf(0L), (Object)newTset4Quota.getBytes());
        globalQuota = this.store.getGloballyUsedQuota();
        Assert.assertEquals((Object)tset2Quota.getBytes().add(tset3Quota.getBytes()), (Object)globalQuota.getBytes());
    }

    @Test
    public void testDeleteParameters() throws InterruptedException {
        String layerName = "topp:states";
        TileSet tset1 = new TileSet(layerName, "EPSG:4326", "image/jpeg", this.paramIds[0]);
        this.addToQuotaStore(tset1);
        TileSet tset2 = new TileSet(layerName, "EPSG:4326", "image/jpeg", this.paramIds[1]);
        this.addToQuotaStore(tset2);
        Quota tset1Quota = this.store.getUsedQuotaByTileSetId(tset1.getId());
        Quota tset2Quota = this.store.getUsedQuotaByTileSetId(tset2.getId());
        Quota globalQuota = this.store.getGloballyUsedQuota();
        Quota sum = new Quota();
        sum.add(tset1Quota);
        sum.add(tset2Quota);
        Assert.assertEquals((Object)globalQuota.getBytes(), (Object)sum.getBytes());
        Assert.assertThat((Object)this.store.getTileSets(), (Matcher)Matchers.containsInAnyOrder((Collection)this.expectedTileSets.stream().map(Matchers::equalTo).collect(Collectors.toSet())));
        this.store.deleteParameters("topp:states", this.paramIds[1]);
        Assert.assertThat((Object)this.store.getTileSets(), (Matcher)Matchers.containsInAnyOrder((Collection)this.expectedTileSets.stream().filter(ts -> !Objects.equal((Object)ts.getParametersId(), (Object)this.paramIds[1]) || !ts.getLayerName().equals(layerName)).map(Matchers::equalTo).collect(Collectors.toSet())));
        tset1Quota = this.store.getUsedQuotaByTileSetId(tset1.getId());
        tset2Quota = this.store.getUsedQuotaByTileSetId(tset2.getId());
        Assert.assertNotNull((Object)tset2Quota);
        Assert.assertEquals((Object)BigInteger.valueOf(0L), (Object)tset2Quota.getBytes());
        globalQuota = this.store.getGloballyUsedQuota();
        Assert.assertEquals((Object)tset1Quota.getBytes(), (Object)globalQuota.getBytes());
    }

    private void addToQuotaStore(TileSet tset) throws InterruptedException {
        Quota quotaDiff = new Quota(5.0, StorageUnit.MiB);
        PageStatsPayload stats = new PageStatsPayload(new TilePage(tset.getId(), 0, 0, 3));
        stats.setNumTiles(10);
        this.store.addToQuotaAndTileCounts(tset, quotaDiff, Collections.singletonList(stats));
    }

    @Test
    public void testDeleteLayer() throws InterruptedException {
        String layerName = "topp:states2";
        TileSet tset = new TileSet(layerName, "EPSG:2163", "image/jpeg", null);
        this.addToQuotaStore(tset);
        Quota oldUsedQuota = this.store.getUsedQuotaByLayerName(layerName);
        Assert.assertNotNull((Object)oldUsedQuota);
        Quota globalQuotaBefore = this.store.getGloballyUsedQuota();
        Assert.assertTrue((oldUsedQuota.getBytes().longValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((globalQuotaBefore.getBytes().longValue() > 0L ? 1 : 0) != 0);
        TileSet tileSet = (TileSet)this.tilePageCalculator.getTileSetsFor(layerName).iterator().next();
        TilePage page = new TilePage(tileSet.getId(), 0, 0, 0);
        this.store.addHitsAndSetAccesTime(Collections.singleton(new PageStatsPayload(page)));
        Assert.assertNotNull((Object)this.store.getTileSetById(tileSet.getId()));
        Thread.sleep(100L);
        this.store.deleteLayer(layerName);
        Assert.assertNull((Object)this.store.getLeastRecentlyUsedPage(Collections.singleton(layerName)));
        Quota usedQuota = this.store.getUsedQuotaByLayerName(layerName);
        Assert.assertNotNull((Object)usedQuota);
        Assert.assertEquals((long)0L, (long)usedQuota.getBytes().longValue());
        Quota globalQuotaAfter = this.store.getGloballyUsedQuota();
        Assert.assertEquals((long)0L, (long)globalQuotaAfter.getBytes().longValue());
    }

    @Test
    public void testVisitor() throws Exception {
        Set tileSets1 = this.store.getTileSets();
        HashSet tileSets2 = new HashSet();
        this.store.accept((tileSet, quotaStore) -> tileSets2.add(tileSet));
        Assert.assertEquals((Object)tileSets1, tileSets2);
    }

    @Test
    public void testGetTileSetById() throws Exception {
        TileSet tileSet = this.store.getTileSetById(this.testTileSet.getId());
        Assert.assertNotNull((Object)tileSet);
        Assert.assertEquals((Object)this.testTileSet, (Object)tileSet);
        try {
            this.store.getTileSetById("NonExistentTileSetId");
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testGetUsedQuotaByLayerName() throws Exception {
        String layerName = "topp:states2";
        ArrayList tileSets = new ArrayList(this.tilePageCalculator.getTileSetsFor(layerName));
        Quota expected = new Quota();
        for (TileSet tset : tileSets) {
            Quota quotaDiff = new Quota(10.0, StorageUnit.MiB);
            expected.add(quotaDiff);
            this.store.addToQuotaAndTileCounts(tset, quotaDiff, (Collection)Collections.EMPTY_SET);
        }
        Quota usedQuotaByLayerName = this.store.getUsedQuotaByLayerName(layerName);
        Assert.assertEquals((Object)expected.getBytes(), (Object)usedQuotaByLayerName.getBytes());
    }

    @Test
    public void testGetUsedQuotaByTileSetId() throws Exception {
        String layerName = "topp:states2";
        ArrayList tileSets = new ArrayList(this.tilePageCalculator.getTileSetsFor(layerName));
        HashMap<String, Quota> expectedById = new HashMap<String, Quota>();
        for (TileSet tileSet : tileSets) {
            Quota quotaDiff = new Quota(10.0 * Math.random(), StorageUnit.MiB);
            this.store.addToQuotaAndTileCounts(tileSet, quotaDiff, (Collection)Collections.EMPTY_SET);
            this.store.addToQuotaAndTileCounts(tileSet, quotaDiff, (Collection)Collections.EMPTY_SET);
            Quota tsetQuota = new Quota(quotaDiff);
            tsetQuota.add(quotaDiff);
            expectedById.put(tileSet.getId(), tsetQuota);
        }
        for (Map.Entry entry : expectedById.entrySet()) {
            BigInteger expectedValaue = ((Quota)entry.getValue()).getBytes();
            String tsetId = (String)entry.getKey();
            Assert.assertEquals((Object)expectedValaue, (Object)this.store.getUsedQuotaByTileSetId(tsetId).getBytes());
        }
    }

    @Test
    public void testUpdateUsedQuotaWithParameters() throws Exception {
        String paramId = DigestUtils.sha1Hex((String)"&styles=polygon");
        TileSet tset = new TileSet("topp:states2", "EPSG:2163", "image/jpeg", paramId);
        Quota quotaDiff = new Quota(10.0 * Math.random(), StorageUnit.MiB);
        PageStatsPayload stats = new PageStatsPayload(new TilePage(tset.getId(), 0, 0, 3));
        stats.setNumTiles(10);
        this.store.addToQuotaAndTileCounts(tset, quotaDiff, Collections.singletonList(stats));
        Assert.assertEquals((Object)quotaDiff.getBytes(), (Object)this.store.getUsedQuotaByTileSetId(tset.getId()).getBytes());
    }

    @Test
    public void testPageStatsGathering() throws Exception {
        MockSystemUtils sysUtils = new MockSystemUtils();
        sysUtils.setCurrentTimeMinutes(10);
        sysUtils.setCurrentTimeMillis(600000L);
        SystemUtils.set((SystemUtils)sysUtils);
        TileSet tileSet = this.testTileSet;
        TilePage page = new TilePage(tileSet.getId(), 0, 0, 0);
        PageStatsPayload payload = new PageStatsPayload(page);
        int numHits = 100;
        payload.setTileSet(tileSet);
        payload.setLastAccessTime(sysUtils.currentTimeMillis() - 60000L);
        payload.setNumHits(numHits);
        payload.setNumTiles(1);
        this.store.addToQuotaAndTileCounts(tileSet, new Quota(1.0, StorageUnit.MiB), Collections.singleton(payload));
        Future result = this.store.addHitsAndSetAccesTime(Collections.singleton(payload));
        List allStats = (List)result.get();
        PageStats stats = (PageStats)allStats.get(0);
        float fillFactor = stats.getFillFactor();
        Assert.assertEquals((double)1.0, (double)fillFactor, (double)1.0E-6);
        int lastAccessTimeMinutes = stats.getLastAccessTimeMinutes();
        Assert.assertEquals((long)sysUtils.currentTimeMinutes(), (long)lastAccessTimeMinutes);
        float frequencyOfUsePerMinute = stats.getFrequencyOfUsePerMinute();
        Assert.assertEquals((float)100.0f, (float)frequencyOfUsePerMinute, (float)1.0E-6f);
        sysUtils.setCurrentTimeMinutes(sysUtils.currentTimeMinutes() + 2);
        sysUtils.setCurrentTimeMillis(sysUtils.currentTimeMillis() + 120000L);
        numHits = 10;
        payload.setLastAccessTime(sysUtils.currentTimeMillis() - 60000L);
        payload.setNumHits(numHits);
        result = this.store.addHitsAndSetAccesTime(Collections.singleton(payload));
        allStats = (List)result.get();
        stats = (PageStats)allStats.get(0);
        lastAccessTimeMinutes = stats.getLastAccessTimeMinutes();
        Assert.assertEquals((long)11L, (long)lastAccessTimeMinutes);
        frequencyOfUsePerMinute = stats.getFrequencyOfUsePerMinute();
        float expected = 55.0f;
        Assert.assertEquals((float)expected, (float)frequencyOfUsePerMinute, (float)1.0E-6f);
    }

    @Test
    public void testGetGloballyUsedQuota() throws InterruptedException {
        Quota usedQuota = this.store.getGloballyUsedQuota();
        Assert.assertNotNull((Object)usedQuota);
        Assert.assertEquals((long)0L, (long)usedQuota.getBytes().intValue());
        String layerName = (String)this.tilePageCalculator.getLayerNames().iterator().next();
        TileSet tileSet = (TileSet)this.tilePageCalculator.getTileSetsFor(layerName).iterator().next();
        Quota quotaDiff = new Quota(BigInteger.valueOf(1000L));
        Set tileCountDiffs = Collections.emptySet();
        this.store.addToQuotaAndTileCounts(tileSet, quotaDiff, tileCountDiffs);
        usedQuota = this.store.getGloballyUsedQuota();
        Assert.assertNotNull((Object)usedQuota);
        Assert.assertEquals((long)1000L, (long)usedQuota.getBytes().intValue());
        quotaDiff = new Quota(BigInteger.valueOf(-500L));
        this.store.addToQuotaAndTileCounts(tileSet, quotaDiff, tileCountDiffs);
        usedQuota = this.store.getGloballyUsedQuota();
        Assert.assertNotNull((Object)usedQuota);
        Assert.assertEquals((long)500L, (long)usedQuota.getBytes().intValue());
    }

    @Test
    public void testSetTruncated() throws Exception {
        String tileSetId = this.testTileSet.getId();
        TilePage page = new TilePage(tileSetId, 0, 0, 2);
        PageStatsPayload payload = new PageStatsPayload(page);
        payload.setTileSet(this.testTileSet);
        int numHits = 100;
        payload.setNumHits(numHits);
        payload.setNumTiles(5);
        this.store.addToQuotaAndTileCounts(this.testTileSet, new Quota(1.0, StorageUnit.MiB), Collections.singleton(payload));
        List stats = (List)this.store.addHitsAndSetAccesTime(Collections.singleton(payload)).get();
        Assert.assertTrue((((PageStats)stats.get(0)).getFillFactor() > 0.0f ? 1 : 0) != 0);
        PageStats pageStats = this.store.setTruncated(page);
        Assert.assertEquals((float)0.0f, (float)pageStats.getFillFactor(), (float)1.0E-6f);
    }

    @Test
    public void testGetLeastFrequentlyUsedPage() throws Exception {
        String layerName = this.testTileSet.getLayerName();
        Set<String> layerNames = Collections.singleton(layerName);
        TilePage lfuPage = this.store.getLeastFrequentlyUsedPage(layerNames);
        Assert.assertNull((Object)lfuPage);
        TilePage page1 = new TilePage(this.testTileSet.getId(), 0, 1, 2);
        TilePage page2 = new TilePage(this.testTileSet.getId(), 1, 1, 2);
        PageStatsPayload payload1 = new PageStatsPayload(page1, this.testTileSet);
        PageStatsPayload payload2 = new PageStatsPayload(page2, this.testTileSet);
        payload1.setNumHits(100);
        payload2.setNumHits(10);
        List<PageStatsPayload> statsUpdates = Arrays.asList(payload1, payload2);
        this.store.addHitsAndSetAccesTime(statsUpdates).get();
        TilePage leastFrequentlyUsedPage = this.store.getLeastFrequentlyUsedPage(layerNames);
        Assert.assertEquals((Object)page2, (Object)leastFrequentlyUsedPage);
        payload2.setNumHits(1000);
        this.store.addHitsAndSetAccesTime(statsUpdates).get();
        leastFrequentlyUsedPage = this.store.getLeastFrequentlyUsedPage(layerNames);
        Assert.assertEquals((Object)page1, (Object)leastFrequentlyUsedPage);
    }

    @Test
    public void testGetLeastFrequentlyUsedPageSkipEmpty() throws Exception {
        String layerName = this.testTileSet.getLayerName();
        Set<String> layerNames = Collections.singleton(layerName);
        TilePage lfuPage = this.store.getLeastFrequentlyUsedPage(layerNames);
        Assert.assertNull((Object)lfuPage);
        TilePage page1 = new TilePage(this.testTileSet.getId(), 0, 1, 2);
        TilePage page2 = new TilePage(this.testTileSet.getId(), 1, 1, 2);
        PageStatsPayload payload1 = new PageStatsPayload(page1, this.testTileSet);
        PageStatsPayload payload2 = new PageStatsPayload(page2, this.testTileSet);
        payload1.setNumHits(100);
        payload2.setNumHits(10);
        List<PageStatsPayload> statsUpdates = Arrays.asList(payload1, payload2);
        this.store.addHitsAndSetAccesTime(statsUpdates).get();
        TilePage leastFrequentlyUsedPage = this.store.getLeastFrequentlyUsedPage(layerNames);
        Assert.assertEquals((Object)page2, (Object)leastFrequentlyUsedPage);
        this.store.setTruncated(page2);
        leastFrequentlyUsedPage = this.store.getLeastFrequentlyUsedPage(layerNames);
        Assert.assertEquals((Object)page1, (Object)leastFrequentlyUsedPage);
    }

    @Test
    public void testGetLeastRecentlyUsedPage() throws Exception {
        MockSystemUtils mockSystemUtils = new MockSystemUtils();
        mockSystemUtils.setCurrentTimeMinutes(1000);
        mockSystemUtils.setCurrentTimeMillis(mockSystemUtils.currentTimeMinutes() * 60 * 1000);
        SystemUtils.set((SystemUtils)mockSystemUtils);
        String layerName = this.testTileSet.getLayerName();
        Set<String> layerNames = Collections.singleton(layerName);
        TilePage leastRecentlyUsedPage = this.store.getLeastRecentlyUsedPage(layerNames);
        Assert.assertNull((Object)leastRecentlyUsedPage);
        TilePage page1 = new TilePage(this.testTileSet.getId(), 0, 1, 2);
        TilePage page2 = new TilePage(this.testTileSet.getId(), 1, 1, 2);
        PageStatsPayload payload1 = new PageStatsPayload(page1, this.testTileSet);
        PageStatsPayload payload2 = new PageStatsPayload(page2, this.testTileSet);
        payload1.setLastAccessTime(mockSystemUtils.currentTimeMillis() + 60000L);
        payload2.setLastAccessTime(mockSystemUtils.currentTimeMillis() + 120000L);
        List<PageStatsPayload> statsUpdates = Arrays.asList(payload1, payload2);
        this.store.addHitsAndSetAccesTime(statsUpdates).get();
        leastRecentlyUsedPage = this.store.getLeastRecentlyUsedPage(layerNames);
        Assert.assertEquals((Object)page1, (Object)leastRecentlyUsedPage);
        payload1.setLastAccessTime(mockSystemUtils.currentTimeMillis() + 600000L);
        this.store.addHitsAndSetAccesTime(statsUpdates).get();
        leastRecentlyUsedPage = this.store.getLeastRecentlyUsedPage(layerNames);
        Assert.assertEquals((Object)page2, (Object)leastRecentlyUsedPage);
    }

    @Test
    public void testGetLeastRecentlyUsedPageSkipEmpty() throws Exception {
        MockSystemUtils mockSystemUtils = new MockSystemUtils();
        mockSystemUtils.setCurrentTimeMinutes(1000);
        mockSystemUtils.setCurrentTimeMillis(mockSystemUtils.currentTimeMinutes() * 60 * 1000);
        SystemUtils.set((SystemUtils)mockSystemUtils);
        String layerName = this.testTileSet.getLayerName();
        Set<String> layerNames = Collections.singleton(layerName);
        TilePage leastRecentlyUsedPage = this.store.getLeastRecentlyUsedPage(layerNames);
        Assert.assertNull((Object)leastRecentlyUsedPage);
        TilePage page1 = new TilePage(this.testTileSet.getId(), 0, 1, 2);
        TilePage page2 = new TilePage(this.testTileSet.getId(), 1, 1, 2);
        PageStatsPayload payload1 = new PageStatsPayload(page1, this.testTileSet);
        PageStatsPayload payload2 = new PageStatsPayload(page2, this.testTileSet);
        payload1.setLastAccessTime(mockSystemUtils.currentTimeMillis() + 60000L);
        payload2.setLastAccessTime(mockSystemUtils.currentTimeMillis() + 120000L);
        List<PageStatsPayload> statsUpdates = Arrays.asList(payload1, payload2);
        this.store.addHitsAndSetAccesTime(statsUpdates).get();
        leastRecentlyUsedPage = this.store.getLeastRecentlyUsedPage(layerNames);
        Assert.assertEquals((Object)page1, (Object)leastRecentlyUsedPage);
        this.store.setTruncated(page1);
        leastRecentlyUsedPage = this.store.getLeastRecentlyUsedPage(layerNames);
        Assert.assertEquals((Object)page2, (Object)leastRecentlyUsedPage);
    }

    @Test
    public void testGetTilesForPage() throws Exception {
        TilePage page = new TilePage(this.testTileSet.getId(), 0, 0, 0);
        long[][] expected = this.tilePageCalculator.toGridCoverage(this.testTileSet, page);
        long[][] tilesForPage = this.store.getTilesForPage(page);
        Assert.assertArrayEquals((long[])expected[0], (long[])tilesForPage[0]);
        page = new TilePage(this.testTileSet.getId(), 0, 0, 1);
        expected = this.tilePageCalculator.toGridCoverage(this.testTileSet, page);
        tilesForPage = this.store.getTilesForPage(page);
        Assert.assertArrayEquals((long[])expected[1], (long[])tilesForPage[1]);
    }

    private int countTileSetsByLayerName(String layerName) {
        int count = 0;
        for (TileSet ts : this.store.getTileSets()) {
            if (!layerName.equals(ts.getLayerName())) continue;
            ++count;
        }
        return count;
    }

    private void assertQuotaZero(TileSet tileSet) {
        Quota quota = this.store.getUsedQuotaByTileSetId(tileSet.getId());
        Assert.assertNotNull((Object)quota);
        Assert.assertEquals((long)0L, (long)quota.getBytes().longValue());
    }

    private void assertQuotaZero(String layerName) throws InterruptedException {
        Quota quota = this.store.getUsedQuotaByLayerName(layerName);
        Assert.assertNotNull((Object)quota);
        Assert.assertEquals((long)0L, (long)quota.getBytes().longValue());
    }

    protected class JDBCFixtureRule
    extends OnlineTestRule {
        protected JDBCFixtureRule(String fixtureId) {
            super(fixtureId);
        }

        @Override
        protected void disconnect() throws Exception {
            JDBCQuotaStoreTest.this.store.close();
        }

        @Override
        protected boolean isOnline() throws Exception {
            return true;
        }

        @Override
        protected void setUpInternal() throws Exception {
            JDBCQuotaStoreTest.this.targetDir = new File("target", "mockStore");
            FileUtils.deleteDirectory((File)JDBCQuotaStoreTest.this.targetDir);
            JDBCQuotaStoreTest.this.targetDir.mkdirs();
            JDBCQuotaStoreTest.this.cacheDirFinder = (DefaultStorageFinder)EasyMock.createMock(DefaultStorageFinder.class);
            EasyMock.expect((Object)JDBCQuotaStoreTest.this.cacheDirFinder.getDefaultPath()).andReturn((Object)JDBCQuotaStoreTest.this.targetDir.getAbsolutePath()).anyTimes();
            EasyMock.expect((Object)JDBCQuotaStoreTest.this.cacheDirFinder.findEnvVar((String)EasyMock.eq((Object)"GWC_DISKQUOTA_DISABLED"))).andReturn(null).anyTimes();
            EasyMock.replay((Object[])new Object[]{JDBCQuotaStoreTest.this.cacheDirFinder});
            XMLConfiguration xmlConfig = JDBCQuotaStoreTest.this.loadXMLConfig();
            JDBCQuotaStoreTest.this.extensions.addBean("xmlConfig", (Object)xmlConfig, new Class[]{BaseConfiguration.class, TileLayerConfiguration.class, GridSetConfiguration.class});
            XMLConfiguration extraConfig = new XMLConfiguration(JDBCQuotaStoreTest.this.extensions.getContextProvider(), (ConfigurationResourceProvider)new MockConfigurationResourceProvider(() -> ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("gwc-test-config.xml")));
            JDBCQuotaStoreTest.this.extensions.addBean("extraConfig", (Object)extraConfig, new Class[]{BaseConfiguration.class, TileLayerConfiguration.class, GridSetConfiguration.class});
            JDBCQuotaStoreTest.this.extensions.addBean("defaultGridsets", (Object)new DefaultGridsets(true, true), new Class[]{GridSetConfiguration.class, DefaultGridsets.class});
            GridSetBroker broker = new GridSetBroker();
            broker.setApplicationContext((ApplicationContext)JDBCQuotaStoreTest.this.extensions.getMockContext());
            JDBCQuotaStoreTest.this.extensions.addBean("gridSetBroker", (Object)broker, new Class[]{GridSetBroker.class});
            xmlConfig.setGridSetBroker(broker);
            extraConfig.setGridSetBroker(broker);
            JDBCQuotaStoreTest.this.layerDispatcher = new TileLayerDispatcher(broker, null);
            JDBCQuotaStoreTest.this.layerDispatcher.setApplicationContext((ApplicationContext)JDBCQuotaStoreTest.this.extensions.getMockContext());
            broker.afterPropertiesSet();
            xmlConfig.afterPropertiesSet();
            extraConfig.afterPropertiesSet();
            JDBCQuotaStoreTest.this.layerDispatcher.afterPropertiesSet();
            Capture layerNameCap = EasyMock.newCapture();
            JDBCQuotaStoreTest.this.storageBroker = (StorageBroker)EasyMock.createMock(StorageBroker.class);
            EasyMock.expect((Object)JDBCQuotaStoreTest.this.storageBroker.getCachedParameterIds((String)EasyMock.capture((Capture)layerNameCap))).andStubAnswer(() -> JDBCQuotaStoreTest.this.parameterIdsMap.getOrDefault(layerNameCap.getValue(), Collections.singleton(null)));
            EasyMock.replay((Object[])new Object[]{JDBCQuotaStoreTest.this.storageBroker});
            JDBCQuotaStoreTest.this.parametersMap = new HashMap<String, Set<Map<String, String>>>();
            JDBCQuotaStoreTest.this.parametersMap.put("topp:states", Stream.of("STYLE=&SOMEPARAMETER=", "STYLE=population&SOMEPARAMETER=2.0").map(ParametersUtils::getMap).collect(Collectors.toSet()));
            JDBCQuotaStoreTest.this.parameterIdsMap = JDBCQuotaStoreTest.this.parametersMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Set)e.getValue()).stream().map(ParametersUtils::getKvp).collect(Collectors.toSet())));
            JDBCQuotaStoreTest.this.tilePageCalculator = new TilePageCalculator(JDBCQuotaStoreTest.this.layerDispatcher, JDBCQuotaStoreTest.this.storageBroker);
            JDBCQuotaStoreTest.this.dataSource = JDBCQuotaStoreTest.this.getDataSource();
            SQLDialect dialect = JDBCQuotaStoreTest.this.getDialect();
            JDBCQuotaStoreTest.this.store = new JDBCQuotaStore(JDBCQuotaStoreTest.this.cacheDirFinder, JDBCQuotaStoreTest.this.tilePageCalculator);
            JDBCQuotaStoreTest.this.store.setDataSource((DataSource)JDBCQuotaStoreTest.this.dataSource);
            JDBCQuotaStoreTest.this.store.setDialect(dialect);
            JDBCQuotaStoreTest.this.store.initialize();
            JDBCQuotaStoreTest.this.testTileSet = (TileSet)JDBCQuotaStoreTest.this.tilePageCalculator.getTileSetsFor("topp:states2").iterator().next();
            JDBCQuotaStoreTest.this.paramIds = JDBCQuotaStoreTest.this.parameterIdsMap.get("topp:states").toArray(new String[2]);
            JDBCQuotaStoreTest.this.expectedTileSets = Arrays.asList(new TileSet("topp:states", "EPSG:900913", "image/png", JDBCQuotaStoreTest.this.paramIds[0]), new TileSet("topp:states", "EPSG:900913", "image/jpeg", JDBCQuotaStoreTest.this.paramIds[0]), new TileSet("topp:states", "EPSG:900913", "image/gif", JDBCQuotaStoreTest.this.paramIds[0]), new TileSet("topp:states", "EPSG:900913", "application/vnd.google-earth.kml+xml", JDBCQuotaStoreTest.this.paramIds[0]), new TileSet("topp:states", "EPSG:4326", "image/png", JDBCQuotaStoreTest.this.paramIds[0]), new TileSet("topp:states", "EPSG:4326", "image/jpeg", JDBCQuotaStoreTest.this.paramIds[0]), new TileSet("topp:states", "EPSG:4326", "image/gif", JDBCQuotaStoreTest.this.paramIds[0]), new TileSet("topp:states", "EPSG:4326", "application/vnd.google-earth.kml+xml", JDBCQuotaStoreTest.this.paramIds[0]), new TileSet("topp:states", "EPSG:900913", "image/png", JDBCQuotaStoreTest.this.paramIds[1]), new TileSet("topp:states", "EPSG:900913", "image/jpeg", JDBCQuotaStoreTest.this.paramIds[1]), new TileSet("topp:states", "EPSG:900913", "image/gif", JDBCQuotaStoreTest.this.paramIds[1]), new TileSet("topp:states", "EPSG:900913", "application/vnd.google-earth.kml+xml", JDBCQuotaStoreTest.this.paramIds[1]), new TileSet("topp:states", "EPSG:4326", "image/png", JDBCQuotaStoreTest.this.paramIds[1]), new TileSet("topp:states", "EPSG:4326", "image/jpeg", JDBCQuotaStoreTest.this.paramIds[1]), new TileSet("topp:states", "EPSG:4326", "image/gif", JDBCQuotaStoreTest.this.paramIds[1]), new TileSet("topp:states", "EPSG:4326", "application/vnd.google-earth.kml+xml", JDBCQuotaStoreTest.this.paramIds[1]), new TileSet("topp:states2", "EPSG:2163", "image/png", null), new TileSet("topp:states2", "EPSG:2163", "image/jpeg", null), new TileSet("topp:states3", "EPSG:4326", "image/png", null), new TileSet("topp:states3", "EPSG:2163", "image/png", null));
        }

        @Override
        protected void tearDownInternal() throws Exception {
            JDBCQuotaStoreTest.this.store.close();
        }
    }
}

