/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.utils;

import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.services.dto.ShortAttribute;
import it.geosolutions.geostore.services.dto.search.AndFilter;
import it.geosolutions.geostore.services.dto.search.AttributeFilter;
import it.geosolutions.geostore.services.dto.search.BaseField;
import it.geosolutions.geostore.services.dto.search.CategoryFilter;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.rest.model.RESTCategory;
import it.geosolutions.geostore.services.rest.model.RESTQuickBackup;
import it.geosolutions.geostore.services.rest.model.RESTResource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class FilterUnmarshalTest
extends TestCase {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Test
    public void testGetContext() throws JDOMException, IOException {
        AndFilter searchFilter = new AndFilter((SearchFilter)new FieldFilter(BaseField.NAME, "%", SearchOperator.LIKE), (SearchFilter)new CategoryFilter("theCategoryName", SearchOperator.EQUAL_TO), new SearchFilter[]{new AttributeFilter("theLayerName", "layer", DataType.STRING, SearchOperator.EQUAL_TO)});
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)searchFilter, (Writer)writer);
        String xml = writer.toString();
        System.out.println("Marshalled Filter is " + xml);
        StringReader reader = new StringReader(xml);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)reader);
        Element root = doc.detachRootElement();
        FilterUnmarshalTest.assertEquals((String)"AND", (String)root.getName());
        FilterUnmarshalTest.assertNotNull((Object)root.getChild("FIELD"));
        FilterUnmarshalTest.assertNotNull((Object)root.getChild("CATEGORY"));
        FilterUnmarshalTest.assertNotNull((Object)root.getChild("ATTRIBUTE"));
    }

    @Test
    public void testPrintRESTResource() throws JDOMException, IOException {
        RESTResource rr = new RESTResource();
        rr.setId(Long.valueOf(42L));
        rr.setName("TestResource");
        rr.setDescription("This is a sample RESTResource");
        rr.setCreation(new Date());
        rr.setLastUpdate(new Date());
        rr.setCategory(new RESTCategory("TestCategory"));
        rr.setData("Sample data content");
        rr.setMetadata("Sample metadata content");
        ArrayList<ShortAttribute> attr = new ArrayList<ShortAttribute>();
        attr.add(new ShortAttribute("attname1", "attvalue1", DataType.STRING));
        attr.add(new ShortAttribute("attname2", "42", DataType.NUMBER));
        rr.setAttribute(attr);
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)rr, (Writer)writer);
        String xml = writer.toString();
        System.out.println("Marshalled RESTResource is " + xml);
    }

    @Test
    public void testPrintBackup() throws JDOMException, IOException, JAXBException {
        RESTQuickBackup bk = new RESTQuickBackup();
        RESTQuickBackup.RESTBackupCategory c1 = new RESTQuickBackup.RESTBackupCategory();
        c1.setName("cat1");
        c1.getResources().add(FilterUnmarshalTest.createBKResource("res1", "cat1"));
        c1.getResources().add(FilterUnmarshalTest.createBKResource("res2", "cat1"));
        bk.addCategory(c1);
        RESTQuickBackup.RESTBackupCategory c2 = new RESTQuickBackup.RESTBackupCategory();
        c2.setName("cat2");
        c2.getResources().add(FilterUnmarshalTest.createBKResource("resX", "cat2"));
        c2.getResources().add(FilterUnmarshalTest.createBKResource("resY", "cat2"));
        bk.addCategory(c2);
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)bk, (Writer)writer);
        String xml = writer.toString();
        System.out.println("Marshalled Backup is " + xml);
    }

    protected static RESTQuickBackup.RESTBackupResource createBKResource(String name, String catName) {
        RESTQuickBackup.RESTBackupResource r1 = new RESTQuickBackup.RESTBackupResource();
        r1.setResource(FilterUnmarshalTest.createRESTResource(name, catName));
        return r1;
    }

    protected static RESTResource createRESTResource(String name, String catName) {
        RESTResource rr1 = new RESTResource();
        rr1.setName(name);
        rr1.setCategory(new RESTCategory(catName));
        rr1.setAttribute(new ArrayList());
        rr1.getAttribute().add(new ShortAttribute("att_x_" + name, "test", DataType.STRING));
        return rr1;
    }
}

