/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.InternalErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.RESTAttribute;
import it.geosolutions.geostore.services.rest.model.RESTResource;
import it.geosolutions.geostore.services.rest.model.ResourceList;
import it.geosolutions.geostore.services.rest.model.SecurityRuleList;
import it.geosolutions.geostore.services.rest.model.ShortAttributeList;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.springframework.security.access.annotation.Secured;

@Secured(value={"ROLE_ADMIN"})
public interface RESTResourceService {
    @POST
    @Path(value="/")
    @Consumes(value={"application/xml", "text/xml"})
    @Produces(value={"text/plain"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN"})
    public long insert(@Context SecurityContext var1, @Multipart(value="resource") RESTResource var2) throws InternalErrorWebEx;

    @PUT
    @Path(value="/resource/{id}")
    @Consumes(value={"application/xml", "text/xml"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN"})
    public long update(@Context SecurityContext var1, @PathParam(value="id") long var2, @Multipart(value="resource") RESTResource var4) throws NotFoundWebEx, BadRequestWebEx;

    @DELETE
    @Path(value="/resource/{id}")
    @Secured(value={"ROLE_USER", "ROLE_ADMIN"})
    public void delete(@Context SecurityContext var1, @PathParam(value="id") long var2) throws NotFoundWebEx;

    @DELETE
    @Path(value="/")
    @Secured(value={"ROLE_ADMIN"})
    public void deleteResources(@Context SecurityContext var1, @Multipart(value="filter") SearchFilter var2) throws BadRequestWebEx, InternalErrorWebEx;

    @GET
    @Path(value="/resource/{id}")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public Resource get(@Context SecurityContext var1, @PathParam(value="id") long var2, @QueryParam(value="full") @DefaultValue(value="false") boolean var4) throws NotFoundWebEx;

    @GET
    @Path(value="/")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public ShortResourceList getAll(@Context SecurityContext var1, @QueryParam(value="page") Integer var2, @QueryParam(value="entries") Integer var3) throws BadRequestWebEx;

    @GET
    @Path(value="/search/{nameLike}")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public ShortResourceList getList(@Context SecurityContext var1, @PathParam(value="nameLike") String var2, @QueryParam(value="page") Integer var3, @QueryParam(value="entries") Integer var4) throws BadRequestWebEx;

    @POST
    @GET
    @Path(value="/search")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Consumes(value={"application/xml", "text/xml"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    @Deprecated
    public ShortResourceList getResources(@Context SecurityContext var1, @Multipart(value="filter") SearchFilter var2) throws BadRequestWebEx, InternalErrorWebEx;

    @POST
    @GET
    @Path(value="/search/list")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Consumes(value={"application/xml", "text/xml"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public ResourceList getResourcesList(@Context SecurityContext var1, @QueryParam(value="page") Integer var2, @QueryParam(value="entries") Integer var3, @QueryParam(value="includeAttributes") @DefaultValue(value="false") boolean var4, @QueryParam(value="includeData") @DefaultValue(value="false") boolean var5, @Multipart(value="filter") SearchFilter var6) throws BadRequestWebEx, InternalErrorWebEx;

    @GET
    @Path(value="/count/{nameLike}")
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public long getCount(@Context SecurityContext var1, @PathParam(value="nameLike") String var2);

    @GET
    @Path(value="/resource/{id}/attributes")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public ShortAttributeList getAttributes(@Context SecurityContext var1, @PathParam(value="id") long var2) throws NotFoundWebEx;

    @GET
    @Path(value="/resource/{id}/attributes/{name}")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public String getAttribute(@Context SecurityContext var1, @PathParam(value="id") long var2, @PathParam(value="name") String var4) throws NotFoundWebEx;

    @PUT
    @Path(value="/resource/{id}/attributes/")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Consumes(value={"application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public long updateAttribute(@Context SecurityContext var1, @PathParam(value="id") long var2, RESTAttribute var4);

    @PUT
    @Path(value="/resource/{id}/attributes/{name}/{value}")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public long updateAttribute(@Context SecurityContext var1, @PathParam(value="id") long var2, @PathParam(value="name") String var4, @PathParam(value="value") String var5);

    @PUT
    @Path(value="/resource/{id}/attributes/{name}/{value}/{type}")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public long updateAttribute(@Context SecurityContext var1, @PathParam(value="id") long var2, @PathParam(value="name") String var4, @PathParam(value="value") String var5, @PathParam(value="type") DataType var6);

    @POST
    @Path(value="/resource/{id}/permissions")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN"})
    public void updateSecurityRules(@Context SecurityContext var1, @PathParam(value="id") long var2, @Multipart(value="rules") SecurityRuleList var4);

    @GET
    @Path(value="/resource/{id}/permissions")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN"})
    public SecurityRuleList getSecurityRules(@Context SecurityContext var1, @PathParam(value="id") long var2);
}

