/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.model;

import it.geosolutions.geostore.services.rest.model.RESTResource;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Backup")
public class RESTQuickBackup
implements Serializable {
    private Collection<RESTBackupCategory> categories = new LinkedList<RESTBackupCategory>();

    @XmlElement(name="category")
    public Collection<RESTBackupCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(Collection<RESTBackupCategory> categories) {
        this.categories = categories;
    }

    public void addCategory(RESTBackupCategory cat) {
        this.categories.add(cat);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        if (this.categories != null) {
            sb.append("categories(").append(this.categories.size()).append(")");
            for (RESTBackupCategory cat : this.categories) {
                sb.append('{').append(cat.getName());
                for (RESTBackupResource res : cat.getResources()) {
                    sb.append('[').append(res.getResource().getName()).append(']');
                }
                sb.append('}');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public static class RESTBackupResource {
        RESTResource resource;

        public RESTResource getResource() {
            return this.resource;
        }

        public void setResource(RESTResource resource) {
            this.resource = resource;
        }
    }

    public static class RESTBackupAuth {
    }

    public static class RESTBackupCategory {
        Long id;
        String name;
        RESTBackupAuth auth;
        List<RESTBackupResource> resources = new LinkedList<RESTBackupResource>();

        public RESTBackupAuth getAuth() {
            return this.auth;
        }

        public void setAuth(RESTBackupAuth auth) {
            this.auth = auth;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<RESTBackupResource> getResources() {
            return this.resources;
        }

        public void setResources(List<RESTBackupResource> resources) {
            this.resources = resources;
        }

        public void addResource(RESTBackupResource resource) {
            this.resources.add(resource);
        }
    }
}

