/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.model;

import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity(name="Security")
@Table(name="gs_security", uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "resource_id"}), @UniqueConstraint(columnNames={"resource_id", "group_id"})}, indexes={@Index(name="idx_security_resource", columnList="resource_id"), @Index(name="idx_security_user", columnList="user_id"), @Index(name="idx_security_group", columnList="group_id"), @Index(name="idx_security_read", columnList="canread"), @Index(name="idx_security_write", columnList="canwrite"), @Index(name="idx_security_username", columnList="username"), @Index(name="idx_security_groupname", columnList="groupname")})
@XmlRootElement(name="Security")
public class SecurityRule
implements Serializable {
    private static final long serialVersionUID = -4160546863296343389L;
    @Id
    @GeneratedValue
    private Long id;
    @ManyToOne(optional=true)
    @JoinColumn(foreignKey=@ForeignKey(name="fk_security_resource"))
    private Resource resource;
    @ManyToOne(optional=true)
    @JoinColumn(foreignKey=@ForeignKey(name="fk_security_user"))
    private User user;
    @ManyToOne(optional=true)
    @JoinColumn(foreignKey=@ForeignKey(name="fk_security_group"))
    private UserGroup group;
    @Column(nullable=false, updatable=true)
    private boolean canRead;
    @Column(nullable=false, updatable=true)
    private boolean canWrite;
    @Column(nullable=true, updatable=true)
    private String username;
    @Column(nullable=true, updatable=true)
    private String groupname;

    @PreUpdate
    @PrePersist
    public void onPreUpdate() throws Exception {
    }

    @XmlTransient
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @XmlTransient
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @XmlTransient
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @XmlTransient
    public UserGroup getGroup() {
        return this.group;
    }

    public void setGroup(UserGroup group) {
        this.group = group;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getGroupname() {
        return this.groupname;
    }

    public void setGroupname(String groupname) {
        this.groupname = groupname;
    }

    @XmlTransient
    public boolean isCanRead() {
        return this.canRead;
    }

    public void setCanRead(boolean canRead) {
        this.canRead = canRead;
    }

    @XmlTransient
    public boolean isCanWrite() {
        return this.canWrite;
    }

    public void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[');
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        builder.append(", ");
        builder.append("canRead=").append(this.canRead);
        builder.append(", ");
        builder.append("canWrite=").append(this.canWrite);
        if (this.resource != null) {
            builder.append(", ");
            builder.append("resource=").append(this.resource);
        }
        if (this.group != null) {
            builder.append(", ");
            builder.append("group=").append(this.group);
        }
        if (this.user != null) {
            builder.append(", ");
            builder.append("user=").append(this.user);
        }
        builder.append(']');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canRead ? 1231 : 1237);
        result = 31 * result + (this.canWrite ? 1231 : 1237);
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityRule other = (SecurityRule)obj;
        if (this.canRead != other.canRead) {
            return false;
        }
        if (this.canWrite != other.canWrite) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

