/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.model;

import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.Type;

@Entity(name="UserGroup")
@Table(name="gs_usergroup", uniqueConstraints={@UniqueConstraint(columnNames={"groupName"})}, indexes={@Index(name="idx_usergroup_name", columnList="groupName")})
@XmlRootElement(name="UserGroup")
public class UserGroup
implements Serializable {
    private static final long serialVersionUID = 6065837305601115748L;
    @Id
    @GeneratedValue
    private Long id;
    @Column(nullable=false, updatable=false, length=255)
    private String groupName;
    @Column(nullable=true, updatable=true, length=255)
    private String description;
    @OneToMany(mappedBy="group", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<SecurityRule> security;
    @Type(type="yes_no")
    @Column(nullable=false, updatable=true)
    private boolean enabled = true;
    private transient List<User> users = new ArrayList<User>();
    @OneToMany(mappedBy="userGroup", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<UserGroupAttribute> attributes;

    @XmlTransient
    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @XmlTransient
    public List<SecurityRule> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRule> security) {
        this.security = security;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlTransient
    public List<UserGroupAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<UserGroupAttribute> attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[');
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        if (this.groupName != null) {
            builder.append(", ");
            builder.append("groupName=").append(this.groupName);
        }
        if (this.users != null) {
            builder.append(", ");
            builder.append("users=").append(this.users);
        }
        builder.append(']');
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UserGroup other = (UserGroup)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return this.groupName != null && this.groupName.equals(other.groupName);
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        return this.groupName != null ? this.groupName.hashCode() : 0;
    }
}

