/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.model;

import com.sun.xml.bind.CycleRecoverable;
import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.StoredData;
import it.geosolutions.geostore.core.model.Tag;
import it.geosolutions.geostore.core.model.User;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@Entity(name="Resource")
@Table(name="gs_resource", uniqueConstraints={@UniqueConstraint(columnNames={"name"})}, indexes={@Index(name="idx_resource_name", columnList="name"), @Index(name="idx_resource_description", columnList="description"), @Index(name="idx_resource_creation", columnList="creation"), @Index(name="idx_resource_update", columnList="lastUpdate"), @Index(name="idx_resource_metadata", columnList="metadata"), @Index(name="idx_resource_advertised", columnList="advertised"), @Index(name="idx_resource_category", columnList="category_id")})
@XmlRootElement(name="Resource")
public class Resource
implements Serializable,
CycleRecoverable {
    private static final long serialVersionUID = 4852100679788007328L;
    @Id
    @GeneratedValue
    private Long id;
    @Column(nullable=false, updatable=true)
    private String name;
    @Column(nullable=true, updatable=true, length=10000)
    private String description;
    @Column(nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creation;
    @Column(nullable=true, updatable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastUpdate;
    @Column(nullable=true, updatable=true)
    private String creator;
    @Column(nullable=true, updatable=true)
    private String editor;
    @Column(nullable=true, updatable=true, columnDefinition="bool default true")
    private Boolean advertised = true;
    @Column(nullable=true, updatable=true, length=30000)
    private String metadata;
    @OneToMany(mappedBy="resource", cascade={CascadeType.REMOVE}, fetch=FetchType.EAGER)
    private List<Attribute> attribute;
    @OneToOne(mappedBy="resource", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private StoredData data;
    @ManyToOne(optional=false)
    private Category category;
    @OneToMany(mappedBy="resource", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<SecurityRule> security;
    @ManyToMany(mappedBy="resources", fetch=FetchType.EAGER)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Set<Tag> tags;
    @ManyToMany(mappedBy="favorites", fetch=FetchType.LAZY)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Set<User> favoritedBy;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreation() {
        return this.creation;
    }

    public void setCreation(Date creation) {
        this.creation = creation;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public Boolean isAdvertised() {
        return this.advertised;
    }

    public void setAdvertised(Boolean advertised) {
        this.advertised = advertised;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @XmlElementWrapper(name="Attributes")
    public List<Attribute> getAttribute() {
        return this.attribute;
    }

    public void setAttribute(List<Attribute> attribute) {
        this.attribute = attribute;
    }

    public StoredData getData() {
        return this.data;
    }

    public void setData(StoredData data) {
        this.data = data;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    @XmlTransient
    public List<SecurityRule> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRule> security) {
        this.security = security;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    @XmlTransient
    public Set<User> getFavoritedBy() {
        return this.favoritedBy;
    }

    public void setFavoritedBy(Set<User> favoritedBy) {
        this.favoritedBy = favoritedBy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[');
        if (this.name != null) {
            builder.append("name=").append(this.name);
        }
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        if (this.creation != null) {
            builder.append(", ");
            builder.append("creation=").append(this.creation);
        }
        if (this.lastUpdate != null) {
            builder.append(", ");
            builder.append("lastUpdate=").append(this.lastUpdate);
        }
        if (this.metadata != null) {
            builder.append(", ");
            builder.append("metadata=").append(this.metadata);
        }
        if (this.attribute != null) {
            builder.append(", ");
            builder.append("attribute=").append(this.attribute);
        }
        if (this.data != null) {
            builder.append(", ");
            builder.append("data=").append(this.data);
        }
        if (this.category != null) {
            builder.append(", ");
            builder.append("category=").append(this.category);
        }
        if (this.creator != null) {
            builder.append(", ");
            builder.append("creator=").append(this.creator);
        }
        if (this.editor != null) {
            builder.append(", ");
            builder.append("editor=").append(this.editor);
        }
        if (this.advertised != null) {
            builder.append(", ");
            builder.append("advertised=").append(this.advertised);
        }
        if (this.tags != null) {
            builder.append(", ");
            builder.append("tags=").append(this.tags);
        }
        builder.append(']');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.creation == null ? 0 : this.creation.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lastUpdate == null ? 0 : this.lastUpdate.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.creator == null ? 0 : this.creator.hashCode());
        result = 31 * result + (this.editor == null ? 0 : this.editor.hashCode());
        result = 31 * result + (this.advertised == null ? 0 : this.advertised.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute)) {
            return false;
        }
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.creation == null ? other.creation != null : !this.creation.equals(other.creation)) {
            return false;
        }
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lastUpdate == null ? other.lastUpdate != null : !this.lastUpdate.equals(other.lastUpdate)) {
            return false;
        }
        if (this.advertised == null ? other.advertised != null : !this.advertised.equals(other.advertised)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.security == null) {
            return other.security == null;
        }
        if (!this.security.equals(other.security)) {
            return false;
        }
        if (this.creator == null) {
            return other.creator == null;
        }
        if (!this.creator.equals(other.creator)) {
            return false;
        }
        if (this.editor == null) {
            return other.editor == null;
        }
        return this.editor.equals(other.editor);
    }

    public Object onCycleDetected(CycleRecoverable.Context arg0) {
        Resource r = new Resource();
        r.setCreation(this.creation);
        r.setDescription(this.description);
        r.setLastUpdate(this.lastUpdate);
        r.setAdvertised(this.advertised);
        r.setMetadata(this.metadata);
        r.setName(this.name);
        r.setAttribute(null);
        r.setData(null);
        r.setCreator(this.creator);
        r.setEditor(this.editor);
        return r;
    }
}

