/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.model.enums;

import it.geosolutions.geostore.core.model.UserGroup;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public enum GroupReservedNames {
    EVERYONE("everyone");

    private final String groupNameToPersist;

    private GroupReservedNames(String groupNameToPersist) {
        this.groupNameToPersist = groupNameToPersist;
    }

    public String groupName() {
        return this.groupNameToPersist;
    }

    public static boolean isAllowedName(String groupNameToCheck) {
        return !EVERYONE.groupName().equalsIgnoreCase(groupNameToCheck);
    }

    public static Set<UserGroup> checkReservedGroups(Collection<UserGroup> groups) {
        HashSet<UserGroup> result = new HashSet<UserGroup>();
        for (UserGroup ug : groups) {
            if (!GroupReservedNames.isAllowedName(ug.getGroupName())) continue;
            result.add(ug);
        }
        return result;
    }
}

