/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.impl;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.UserGroupDAO;
import it.geosolutions.geostore.core.dao.impl.BaseDAO;
import it.geosolutions.geostore.core.model.UserGroup;
import java.io.Serializable;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Hibernate;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value="geostoreTransactionManager")
public class UserGroupDAOImpl
extends BaseDAO<UserGroup, Long>
implements UserGroupDAO {
    private static final Logger LOGGER = LogManager.getLogger(UserGroupDAOImpl.class);

    public void persist(UserGroup ... entities) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Inserting new entities for Attribute ... ");
        }
        super.persist((Object[])entities);
    }

    @Override
    public List<UserGroup> findAll() {
        return super.findAll();
    }

    @Override
    public UserGroup find(Long id) {
        UserGroup group = (UserGroup)super.find((Serializable)id);
        if (group != null) {
            this.initializeLazyMembers(group);
        }
        return group;
    }

    private void initializeLazyMembers(UserGroup group) {
        if (Hibernate.isInitialized((Object)group)) {
            List attributes = group.getAttributes();
            Hibernate.initialize((Object)attributes);
            List secRules = group.getSecurity();
            Hibernate.initialize((Object)secRules);
        }
    }

    @Override
    public UserGroup findByName(String name) {
        Search searchCriteria = new Search(UserGroup.class);
        searchCriteria.addFilterEqual("groupName", (Object)name);
        UserGroup result = null;
        List<UserGroup> existingGroups = this.search((ISearch)searchCriteria);
        if (existingGroups.size() > 0) {
            result = existingGroups.get(0);
            this.initializeLazyMembers(result);
        }
        return result;
    }

    @Override
    public List<UserGroup> search(ISearch search) {
        return super.search(search);
    }

    @Override
    public UserGroup merge(UserGroup entity) {
        return (UserGroup)super.merge((Object)entity);
    }

    @Override
    public boolean remove(UserGroup entity) {
        return super.remove((Object)entity);
    }

    @Override
    public boolean removeById(Long id) {
        return super.removeById((Serializable)id);
    }
}

