/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao;

import it.geosolutions.geostore.core.dao.BaseDAOTest;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

public class UserAttributeDAOTest
extends BaseDAOTest {
    private static final Logger LOGGER = LogManager.getLogger(UserAttributeDAOTest.class);

    @Test
    public void testPersistRole() throws Exception {
        String VALUE1 = "value1";
        String VALUE2 = "value2";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting Role");
        }
        HashSet<UserGroup> groups = new HashSet<UserGroup>();
        UserGroup g1 = new UserGroup();
        g1.setGroupName("GROUP1");
        UserGroup g2 = new UserGroup();
        g2.setGroupName("GROUP2");
        groups.add(g1);
        groups.add(g2);
        userGroupDAO.persist((Object[])new UserGroup[]{g1});
        userGroupDAO.persist((Object[])new UserGroup[]{g2});
        UserAttributeDAOTest.assertEquals((int)2, (int)userGroupDAO.count(null));
        UserAttributeDAOTest.assertEquals((int)2, (int)userGroupDAO.findAll().size());
        User user = new User();
        user.setGroups(groups);
        user.setName("USER_NAME");
        user.setNewPassword("user");
        user.setRole(Role.ADMIN);
        userDAO.persist((Object[])new User[]{user});
        UserAttributeDAOTest.assertEquals((int)1, (int)userDAO.count(null));
        UserAttributeDAOTest.assertEquals((int)1, (int)userDAO.findAll().size());
        UserAttribute attribute = new UserAttribute();
        attribute.setName("attr1");
        attribute.setValue("value1");
        attribute.setUser(user);
        userAttributeDAO.persist((Object[])new UserAttribute[]{attribute});
        long attributeId = attribute.getId();
        UserAttributeDAOTest.assertEquals((int)1, (int)userAttributeDAO.count(null));
        UserAttributeDAOTest.assertEquals((int)1, (int)userAttributeDAO.findAll().size());
        UserAttribute loaded = (UserAttribute)userAttributeDAO.find(Long.valueOf(attributeId));
        UserAttributeDAOTest.assertNotNull((String)"Can't retrieve UserAttribute", (Object)loaded);
        UserAttributeDAOTest.assertEquals((String)"value1", (String)loaded.getValue());
        loaded.setValue("value2");
        userAttributeDAO.merge((Object)loaded);
        loaded = (UserAttribute)userAttributeDAO.find(Long.valueOf(attributeId));
        UserAttributeDAOTest.assertNotNull((String)"Can't retrieve UserAttribute", (Object)loaded);
        UserAttributeDAOTest.assertEquals((String)"value2", (String)loaded.getValue());
        loaded = (UserAttribute)userAttributeDAO.find(Long.valueOf(attributeId));
        UserAttributeDAOTest.assertNotNull((String)"Can't retrieve Role", (Object)loaded);
        userAttributeDAO.removeById(Long.valueOf(attributeId));
        UserAttributeDAOTest.assertNull((String)"Role not deleted", (Object)userAttributeDAO.find(Long.valueOf(attributeId)));
    }
}

