/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.impl;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.CategoryDAO;
import it.geosolutions.geostore.core.dao.impl.BaseDAO;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.SecurityRule;
import java.io.Serializable;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value="geostoreTransactionManager")
public class CategoryDAOImpl
extends BaseDAO<Category, Long>
implements CategoryDAO {
    private static final Logger LOGGER = LogManager.getLogger(CategoryDAOImpl.class);

    public void persist(Category ... entities) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Inserting new entities for Category ... ");
        }
        super.persist((Object[])entities);
    }

    @Override
    public List<Category> findAll() {
        return super.findAll();
    }

    @Override
    public List<Category> search(ISearch search) {
        return super.search(search);
    }

    @Override
    public Category merge(Category entity) {
        return (Category)super.merge((Object)entity);
    }

    @Override
    public boolean remove(Category entity) {
        return super.remove((Object)entity);
    }

    @Override
    public boolean removeById(Long id) {
        return super.removeById((Serializable)id);
    }

    @Override
    public List<SecurityRule> findUserSecurityRule(String userName, long categoryId) {
        Search searchCriteria = new Search(Category.class);
        searchCriteria.addField("security");
        Filter securityFilter = Filter.some((String)"security", (Filter)Filter.and((Filter[])new Filter[]{Filter.equal((String)"category.id", (Object)categoryId), Filter.equal((String)"user.name", (Object)userName)}));
        searchCriteria.addFilter(securityFilter);
        return super.search((ISearch)searchCriteria);
    }

    @Override
    public List<SecurityRule> findGroupSecurityRule(List<String> userGroups, long categoryId) {
        Search searchCriteria = new Search(Category.class);
        searchCriteria.addField("security");
        Filter securityFilter = Filter.some((String)"security", (Filter)Filter.and((Filter[])new Filter[]{Filter.equal((String)"category.id", (Object)categoryId), Filter.equal((String)"user.groups.groupName", userGroups)}));
        searchCriteria.addFilter(securityFilter);
        return super.search((ISearch)searchCriteria);
    }
}

