/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.ldap.impl;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.directory.DirContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.ldap.control.SortControlDirContextProcessor;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.LdapTemplate;

public abstract class LdapBaseDAOImpl {
    protected String searchBase = "";
    protected String baseFilter = "cn=*";
    protected String nameAttribute = "cn";
    protected String descriptionAttribute = "description";
    protected boolean sortEnabled = false;
    protected ContextSource contextSource;
    protected LdapTemplate template;

    public LdapBaseDAOImpl(ContextSource contextSource) {
        this.contextSource = contextSource;
        this.template = new LdapTemplate(contextSource);
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public String getBaseFilter() {
        return this.baseFilter;
    }

    public void setBaseFilter(String filter) {
        this.baseFilter = filter;
    }

    public String getNameAttribute() {
        return this.nameAttribute;
    }

    public void setNameAttribute(String nameAttribute) {
        this.nameAttribute = nameAttribute;
    }

    public String getDescriptionAttribute() {
        return this.descriptionAttribute;
    }

    public void setDescriptionAttribute(String descriptionAttribute) {
        this.descriptionAttribute = descriptionAttribute;
    }

    protected DirContextProcessor getProcessorForSearch(ISearch search) {
        if (this.sortEnabled && search.getSorts() != null && search.getSorts().size() == 1) {
            return new SortControlDirContextProcessor(this.nameAttribute);
        }
        return new NullDirContextProcessor();
    }

    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    public void setSortEnabled(boolean sortEnabled) {
        this.sortEnabled = sortEnabled;
    }

    protected String combineFilters(String baseFilter, String ldapFilter) {
        if ("".equals(baseFilter)) {
            return ldapFilter;
        }
        if ("".equals(ldapFilter)) {
            return baseFilter;
        }
        return "(& (" + baseFilter + ") (" + ldapFilter + "))";
    }

    protected String getLdapFilter(ISearch search, Map<String, Object> propertyMapper) {
        String currentFilter = "";
        for (Filter filter : search.getFilters()) {
            currentFilter = this.combineFilters(currentFilter, this.getLdapFilter(filter, propertyMapper));
        }
        if ("".equals(currentFilter)) {
            return "(objectClass=*)";
        }
        return currentFilter;
    }

    private String getLdapFilter(Filter filter, Map<String, Object> propertyMapper) {
        String property = filter.getProperty();
        Map mapper = propertyMapper;
        if (propertyMapper.containsKey(property)) {
            if (propertyMapper.get(property) instanceof String) {
                property = (String)propertyMapper.get(property);
            } else if (propertyMapper.get(property) instanceof Map) {
                mapper = (Map)propertyMapper.get(property);
            }
        }
        switch (filter.getOperator()) {
            case 0: {
                return property + "=" + filter.getValue().toString();
            }
            case 200: {
                return this.getLdapFilter((Filter)filter.getValue(), mapper);
            }
            case 7: {
                return property + "=" + filter.getValue().toString().replaceAll("[%]", "*");
            }
            case 8: {
                return this.getInLdapFilter(property, (List)filter.getValue());
            }
        }
        return "";
    }

    private String getInLdapFilter(String property, List values) {
        ArrayList<CallSite> filters = new ArrayList<CallSite>();
        for (Object value : values) {
            filters.add((CallSite)((Object)("(" + property + "=" + value.toString() + ")")));
        }
        return StringUtils.join(filters, (String)"|");
    }

    protected boolean isNested(ISearch search) {
        boolean found = false;
        for (Filter filter : search.getFilters()) {
            found = found || this.isNested(filter);
        }
        return found;
    }

    private boolean isNested(Filter filter) {
        return filter.getOperator() == 200 || filter.getOperator() == 201;
    }

    protected ISearch getNestedSearch(ISearch search) {
        ArrayList<Filter> newFilters = new ArrayList<Filter>();
        for (Filter filter : search.getFilters()) {
            Filter nestedFilter = this.getNestedFilter(filter);
            if (nestedFilter != null) {
                newFilters.add(nestedFilter);
                continue;
            }
            newFilters.add(filter);
        }
        search.getFilters().clear();
        search.getFilters().addAll(newFilters);
        return search;
    }

    protected Filter getNestedFilter(Filter filter) {
        if (filter.getOperator() == 200 || filter.getOperator() == 201) {
            return (Filter)filter.getValue();
        }
        return null;
    }

    protected Expression getSearchExpression(ISearch search) {
        String expression = "";
        for (Filter filter : search.getFilters()) {
            expression = this.combineExpressions(expression, this.getSearchExpression(filter));
        }
        if ("".equals(expression)) {
            expression = "true";
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        return parser.parseExpression(expression);
    }

    protected String combineExpressions(String expression, String searchExpression) {
        if ("".equals(expression)) {
            return searchExpression;
        }
        if ("".equals(searchExpression)) {
            return expression;
        }
        return "(" + expression + ") && (" + searchExpression + ")";
    }

    private String getSearchExpression(Filter filter) {
        switch (filter.getOperator()) {
            case 0: {
                return filter.getProperty() + "=='" + filter.getValue().toString() + "'";
            }
            case 7: {
                return filter.getProperty() + " matches '^" + filter.getValue().toString().replace("*", ".*") + "$'";
            }
        }
        return "";
    }

    public static final class NullDirContextProcessor
    implements DirContextProcessor {
        public void postProcess(DirContext ctx) {
        }

        public void preProcess(DirContext ctx) {
        }
    }
}

