/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao;

import it.geosolutions.geostore.core.dao.BaseDAOTest;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.StoredData;
import java.util.Date;
import org.junit.Test;

public class StoredDataDAOTest
extends BaseDAOTest {
    @Test
    public void testPersistData() throws Exception {
        String NAME1 = "FIRST_DATA";
        String NAME2 = "SECOND_DATA";
        Category category = new Category();
        category.setName("MAP");
        categoryDAO.persist((Object[])new Category[]{category});
        StoredDataDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
        StoredDataDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
        Resource resource = new Resource();
        resource.setName("FIRST_DATA");
        resource.setCreation(new Date());
        resource.setCategory(category);
        resourceDAO.persist((Object[])new Resource[]{resource});
        StoredDataDAOTest.assertEquals((int)1, (int)resourceDAO.count(null));
        StoredDataDAOTest.assertEquals((int)1, (int)resourceDAO.findAll().size());
        StoredData data = new StoredData();
        data.setData("FIRST_DATA");
        data.setResource(resource);
        data.setId(resource.getId().longValue());
        storedDataDAO.persist((Object[])new StoredData[]{data});
        long id = data.getId();
        StoredDataDAOTest.assertEquals((int)1, (int)storedDataDAO.count(null));
        StoredDataDAOTest.assertEquals((int)1, (int)storedDataDAO.findAll().size());
        StoredDataDAOTest.assertEquals((Object)data.getId(), (Object)resource.getId());
        StoredData loaded = (StoredData)storedDataDAO.find(Long.valueOf(id));
        StoredDataDAOTest.assertNotNull((String)"Can't retrieve data", (Object)loaded);
        StoredDataDAOTest.assertEquals((String)"FIRST_DATA", (String)loaded.getData());
        loaded.setData("SECOND_DATA");
        storedDataDAO.merge((Object)loaded);
        loaded = (StoredData)storedDataDAO.find(Long.valueOf(id));
        StoredDataDAOTest.assertNotNull((String)"Can't retrieve data", (Object)loaded);
        StoredDataDAOTest.assertEquals((String)"SECOND_DATA", (String)loaded.getData());
        storedDataDAO.removeById(Long.valueOf(id));
        StoredDataDAOTest.assertNull((String)"Data not deleted", (Object)storedDataDAO.find(Long.valueOf(id)));
    }

    public void testBigData() {
        int CAPACITY = 500000;
        Category category = new Category();
        category.setName("BIG_TEST");
        categoryDAO.persist((Object[])new Category[]{category});
        StoredDataDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
        StoredDataDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
        Resource resource = new Resource();
        resource.setName("BIG_RESOURCE");
        resource.setCategory(category);
        resourceDAO.persist((Object[])new Resource[]{resource});
        StoredDataDAOTest.assertEquals((int)1, (int)resourceDAO.count(null));
        StoredDataDAOTest.assertEquals((int)1, (int)resourceDAO.findAll().size());
        StringBuilder sb = new StringBuilder(500000);
        for (int i = 0; i < 500000; ++i) {
            sb.append(i % 10);
        }
        System.out.println("SB is " + sb.length() + " chars long");
        StoredData data = new StoredData();
        data.setData(sb.toString());
        data.setResource(resource);
        data.setId(resource.getId().longValue());
        storedDataDAO.persist((Object[])new StoredData[]{data});
        long id = data.getId();
        StoredData loaded = (StoredData)storedDataDAO.find(Long.valueOf(id));
        StoredDataDAOTest.assertNotNull((String)"Can't retrieve data", (Object)loaded);
        StoredDataDAOTest.assertEquals((int)500000, (int)loaded.getData().length());
    }
}

