/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.ldap;

import it.geosolutions.geostore.core.ldap.IterableNamingEnumeration;
import it.geosolutions.geostore.core.ldap.MockDirContextOperations;
import java.util.Arrays;
import java.util.Collections;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.springframework.ldap.core.DirContextAdapter;

public abstract class BaseDAOTest {
    protected DirContext buildContextForUsers() {
        return new DirContextAdapter(){

            public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
                if ("ou=users".equals(name)) {
                    if ("cn=*".equals(filter)) {
                        SearchResult sr1 = new SearchResult("cn=*", null, (Object)new MockDirContextOperations(){

                            public String getNameInNamespace() {
                                return "cn=username,ou=users";
                            }

                            public String getStringAttribute(String name) {
                                if ("cn".equals(name)) {
                                    return "username";
                                }
                                return "";
                            }
                        }, new BasicAttributes());
                        SearchResult sr2 = new SearchResult("cn=*", null, (Object)new MockDirContextOperations(){

                            public String getNameInNamespace() {
                                return "cn=username2,ou=users";
                            }

                            public String getStringAttribute(String name) {
                                if ("cn".equals(name)) {
                                    return "username2";
                                }
                                return "";
                            }
                        }, new BasicAttributes());
                        return new IterableNamingEnumeration(Arrays.asList(sr1, sr2));
                    }
                    if ("(& (cn=*) (cn=username))".equals(filter)) {
                        SearchResult sr = new SearchResult("cn=*", null, (Object)new MockDirContextOperations(){

                            public String getNameInNamespace() {
                                return "cn=username,ou=users";
                            }

                            public String getStringAttribute(String name) {
                                if ("cn".equals(name)) {
                                    return "username";
                                }
                                return "";
                            }
                        }, new BasicAttributes());
                        return new IterableNamingEnumeration(Collections.singletonList(sr));
                    }
                    if ("(& (cn=*) (cn=username2))".equals(filter)) {
                        SearchResult sr = new SearchResult("cn=*", null, (Object)new MockDirContextOperations(){

                            public String getNameInNamespace() {
                                return "cn=username2,ou=users";
                            }

                            public String getStringAttribute(String name) {
                                if ("cn".equals(name)) {
                                    return "username2";
                                }
                                return "";
                            }
                        }, new BasicAttributes());
                        return new IterableNamingEnumeration(Collections.singletonList(sr));
                    }
                }
                return new IterableNamingEnumeration((Iterable)Collections.EMPTY_LIST);
            }
        };
    }

    protected DirContext buildContextForGroupsMembership(final String memberString) {
        return new DirContextAdapter(){

            public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
                if ("ou=groups".equals(name) && "(& (cn=*) (cn=group))".equals(filter)) {
                    SearchResult sr = new SearchResult("cn=*", null, (Object)new MockDirContextOperations(){

                        public String getNameInNamespace() {
                            return "cn=group,ou=groups";
                        }

                        public String getStringAttribute(String name) {
                            if ("cn".equals(name)) {
                                return "group";
                            }
                            return "";
                        }

                        public String[] getStringAttributes(String name) {
                            if ("member".equals(name)) {
                                return new String[]{memberString == null ? "username" : memberString};
                            }
                            return new String[0];
                        }
                    }, new BasicAttributes());
                    return new IterableNamingEnumeration(Collections.singletonList(sr));
                }
                return new IterableNamingEnumeration((Iterable)Collections.EMPTY_LIST);
            }
        };
    }

    protected DirContext buildContextForGroups() {
        return new DirContextAdapter(){

            public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
                if ("ou=groups".equals(name)) {
                    if ("cn=*".equals(filter)) {
                        SearchResult sr1 = new SearchResult("cn=*", null, (Object)new MockDirContextOperations(){

                            public String getNameInNamespace() {
                                return "cn=group,ou=groups";
                            }

                            public String getStringAttribute(String name) {
                                if ("cn".equals(name)) {
                                    return "group";
                                }
                                return "";
                            }
                        }, new BasicAttributes());
                        SearchResult sr2 = new SearchResult("cn=*", null, (Object)new MockDirContextOperations(){

                            public String getNameInNamespace() {
                                return "cn=group2,ou=groups";
                            }

                            public String getStringAttribute(String name) {
                                if ("cn".equals(name)) {
                                    return "group2";
                                }
                                return "";
                            }
                        }, new BasicAttributes());
                        return new IterableNamingEnumeration(Arrays.asList(sr1, sr2));
                    }
                    if ("(& (cn=*) (cn=group))".equals(filter)) {
                        SearchResult sr = new SearchResult("cn=*", null, (Object)new MockDirContextOperations(){

                            public String getNameInNamespace() {
                                return "cn=group,ou=groups";
                            }

                            public String getStringAttribute(String name) {
                                if ("cn".equals(name)) {
                                    return "group";
                                }
                                return "";
                            }

                            public String[] getStringAttributes(String name) {
                                if ("member".equals(name)) {
                                    return new String[]{"username"};
                                }
                                return super.getStringAttributes(name);
                            }
                        }, new BasicAttributes());
                        return new IterableNamingEnumeration(Collections.singletonList(sr));
                    }
                    if ("(& (cn=*) (member=cn=username,ou=users))".contentEquals(filter)) {
                        SearchResult sr1 = new SearchResult("cn=*", null, (Object)new MockDirContextOperations(){

                            public String getNameInNamespace() {
                                return "cn=group,ou=groups";
                            }

                            public String getStringAttribute(String name) {
                                if ("cn".equals(name)) {
                                    return "group";
                                }
                                return "";
                            }

                            public String[] getStringAttributes(String name) {
                                if ("member".equals(name)) {
                                    return new String[]{"username"};
                                }
                                return super.getStringAttributes(name);
                            }
                        }, new BasicAttributes());
                        SearchResult sr2 = new SearchResult("cn=*", null, (Object)new MockDirContextOperations(){

                            public String getNameInNamespace() {
                                return "cn=admin,ou=groups";
                            }

                            public String getStringAttribute(String name) {
                                if ("cn".equals(name)) {
                                    return "admin";
                                }
                                return "";
                            }
                        }, new BasicAttributes());
                        return new IterableNamingEnumeration(Arrays.asList(sr1, sr2));
                    }
                    if ("(& (cn=*) (member=cn=username2,ou=users))".contentEquals(filter)) {
                        SearchResult sr = new SearchResult("cn=*", null, (Object)new MockDirContextOperations(){

                            public String getNameInNamespace() {
                                return "cn=group,ou=groups";
                            }

                            public String getStringAttribute(String name) {
                                if ("cn".equals(name)) {
                                    return "group";
                                }
                                return "";
                            }
                        }, new BasicAttributes());
                        return new IterableNamingEnumeration(Collections.singletonList(sr));
                    }
                }
                return new IterableNamingEnumeration((Iterable)Collections.EMPTY_LIST);
            }
        };
    }
}

