/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao;

import it.geosolutions.geostore.core.dao.BaseDAOTest;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

public class ExternalSecurityDAOTest
extends BaseDAOTest {
    private static final Logger LOGGER = LogManager.getLogger(ExternalSecurityDAOTest.class);

    @Test
    public void testPersistSecurity() throws Exception {
        String NAME = "NAME";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting Security");
        }
        Category category = new Category();
        category.setName("MAP");
        categoryDAO.persist((Object[])new Category[]{category});
        long categoryId = category.getId();
        ExternalSecurityDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
        ExternalSecurityDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
        Resource resource = new Resource();
        resource.setName("NAME");
        resource.setCreation(new Date());
        resource.setCategory(category);
        resourceDAO.persist((Object[])new Resource[]{resource});
        long resourceId = resource.getId();
        ExternalSecurityDAOTest.assertEquals((int)1, (int)resourceDAO.count(null));
        ExternalSecurityDAOTest.assertEquals((int)1, (int)resourceDAO.findAll().size());
        SecurityRule security = new SecurityRule();
        security.setCanRead(true);
        security.setCanWrite(true);
        security.setResource((Resource)resourceDAO.find(Long.valueOf(resourceId)));
        externalSecurityDAO.persist((Object[])new SecurityRule[]{security});
        long securityId = security.getId();
        ExternalSecurityDAOTest.assertEquals((int)1, (int)externalSecurityDAO.count(null));
        ExternalSecurityDAOTest.assertEquals((int)1, (int)externalSecurityDAO.findAll().size());
        SecurityRule loaded = (SecurityRule)externalSecurityDAO.find(Long.valueOf(securityId));
        ExternalSecurityDAOTest.assertNotNull((String)"Can't retrieve Security", (Object)loaded);
        ExternalSecurityDAOTest.assertTrue((boolean)loaded.isCanWrite());
        loaded.setCanWrite(false);
        externalSecurityDAO.merge((Object)loaded);
        loaded = (SecurityRule)externalSecurityDAO.find(Long.valueOf(securityId));
        ExternalSecurityDAOTest.assertNotNull((String)"Can't retrieve Security", (Object)loaded);
        ExternalSecurityDAOTest.assertFalse((boolean)loaded.isCanWrite());
        externalSecurityDAO.removeById(Long.valueOf(securityId));
        ExternalSecurityDAOTest.assertNull((String)"Security not deleted", (Object)securityDAO.find(Long.valueOf(categoryId)));
    }

    @Test
    public void testPersistSecurityUsingNames() throws Exception {
        String NAME = "NAME";
        String USERNAME = "USER";
        String GROUPNAME = "GROUP";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting Security");
        }
        Category category = new Category();
        category.setName("MAP");
        categoryDAO.persist((Object[])new Category[]{category});
        long categoryId = category.getId();
        ExternalSecurityDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
        ExternalSecurityDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
        User user = new User();
        user.setName("USER");
        user.setRole(Role.USER);
        userDAO.persist((Object[])new User[]{user});
        long userId = user.getId();
        ExternalSecurityDAOTest.assertEquals((int)1, (int)userDAO.count(null));
        ExternalSecurityDAOTest.assertEquals((int)1, (int)userDAO.findAll().size());
        UserGroup group = new UserGroup();
        group.setGroupName("GROUP");
        userGroupDAO.persist((Object[])new UserGroup[]{group});
        long groupId = group.getId();
        ExternalSecurityDAOTest.assertEquals((int)1, (int)userGroupDAO.count(null));
        ExternalSecurityDAOTest.assertEquals((int)1, (int)userGroupDAO.findAll().size());
        Resource resource = new Resource();
        resource.setName("NAME");
        resource.setCreation(new Date());
        resource.setCategory(category);
        resourceDAO.persist((Object[])new Resource[]{resource});
        long resourceId = resource.getId();
        ExternalSecurityDAOTest.assertEquals((int)1, (int)resourceDAO.count(null));
        ExternalSecurityDAOTest.assertEquals((int)1, (int)resourceDAO.findAll().size());
        SecurityRule security = new SecurityRule();
        security.setCanRead(true);
        security.setCanWrite(true);
        security.setResource((Resource)resourceDAO.find(Long.valueOf(resourceId)));
        security.setUsername("testuser");
        externalSecurityDAO.persist((Object[])new SecurityRule[]{security});
        long securityId = security.getId();
        ExternalSecurityDAOTest.assertEquals((int)1, (int)externalSecurityDAO.count(null));
        ExternalSecurityDAOTest.assertEquals((int)1, (int)externalSecurityDAO.findAll().size());
        SecurityRule rule = (SecurityRule)externalSecurityDAO.find(Long.valueOf(securityId));
        ExternalSecurityDAOTest.assertNotNull((Object)rule);
        ExternalSecurityDAOTest.assertNotNull((Object)rule.getUsername());
        externalSecurityDAO.removeById(Long.valueOf(securityId));
        security = new SecurityRule();
        security.setCanRead(true);
        security.setCanWrite(true);
        security.setResource((Resource)resourceDAO.find(Long.valueOf(resourceId)));
        User testUser = new User();
        testUser.setId(Long.valueOf(userId));
        testUser.setName("USER");
        security.setUser(testUser);
        externalSecurityDAO.persist((Object[])new SecurityRule[]{security});
        securityId = security.getId();
        ExternalSecurityDAOTest.assertEquals((int)1, (int)externalSecurityDAO.count(null));
        ExternalSecurityDAOTest.assertEquals((int)1, (int)externalSecurityDAO.findAll().size());
        SecurityRule rule2 = (SecurityRule)externalSecurityDAO.find(Long.valueOf(securityId));
        ExternalSecurityDAOTest.assertNotNull((Object)rule2);
        ExternalSecurityDAOTest.assertNotNull((Object)rule2.getUsername());
        externalSecurityDAO.removeById(Long.valueOf(securityId));
        security = new SecurityRule();
        security.setCanRead(true);
        security.setCanWrite(true);
        security.setResource((Resource)resourceDAO.find(Long.valueOf(resourceId)));
        security.setGroupname("testgroup");
        externalSecurityDAO.persist((Object[])new SecurityRule[]{security});
        securityId = security.getId();
        ExternalSecurityDAOTest.assertEquals((int)1, (int)externalSecurityDAO.count(null));
        ExternalSecurityDAOTest.assertEquals((int)1, (int)externalSecurityDAO.findAll().size());
        rule = (SecurityRule)externalSecurityDAO.find(Long.valueOf(securityId));
        ExternalSecurityDAOTest.assertNotNull((Object)rule);
        ExternalSecurityDAOTest.assertNotNull((Object)rule.getGroupname());
        externalSecurityDAO.removeById(Long.valueOf(securityId));
        security = new SecurityRule();
        security.setCanRead(true);
        security.setCanWrite(true);
        security.setResource((Resource)resourceDAO.find(Long.valueOf(resourceId)));
        UserGroup testGroup = new UserGroup();
        testGroup.setId(Long.valueOf(groupId));
        testGroup.setGroupName("GROUP");
        security.setGroup(testGroup);
        externalSecurityDAO.persist((Object[])new SecurityRule[]{security});
        securityId = security.getId();
        ExternalSecurityDAOTest.assertEquals((int)1, (int)externalSecurityDAO.count(null));
        ExternalSecurityDAOTest.assertEquals((int)1, (int)externalSecurityDAO.findAll().size());
        rule2 = (SecurityRule)externalSecurityDAO.find(Long.valueOf(securityId));
        ExternalSecurityDAOTest.assertNotNull((Object)rule2);
        ExternalSecurityDAOTest.assertNotNull((Object)rule2.getGroupname());
        SecurityRule loaded = (SecurityRule)externalSecurityDAO.find(Long.valueOf(securityId));
        ExternalSecurityDAOTest.assertNotNull((String)"Can't retrieve Security", (Object)loaded);
        ExternalSecurityDAOTest.assertTrue((boolean)loaded.isCanWrite());
        loaded.setCanWrite(false);
        externalSecurityDAO.merge((Object)loaded);
        loaded = (SecurityRule)externalSecurityDAO.find(Long.valueOf(securityId));
        ExternalSecurityDAOTest.assertNotNull((String)"Can't retrieve Security", (Object)loaded);
        ExternalSecurityDAOTest.assertFalse((boolean)loaded.isCanWrite());
        externalSecurityDAO.removeById(Long.valueOf(securityId));
        ExternalSecurityDAOTest.assertNull((String)"Security not deleted", (Object)externalSecurityDAO.find(Long.valueOf(categoryId)));
    }
}

