/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao;

import it.geosolutions.geostore.core.dao.AttributeDAO;
import it.geosolutions.geostore.core.dao.CategoryDAO;
import it.geosolutions.geostore.core.dao.ResourceDAO;
import it.geosolutions.geostore.core.dao.SecurityDAO;
import it.geosolutions.geostore.core.dao.StoredDataDAO;
import it.geosolutions.geostore.core.dao.UserAttributeDAO;
import it.geosolutions.geostore.core.dao.UserDAO;
import it.geosolutions.geostore.core.dao.UserGroupDAO;
import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.StoredData;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import java.util.List;
import junit.framework.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class BaseDAOTest
extends TestCase {
    protected final Logger LOGGER = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected static StoredDataDAO storedDataDAO;
    protected static ResourceDAO resourceDAO;
    protected static AttributeDAO attributeDAO;
    protected static CategoryDAO categoryDAO;
    protected static SecurityDAO securityDAO;
    protected static SecurityDAO externalSecurityDAO;
    protected static UserAttributeDAO userAttributeDAO;
    protected static UserDAO userDAO;
    protected static UserGroupDAO userGroupDAO;
    protected static ClassPathXmlApplicationContext ctx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDAOTest() {
        Class<BaseDAOTest> clazz = BaseDAOTest.class;
        synchronized (BaseDAOTest.class) {
            if (ctx == null) {
                String[] paths = new String[]{"applicationContext.xml"};
                ctx = new ClassPathXmlApplicationContext(paths);
                storedDataDAO = (StoredDataDAO)ctx.getBean("storedDataDAO");
                resourceDAO = (ResourceDAO)ctx.getBean("resourceDAO");
                attributeDAO = (AttributeDAO)ctx.getBean("attributeDAO");
                categoryDAO = (CategoryDAO)ctx.getBean("categoryDAO");
                securityDAO = (SecurityDAO)ctx.getBean("securityDAO");
                externalSecurityDAO = (SecurityDAO)ctx.getBean("externalSecurityDAO");
                userAttributeDAO = (UserAttributeDAO)ctx.getBean("userAttributeDAO");
                userDAO = (UserDAO)ctx.getBean("userDAO");
                userGroupDAO = (UserGroupDAO)ctx.getBean("userGroupDAO");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void setUp() throws Exception {
        this.LOGGER.info("################ Running " + ((Object)((Object)this)).getClass().getSimpleName() + "::" + this.getName());
        super.setUp();
        this.removeAll();
        this.LOGGER.info("##### Ending setup for " + this.getName() + " ###----------------------");
    }

    @Test
    public void testCheckDAOs() {
        BaseDAOTest.assertNotNull((Object)storedDataDAO);
        BaseDAOTest.assertNotNull((Object)resourceDAO);
        BaseDAOTest.assertNotNull((Object)attributeDAO);
        BaseDAOTest.assertNotNull((Object)categoryDAO);
        BaseDAOTest.assertNotNull((Object)securityDAO);
        BaseDAOTest.assertNotNull((Object)externalSecurityDAO);
        BaseDAOTest.assertNotNull((Object)userAttributeDAO);
        BaseDAOTest.assertNotNull((Object)userDAO);
        BaseDAOTest.assertNotNull((Object)userGroupDAO);
    }

    protected void removeAll() {
        this.removeAllResource();
        this.removeAllStoredData();
        this.removeAllAttribute();
        this.removeAllUserAttribute();
        this.removeAllCategory();
        this.removeAllUser();
        this.removeAllUserGroup();
    }

    private void removeAllUser() {
        List list = userDAO.findAll();
        for (User item : list) {
            this.LOGGER.info("Removing " + item.getId());
            boolean ret = userDAO.remove((Object)item);
            BaseDAOTest.assertTrue((String)"User not removed", (boolean)ret);
        }
        BaseDAOTest.assertEquals((String)"Users have not been properly deleted", (int)0, (int)userDAO.count(null));
    }

    private void removeAllUserGroup() {
        List list = userGroupDAO.findAll();
        for (UserGroup item : list) {
            this.LOGGER.info("Removing " + item.getId());
            boolean ret = userGroupDAO.remove((Object)item);
            BaseDAOTest.assertTrue((String)"UserGroup not removed", (boolean)ret);
        }
        BaseDAOTest.assertEquals((String)"UserGroup have not been properly deleted", (int)0, (int)userGroupDAO.count(null));
    }

    private void removeAllCategory() {
        List list = categoryDAO.findAll();
        for (Category item : list) {
            this.LOGGER.info("Removing " + item.getId());
            boolean ret = categoryDAO.remove((Object)item);
            BaseDAOTest.assertTrue((String)"Category not removed", (boolean)ret);
        }
        BaseDAOTest.assertEquals((String)"Category have not been properly deleted", (int)0, (int)categoryDAO.count(null));
    }

    private void removeAllUserAttribute() {
        List list = userAttributeDAO.findAll();
        for (UserAttribute item : list) {
            this.LOGGER.info("Removing " + item.getId());
            boolean ret = userAttributeDAO.remove((Object)item);
            BaseDAOTest.assertTrue((String)"UserAttribute not removed", (boolean)ret);
        }
        BaseDAOTest.assertEquals((String)"UserAttribute have not been properly deleted", (int)0, (int)userAttributeDAO.count(null));
    }

    protected void removeAllStoredData() {
        List list = storedDataDAO.findAll();
        for (StoredData item : list) {
            this.LOGGER.info("Removing " + item.getId());
            boolean ret = storedDataDAO.remove((Object)item);
            BaseDAOTest.assertTrue((String)"StoredData not removed", (boolean)ret);
        }
        BaseDAOTest.assertEquals((String)"StoredData have not been properly deleted", (int)0, (int)storedDataDAO.count(null));
    }

    private void removeAllResource() {
        List list = resourceDAO.findAll();
        for (Resource item : list) {
            this.LOGGER.info("Removing " + item.getId());
            boolean ret = resourceDAO.remove((Object)item);
            BaseDAOTest.assertTrue((String)"Resource not removed", (boolean)ret);
        }
        BaseDAOTest.assertEquals((String)"Resource have not been properly deleted", (int)0, (int)resourceDAO.count(null));
    }

    private void removeAllAttribute() {
        List list = attributeDAO.findAll();
        for (Attribute item : list) {
            this.LOGGER.info("Removing " + item.getId());
            boolean ret = attributeDAO.remove((Object)item);
            BaseDAOTest.assertTrue((String)"DataType not removed", (boolean)ret);
        }
        BaseDAOTest.assertEquals((String)"DataType have not been properly deleted", (int)0, (int)attributeDAO.count(null));
    }

    static {
        ctx = null;
    }
}

