/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.impl;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.impl.SecurityDAOImpl;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import java.util.ArrayList;
import java.util.List;

public class ExternalSecurityDAOImpl
extends SecurityDAOImpl {
    @Override
    public void persist(SecurityRule ... entities) {
        SecurityRule[] entitiesWithNames = this.extractNames(entities);
        super.persist(entitiesWithNames);
        for (int i = 0; i < entitiesWithNames.length; ++i) {
            entities[i].setId(entitiesWithNames[i].getId());
        }
    }

    @Override
    public List<SecurityRule> findAll() {
        return this.fillFromNames(super.findAll());
    }

    private List<SecurityRule> fillFromNames(List<SecurityRule> rules) {
        ArrayList<SecurityRule> filled = new ArrayList<SecurityRule>();
        for (SecurityRule rule : rules) {
            SecurityRule filledRule = new SecurityRule();
            filledRule.setId(rule.getId());
            filledRule.setResource(rule.getResource());
            filledRule.setCanRead(rule.isCanRead());
            filledRule.setCanWrite(rule.isCanWrite());
            if (rule.getUsername() != null) {
                filledRule.setUsername(rule.getUsername());
                if (rule.getUser() == null) {
                    User user = new User();
                    user.setId(Long.valueOf(-1L));
                    user.setEnabled(true);
                    user.setName(rule.getUsername());
                    filledRule.setUser(user);
                }
            }
            if (rule.getGroupname() != null) {
                filledRule.setGroupname(rule.getGroupname());
                if (rule.getGroup() == null) {
                    UserGroup group = new UserGroup();
                    group.setId(Long.valueOf(-1L));
                    group.setEnabled(true);
                    group.setGroupName(rule.getGroupname());
                    filledRule.setGroup(group);
                }
            }
            filled.add(filledRule);
        }
        return filled;
    }

    private SecurityRule[] extractNames(SecurityRule[] rules) {
        ArrayList<SecurityRule> extracted = new ArrayList<SecurityRule>();
        for (SecurityRule rule : rules) {
            SecurityRule extractedRule = new SecurityRule();
            extractedRule.setId(rule.getId());
            extractedRule.setResource(rule.getResource());
            extractedRule.setCanRead(rule.isCanRead());
            extractedRule.setCanWrite(rule.isCanWrite());
            if (rule.getUser() != null) {
                extractedRule.setUsername(rule.getUser().getName());
            } else {
                extractedRule.setUsername(rule.getUsername());
            }
            if (rule.getGroup() != null) {
                extractedRule.setGroupname(rule.getGroup().getGroupName());
            } else {
                extractedRule.setGroupname(rule.getGroupname());
            }
            extracted.add(extractedRule);
        }
        return extracted.toArray(new SecurityRule[0]);
    }

    @Override
    public List<SecurityRule> search(ISearch search) {
        return this.fillFromNames(super.search(search));
    }

    @Override
    public void addReadSecurityConstraints(Search searchCriteria, User user) {
        if (user.getRole() == Role.ADMIN) {
            return;
        }
        Filter userFiltering = Filter.equal((String)"username", (Object)user.getName());
        if (user.getGroups() != null && !user.getGroups().isEmpty()) {
            ArrayList<String> groupsName = new ArrayList<String>();
            for (UserGroup group : user.getGroups()) {
                groupsName.add(group.getGroupName());
            }
            userFiltering = Filter.or((Filter[])new Filter[]{userFiltering, Filter.in((String)"groupname", groupsName)});
        }
        Filter securityFilter = Filter.some((String)"security", (Filter)Filter.and((Filter[])new Filter[]{Filter.equal((String)"canRead", (Object)true), userFiltering}));
        searchCriteria.addFilter(securityFilter);
    }

    @Override
    public List<SecurityRule> findUserSecurityRule(String userName, long resourceId) {
        Search searchCriteria = new Search(SecurityRule.class);
        Filter securityFilter = Filter.and((Filter[])new Filter[]{Filter.equal((String)"resource.id", (Object)resourceId), Filter.equal((String)"username", (Object)userName)});
        searchCriteria.addFilter(securityFilter);
        return this.fillFromNames(super.search((ISearch)searchCriteria));
    }

    @Override
    public List<SecurityRule> findResourceSecurityRules(long resourceId) {
        return this.fillFromNames(super.findResourceSecurityRules(resourceId));
    }

    @Override
    public List<SecurityRule> findGroupSecurityRule(List<String> groupNames, long resourceId) {
        List<SecurityRule> rules = this.findResourceSecurityRules(resourceId);
        ArrayList<SecurityRule> filteredRules = new ArrayList<SecurityRule>();
        for (SecurityRule sr : rules) {
            if (sr.getGroupname() == null || !groupNames.contains(sr.getGroupname())) continue;
            filteredRules.add(sr);
        }
        return this.fillFromNames(filteredRules);
    }
}

