/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.BaseDAOTest;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import java.util.HashSet;
import java.util.List;
import javax.persistence.PersistenceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

public class UserGroupDAOTest
extends BaseDAOTest {
    private static final Logger LOGGER = LogManager.getLogger(UserGroupDAOTest.class);

    @Test
    public void testPersistUserGroup() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting UserGroup");
        }
        Category category = new Category();
        category.setName("MAP");
        categoryDAO.persist((Object[])new Category[]{category});
        UserGroupDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
        UserGroupDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
        HashSet<UserGroup> groups = new HashSet<UserGroup>();
        UserGroup g1 = new UserGroup();
        g1.setGroupName("GROUP1");
        UserGroup g2 = new UserGroup();
        g2.setGroupName("GROUP2");
        try {
            UserGroup g3 = new UserGroup();
            g3.setGroupName("GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3GROUP3");
            userGroupDAO.persist((Object[])new UserGroup[]{g3});
        }
        catch (PersistenceException e) {
            UserGroupDAOTest.assertTrue((boolean)true);
        }
        groups.add(g1);
        groups.add(g2);
        userGroupDAO.persist((Object[])new UserGroup[]{g1});
        userGroupDAO.persist((Object[])new UserGroup[]{g2});
        long groupId2 = g2.getId();
        UserGroupDAOTest.assertEquals((int)3, (int)userGroupDAO.count(null));
        UserGroupDAOTest.assertEquals((int)3, (int)userGroupDAO.findAll().size());
        User user1 = new User();
        user1.setGroups(groups);
        user1.setName("USER1_NAME");
        user1.setNewPassword("user");
        user1.setRole(Role.ADMIN);
        userDAO.persist((Object[])new User[]{user1});
        long userId1 = user1.getId();
        UserGroupDAOTest.assertEquals((int)1, (int)userDAO.findAll().size());
        UserGroupDAOTest.assertEquals((int)1, (int)userDAO.count(null));
        SecurityRule security = new SecurityRule();
        security.setCanRead(true);
        security.setCanWrite(true);
        security.setGroup(g1);
        security.setUser(user1);
        securityDAO.persist((Object[])new SecurityRule[]{security});
        long securityId1 = security.getId();
        UserGroupDAOTest.assertEquals((int)1, (int)securityDAO.count(null));
        UserGroupDAOTest.assertEquals((int)1, (int)securityDAO.findAll().size());
        User user2 = new User();
        user2.setGroups(groups);
        user2.setName("USER2_NAME");
        user2.setNewPassword("user");
        user2.setRole(Role.USER);
        userDAO.persist((Object[])new User[]{user2});
        UserGroupDAOTest.assertEquals((int)2, (int)userDAO.findAll().size());
        UserGroupDAOTest.assertEquals((int)2, (int)userDAO.count(null));
        SecurityRule security2 = new SecurityRule();
        security2.setCanRead(true);
        security2.setCanWrite(true);
        security2.setGroup(g2);
        securityDAO.persist((Object[])new SecurityRule[]{security2});
        long securityId2 = security2.getId();
        UserGroupDAOTest.assertEquals((int)2, (int)securityDAO.count(null));
        UserGroupDAOTest.assertEquals((int)2, (int)securityDAO.findAll().size());
        User user12 = (User)userDAO.find(Long.valueOf(userId1));
        userDAO.remove((Object)user12);
        UserGroupDAOTest.assertEquals((int)1, (int)securityDAO.count(null));
        UserGroupDAOTest.assertEquals((int)1, (int)securityDAO.findAll().size());
        UserGroupDAOTest.assertEquals((int)1, (int)userDAO.findAll().size());
        UserGroupDAOTest.assertEquals((int)1, (int)userDAO.count(null));
        UserGroupDAOTest.assertEquals((int)3, (int)userGroupDAO.findAll().size());
        UserGroupDAOTest.assertEquals((int)3, (int)userGroupDAO.count(null));
        UserGroupDAOTest.assertNull((String)"SecurityRule not deleted", (Object)securityDAO.find(Long.valueOf(securityId1)));
        UserGroupDAOTest.assertNotNull((String)"Group SecurityRule deleted... that's a mistake!", (Object)securityDAO.find(Long.valueOf(securityId2)));
        UserGroup group2 = (UserGroup)userGroupDAO.find(Long.valueOf(groupId2));
        UserGroupDAOTest.assertNotNull((Object)group2);
        Object searchByGroup = new Search(User.class);
        searchByGroup.addFilterSome("groups", Filter.equal((String)"id", (Object)groupId2));
        List users = userDAO.search((ISearch)searchByGroup);
        UserGroupDAOTest.assertEquals((int)1, (int)users.size());
        UserGroupDAOTest.assertEquals((int)2, (int)((User)users.get(0)).getGroups().size());
        for (User u : users) {
            LOGGER.info("Removing group " + String.valueOf(group2) + " from user " + String.valueOf(u));
            UserGroupDAOTest.assertTrue((boolean)u.removeGroup(groupId2));
            userDAO.merge((Object)u);
        }
        searchByGroup = new Search(User.class);
        searchByGroup.addFilterSome("groups", Filter.equal((String)"id", (Object)groupId2));
        users = userDAO.search((ISearch)searchByGroup);
        for (User u : users) {
            LOGGER.error("Found user " + String.valueOf(u));
        }
        UserGroupDAOTest.assertEquals((int)0, (int)users.size());
        userGroupDAO.remove((Object)group2);
        UserGroupDAOTest.assertEquals((int)2, (int)userGroupDAO.findAll().size());
        UserGroupDAOTest.assertEquals((int)2, (int)userGroupDAO.count(null));
        UserGroupDAOTest.assertNull((String)"Group SecurityRule not deleted", (Object)securityDAO.find(Long.valueOf(securityId2)));
        userDAO.remove((Object)user2);
    }
}

