/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.impl;

import com.googlecode.genericdao.search.ISearch;
import it.geosolutions.geostore.core.dao.UserDAO;
import it.geosolutions.geostore.core.dao.impl.BaseDAO;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.security.password.PwEncoder;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Hibernate;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value="geostoreTransactionManager")
public class UserDAOImpl
extends BaseDAO<User, Long>
implements UserDAO {
    private static final Logger LOGGER = LogManager.getLogger(UserDAOImpl.class);

    public void persist(User ... entities) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Inserting new entities for User ... ");
        }
        for (User user : entities) {
            String newpw = user.getNewPassword();
            if (newpw == null || newpw.isEmpty()) continue;
            String enc = PwEncoder.encode((String)newpw);
            user.setPassword(enc);
        }
        super.persist((Object[])entities);
    }

    @Override
    public List<User> findAll() {
        return super.findAll();
    }

    @Override
    public List<User> search(ISearch search) {
        return super.search(search);
    }

    @Override
    public User merge(User entity) {
        String newpw = entity.getNewPassword();
        if (newpw != null && !newpw.isEmpty()) {
            String enc = PwEncoder.encode((String)newpw);
            entity.setPassword(enc);
        }
        return (User)super.merge((Object)entity);
    }

    @Override
    public boolean remove(User entity) {
        return super.remove((Object)entity);
    }

    @Override
    public boolean removeById(Long id) {
        return super.removeById((Serializable)id);
    }

    @Override
    public User find(Long id) {
        User user = (User)super.find((Serializable)id);
        if (user != null && Hibernate.isInitialized((Object)user)) {
            List attributes = user.getAttribute();
            Hibernate.initialize((Object)attributes);
            Set groups = user.getGroups();
            Hibernate.initialize((Object)groups);
        }
        return user;
    }

    public User[] save(User ... entities) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Inserting new entities for User ... ");
        }
        for (User user : entities) {
            String newpw = user.getNewPassword();
            if (newpw == null || newpw.isEmpty()) continue;
            String enc = PwEncoder.encode((String)newpw);
            user.setPassword(enc);
        }
        return (User[])super.save((Object[])entities);
    }
}

