/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.core.model.Tag;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.TagList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.springframework.security.access.annotation.Secured;

@Path(value="tag")
public interface RESTTagService {
    @POST
    @Consumes(value={"application/xml", "text/xml"})
    @Produces(value={"text/plain"})
    @Secured(value={"ROLE_ADMIN"})
    public long insert(@Context SecurityContext var1, @Multipart(value="tag") Tag var2) throws BadRequestServiceEx;

    @GET
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_ANONYMOUS"})
    public TagList getAll(@Context SecurityContext var1, @QueryParam(value="page") Integer var2, @QueryParam(value="entries") Integer var3, @QueryParam(value="nameLike") String var4) throws BadRequestWebEx;

    @GET
    @Path(value="{id}")
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public Tag get(@Context SecurityContext var1, @PathParam(value="id") long var2) throws NotFoundWebEx;

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/xml", "text/xml"})
    @Produces(value={"text/plain"})
    @Secured(value={"ROLE_ADMIN"})
    public long update(@Context SecurityContext var1, @PathParam(value="id") long var2, @Multipart(value="tag") Tag var4) throws NotFoundWebEx, BadRequestWebEx;

    @DELETE
    @Path(value="{id}")
    @Secured(value={"ROLE_ADMIN"})
    public void delete(@Context SecurityContext var1, @PathParam(value="id") long var2) throws NotFoundWebEx;

    @POST
    @Path(value="/{id}/resource/{resourceId}")
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void addToResource(@Context SecurityContext var1, @PathParam(value="id") long var2, @PathParam(value="resourceId") long var4) throws NotFoundWebEx;

    @DELETE
    @Path(value="/{id}/resource/{resourceId}")
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void removeFromResource(@Context SecurityContext var1, @PathParam(value="id") long var2, @PathParam(value="resourceId") long var4) throws NotFoundWebEx;
}

