/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.auditing;

import freemarker.template.TemplateException;
import it.geosolutions.geostore.services.rest.auditing.AuditInfo;
import it.geosolutions.geostore.services.rest.auditing.AuditingConfiguration;
import it.geosolutions.geostore.services.rest.auditing.AuditingTemplates;
import it.geosolutions.geostore.services.rest.auditing.AuditingTestsBase;
import it.geosolutions.geostore.services.rest.auditing.AuditingTestsUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public final class AuditingTemplatesTest
extends AuditingTestsBase {
    @Test
    public void testTemplatesWriting() throws InterruptedException, IOException, TemplateException {
        File outputFile = new File(this.OUTPUT_DIRECTORY, "audit-geostore.txt");
        AuditingConfiguration configuration = new AuditingConfiguration();
        AuditingTemplates templates = new AuditingTemplates(configuration.getTemplatesDirectory());
        Assert.assertEquals((Object)templates.getHeaderTemplate().getName(), (Object)"header.ftl");
        Assert.assertEquals((Object)templates.getBodyTemplate().getName(), (Object)"body.ftl");
        Assert.assertEquals((Object)templates.getFooterTemplate().getName(), (Object)"footer.ftl");
        FileWriter writer = new FileWriter(outputFile);
        templates.getHeaderTemplate().process((Object)Collections.EMPTY_MAP, (Writer)writer);
        Map<String, String> content = AuditingTemplatesTest.createContent();
        templates.getBodyTemplate().process(content, (Writer)writer);
        templates.getFooterTemplate().process((Object)Collections.EMPTY_MAP, (Writer)writer);
        AuditingTestsUtils.checkFileExistsWithContent(outputFile, AuditingTemplatesTest.contentToString(content));
    }

    static Map<String, String> createContent() {
        LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
        message.put("id", "0");
        message.put(AuditInfo.HTTP_METHOD.getKey(), "HTTP_METHOD");
        message.put(AuditInfo.PATH.getKey(), "PATH");
        message.put(AuditInfo.BASE_PATH.getKey(), "BASE_PATH");
        message.put(AuditInfo.QUERY_STRING.getKey(), "QUERY_STRING");
        message.put(AuditInfo.REMOTE_ADDR.getKey(), "REMOTE_ADDR");
        message.put(AuditInfo.REMOTE_HOST.getKey(), "REMOTE_HOST");
        message.put(AuditInfo.REMOTE_USER.getKey(), "REMOTE_USER");
        message.put(AuditInfo.USER_NAME.getKey(), "USER_NAME");
        message.put(AuditInfo.USER_ROLE.getKey(), "USER_ROLE");
        message.put(AuditInfo.USER_GROUPS.getKey(), "USER_GROUPS");
        message.put(AuditInfo.HOST.getKey(), "HOST");
        message.put(AuditInfo.BODY_AS_STRING.getKey(), "BODY_AS_STRING");
        message.put(AuditInfo.ERROR_MESSAGE.getKey(), "ERROR_MESSAGE");
        message.put(AuditInfo.FAILED.getKey(), "FAILED");
        message.put(AuditInfo.RESPONSE_STATUS_CODE.getKey(), "RESPONSE_STATUS_CODE");
        message.put(AuditInfo.RESPONSE_CONTENT_TYPE.getKey(), "RESPONSE_CONTENT_TYPE");
        message.put(AuditInfo.RESPONSE_LENGTH.getKey(), "RESPONSE_LENGTH");
        message.put(AuditInfo.START_TIME.getKey(), "START_TIME");
        message.put(AuditInfo.END_TIME.getKey(), "END_TIME");
        message.put(AuditInfo.TOTAL_TIME.getKey(), "TOTAL_TIME");
        return message;
    }

    static String contentToString(Map<String, String> content) {
        StringBuilder stringBuilder = new StringBuilder("*START*\n");
        stringBuilder.append("---\n");
        for (String value : content.values()) {
            stringBuilder.append(value).append("\n");
        }
        stringBuilder.append("---\n");
        stringBuilder.append("*END*");
        return stringBuilder.toString();
    }
}

