/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.auditing;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.services.rest.auditing.AuditInfo;
import it.geosolutions.geostore.services.rest.auditing.LogUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;

final class AuditInfoExtractor {
    private static final Logger LOGGER = LogManager.getLogger(AuditInfoExtractor.class);
    private static final Pattern geoStorePath = Pattern.compile("/geostore/(.*)");

    private AuditInfoExtractor() {
    }

    static Map<String, String> extract(Message message) {
        HashMap<String, String> auditInfo = new HashMap<String, String>();
        try {
            AuditInfoExtractor.handleInMessage(auditInfo, message.getExchange().getInMessage());
            AuditInfoExtractor.handleOutSuccessMessage(auditInfo, message.getExchange().getOutMessage());
            AuditInfoExtractor.handleOutFaultMessage(auditInfo, message.getExchange().getOutFaultMessage());
            AuditInfoExtractor.handleTime(auditInfo, message.getExchange().get((Object)AuditInfo.START_TIME.getKey()));
        }
        catch (Exception exception) {
            LogUtils.error(LOGGER, exception, "Error obtaining auditing information.", new Object[0]);
        }
        return auditInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Long getResponseLength(Message message) {
        try (CachedOutputStream outputStream = (CachedOutputStream)message.getContent(OutputStream.class);){
            if (outputStream == null) return null;
            Long l = outputStream.size();
            return l;
        }
        catch (Exception exception) {
            LogUtils.error(LOGGER, exception, "Error obtaining response length.", new Object[0]);
        }
        return null;
    }

    private static void handleInMessage(Map<String, String> auditInfo, Message message) {
        if (message == null) {
            LogUtils.info(LOGGER, "Input message is NULL.", new Object[0]);
            return;
        }
        try {
            auditInfo.put(AuditInfo.HTTP_METHOD.getKey(), AuditInfoExtractor.safeToString(message.get((Object)"org.apache.cxf.request.method")));
            auditInfo.put(AuditInfo.PATH.getKey(), AuditInfoExtractor.removeGeoStore((String)message.get((Object)Message.PATH_INFO)));
            auditInfo.put(AuditInfo.BASE_PATH.getKey(), AuditInfoExtractor.removeGeoStore((String)message.get((Object)Message.BASE_PATH)));
            auditInfo.put(AuditInfo.QUERY_STRING.getKey(), AuditInfoExtractor.safeToString(message.get((Object)Message.QUERY_STRING)));
            HttpServletRequest httpServletRequest = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
            auditInfo.put(AuditInfo.REMOTE_ADDR.getKey(), AuditInfoExtractor.safeToString(httpServletRequest.getRemoteAddr()));
            auditInfo.put(AuditInfo.REMOTE_HOST.getKey(), AuditInfoExtractor.safeToString(httpServletRequest.getRemoteHost()));
            auditInfo.put(AuditInfo.REMOTE_USER.getKey(), AuditInfoExtractor.safeToString(httpServletRequest.getRemoteUser()));
            auditInfo.put(AuditInfo.HOST.getKey(), AuditInfoExtractor.safeToString(httpServletRequest.getServerName()));
            AuditInfoExtractor.fillAuthInfo(auditInfo, httpServletRequest);
            auditInfo.put(AuditInfo.BODY_AS_STRING.getKey(), AuditInfoExtractor.getPayload(message));
        }
        catch (Exception exception) {
            LogUtils.error(LOGGER, exception, "Error obtaining auditing information for input message.", new Object[0]);
        }
    }

    private static void handleOutSuccessMessage(Map<String, String> auditInfo, Message message) {
        if (message == null) {
            return;
        }
        auditInfo.put(AuditInfo.RESPONSE_STATUS_CODE.getKey(), AuditInfoExtractor.safeToString(message.get((Object)Message.RESPONSE_CODE)));
        auditInfo.put(AuditInfo.RESPONSE_CONTENT_TYPE.getKey(), AuditInfoExtractor.safeToString(message.get((Object)"Content-Type")));
        auditInfo.put(AuditInfo.RESPONSE_LENGTH.getKey(), AuditInfoExtractor.safeToString(message.getExchange().get((Object)AuditInfo.RESPONSE_LENGTH.getKey())));
    }

    private static void handleOutFaultMessage(Map<String, String> auditInfo, Message message) {
        if (message == null) {
            return;
        }
        auditInfo.put(AuditInfo.FAILED.getKey(), "true");
        Exception exception = (Exception)message.getContent(Exception.class);
        if (exception != null) {
            auditInfo.put(AuditInfo.ERROR_MESSAGE.getKey(), exception.getMessage());
        } else {
            auditInfo.put(AuditInfo.ERROR_MESSAGE.getKey(), "");
        }
        auditInfo.put(AuditInfo.RESPONSE_CONTENT_TYPE.getKey(), AuditInfoExtractor.safeToString(message.get((Object)"Content-Type")));
        auditInfo.put(AuditInfo.RESPONSE_LENGTH.getKey(), AuditInfoExtractor.safeToString(AuditInfoExtractor.getResponseLength(message)));
        auditInfo.put(AuditInfo.RESPONSE_STATUS_CODE.getKey(), AuditInfoExtractor.safeToString(AuditInfoExtractor.safeToString(message.get((Object)Message.RESPONSE_CODE))));
    }

    private static void handleTime(Map<String, String> auditInfo, Object startTimeObject) {
        if (startTimeObject == null) {
            return;
        }
        long startTime = (Long)startTimeObject;
        long endTime = System.currentTimeMillis();
        auditInfo.put(AuditInfo.START_TIME.getKey(), String.valueOf(startTime));
        auditInfo.put(AuditInfo.END_TIME.getKey(), String.valueOf(endTime));
        auditInfo.put(AuditInfo.TOTAL_TIME.getKey(), String.valueOf(endTime - startTime));
    }

    private static String safeToString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPayload(Message message) {
        try (InputStream inputStream = (InputStream)message.getContent(InputStream.class);){
            if (inputStream == null) {
                String string2 = "";
                return string2;
            }
            String string = inputStream.toString();
            return string;
        }
        catch (Exception exception) {
            LogUtils.error(LOGGER, exception, "Error reading payload.", new Object[0]);
            return "";
        }
    }

    private static void fillAuthInfo(Map<String, String> info, HttpServletRequest httpServletRequest) {
        Authentication authentication;
        Object principal;
        Principal userPrincipal = httpServletRequest.getUserPrincipal();
        String userName = "";
        String userRole = "";
        String userGroups = "";
        if (userPrincipal != null && userPrincipal instanceof Authentication && (principal = (authentication = (Authentication)userPrincipal).getPrincipal()) != null && principal instanceof User) {
            User user = (User)principal;
            userName = user.getName();
            userRole = user.getRole().name();
            userGroups = AuditInfoExtractor.groupsToString(user.getGroups());
        }
        info.put(AuditInfo.USER_NAME.getKey(), userName);
        info.put(AuditInfo.USER_ROLE.getKey(), userRole);
        info.put(AuditInfo.USER_GROUPS.getKey(), userGroups);
    }

    private static String groupsToString(Set<UserGroup> groups) {
        if (groups.isEmpty()) {
            return null;
        }
        StringBuilder groupsString = new StringBuilder();
        for (UserGroup userGroup : groups) {
            groupsString.append(userGroup.getGroupName()).append(",");
        }
        groupsString.deleteCharAt(groupsString.length() - 1);
        return groupsString.toString();
    }

    private static String removeGeoStore(String path) {
        if (path == null) {
            return "";
        }
        Matcher matcher = geoStorePath.matcher(path);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return path;
    }
}

