/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.auditing;

import it.geosolutions.geostore.services.rest.auditing.AuditingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;

final class AuditingTestsUtils {
    AuditingTestsUtils() {
    }

    static File randomDirectory(File original) {
        return new File(original.getPath() + "-" + UUID.randomUUID().toString());
    }

    static void createDefaultConfiguration(File configurationDirectory, File configurationFilePath, File outputDirectory, File templatesDirectory) {
        AuditingTestsUtils.initDirectory(configurationDirectory);
        System.setProperty("GEOSTORE_AUDITING_CONF", configurationFilePath.getAbsolutePath());
        String properties = AuditingTestsUtils.propertiesToString(AuditingTestsUtils.getDefaultProperties(outputDirectory, templatesDirectory));
        AuditingTestsUtils.createFile(configurationFilePath, properties);
    }

    static void initDirectory(File directory) {
        AuditingTestsUtils.deleteDirectory(directory);
        AuditingTestsUtils.createDirectory(directory);
    }

    static void createDirectory(File directory) {
        try {
            FileUtils.forceMkdir((File)directory);
        }
        catch (Exception exception) {
            throw new AuditingException((Throwable)exception, "Error creating directory '%s'.", new Object[]{directory.getAbsolutePath()});
        }
    }

    static void deleteDirectory(File directory) {
        AuditingTestsUtils.deleteFile(directory);
    }

    static void deleteFile(File file) {
        if (!file.getAbsolutePath().contains("auditing-tests")) {
            throw new AuditingException("This path '%s' requested to delete looks suspicious.", new Object[]{file.getAbsolutePath()});
        }
        try {
            FileUtils.deleteQuietly((File)file);
        }
        catch (Exception exception) {
            throw new AuditingException((Throwable)exception, "Error deleting file '%s'.", new Object[]{file.getAbsolutePath()});
        }
    }

    static void createFile(File file, String fileContent) {
        AuditingTestsUtils.deleteFile(file);
        AuditingTestsUtils.writeToFile(file, fileContent);
    }

    static void writeToFile(File file, String fileContent) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(fileContent);
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            throw new AuditingException((Throwable)exception, "Error writing content to file '%s'.", new Object[]{file.getAbsolutePath()});
        }
    }

    static String readFile(File file) {
        try {
            FileInputStream input = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            input.read(data);
            input.close();
            return new String(data).replaceAll("\\r\\n", "\n");
        }
        catch (Exception exception) {
            throw new AuditingException((Throwable)exception, "Error reading file '%s' content.", new Object[]{file.getAbsolutePath()});
        }
    }

    static Map<String, String> getDefaultProperties(File outputDirectory, File templatesDirectory) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("auditing.enable", "true");
        properties.put("auditing.max.requests.per.file", "3");
        properties.put("auditing.output.directory", outputDirectory.getAbsolutePath().replace("\\", "\\\\"));
        properties.put("auditing.output.files.extension", "txt");
        properties.put("auditing.templates.directory", templatesDirectory.getAbsolutePath().replace("\\", "\\\\"));
        properties.put("auditing.templates.version", "1");
        return properties;
    }

    static String propertiesToString(Map<String, String> properties) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            stringBuilder.append(property.getKey()).append('=').append(property.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }

    static void checkDirectoryContainsFiles(File directory, File ... expectedFiles) {
        Collection existingFiles = FileUtils.listFiles((File)directory, null, (boolean)false);
        Assert.assertEquals((long)existingFiles.size(), (long)expectedFiles.length);
        for (File expectedFile : expectedFiles) {
            Assert.assertTrue((boolean)existingFiles.contains(expectedFile));
        }
    }

    static void checkFileExistsWithContent(File file, String content) {
        Assert.assertTrue((boolean)file.exists());
        Assert.assertEquals((Object)AuditingTestsUtils.readFile(file).trim(), (Object)content.trim());
    }

    static void checkDirectoryIsEmpty(File directory) {
        Assert.assertEquals((long)FileUtils.listFiles((File)directory, null, (boolean)false).size(), (long)0L);
    }

    static long checksum(File file) {
        try {
            return FileUtils.checksumCRC32((File)file);
        }
        catch (Exception exception) {
            throw new AuditingException((Throwable)exception, "Error computing checksum of file '%s'.", new Object[]{file.getAbsolutePath()});
        }
    }

    static void waitFileChange(File file, long checksum, long timeoutInMs) throws InterruptedException {
        int i = 0;
        while ((long)i < timeoutInMs / 100L) {
            if (AuditingTestsUtils.checksum(file) != checksum) {
                return;
            }
            Thread.sleep(100L);
            ++i;
        }
    }

    static void waitFileExists(File file, long timeoutInMs) throws InterruptedException {
        int i = 0;
        while ((long)i < timeoutInMs / 100L) {
            if (file.exists()) {
                return;
            }
            Thread.sleep(100L);
            ++i;
        }
    }
}

