/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import com.sun.jersey.api.client.UniformInterfaceException;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.dto.ShortAttribute;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.BaseField;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.rest.AdministratorGeoStoreClient;
import it.geosolutions.geostore.services.rest.GeoStoreClient;
import it.geosolutions.geostore.services.rest.client.model.ExtGroupList;
import it.geosolutions.geostore.services.rest.model.CategoryList;
import it.geosolutions.geostore.services.rest.model.RESTCategory;
import it.geosolutions.geostore.services.rest.model.RESTResource;
import it.geosolutions.geostore.services.rest.model.RESTSecurityRule;
import it.geosolutions.geostore.services.rest.model.RESTStoredData;
import it.geosolutions.geostore.services.rest.model.RESTUser;
import it.geosolutions.geostore.services.rest.model.RESTUserGroup;
import it.geosolutions.geostore.services.rest.model.ResourceList;
import it.geosolutions.geostore.services.rest.model.SecurityRuleList;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import it.geosolutions.geostore.services.rest.model.UserGroupList;
import it.geosolutions.geostore.services.rest.model.UserList;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class AdministratorGeostoreClientTest {
    AdministratorGeoStoreClient geoStoreClient;
    GeoStoreClient geoStoreUserClient;
    private static final Logger LOGGER = LogManager.getLogger(AdministratorGeostoreClientTest.class);
    final String DEFAULTCATEGORYNAME = "TestCategory1";
    final String KEY_STRING = "stringAtt";
    final String origString = "OrigStringValue";

    protected AdministratorGeoStoreClient createAdministratorClient() {
        this.geoStoreClient = new AdministratorGeoStoreClient();
        this.geoStoreClient.setGeostoreRestUrl("http://localhost:9191/geostore/rest");
        this.geoStoreClient.setUsername("admin");
        this.geoStoreClient.setPassword("admin");
        return this.geoStoreClient;
    }

    protected GeoStoreClient createUserClient(String username, String password) {
        this.geoStoreUserClient = new AdministratorGeoStoreClient();
        this.geoStoreUserClient.setGeostoreRestUrl("http://localhost:9191/geostore/rest");
        this.geoStoreUserClient.setUsername(username);
        this.geoStoreUserClient.setPassword(password);
        return this.geoStoreUserClient;
    }

    protected boolean pingGeoStore(GeoStoreClient client) {
        try {
            client.getCategories();
            return true;
        }
        catch (Exception ex) {
            LOGGER.debug("Error connecting to GeoStore", (Throwable)ex);
            for (Throwable t = ex; t != null; t = t.getCause()) {
                if (!(t instanceof ConnectException)) continue;
                LOGGER.warn("Testing GeoStore is offline");
                return false;
            }
            throw new RuntimeException("Unexpected exception: " + ex.getMessage(), ex);
        }
    }

    @Before
    public void before() throws Exception {
        this.geoStoreClient = this.createAdministratorClient();
        Assume.assumeTrue((boolean)this.pingGeoStore((GeoStoreClient)this.geoStoreClient));
        this.removeAllUsers((GeoStoreClient)this.geoStoreClient);
        this.removeAllUserGroup((GeoStoreClient)this.geoStoreClient);
        this.removeAllResources((GeoStoreClient)this.geoStoreClient);
        this.removeAllCategories((GeoStoreClient)this.geoStoreClient);
    }

    @Test
    public void getIdTest() {
        try {
            User userd = this.geoStoreClient.getUserDetails();
            System.out.println(userd.getId());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void getUsersTest() {
        try {
            UserList users = this.geoStoreClient.getUsers(Integer.valueOf(1), Integer.valueOf(1));
            UserGroup ug1 = new UserGroup();
            ug1.setGroupName("testGroup1");
            ug1.setDescription("testGroup1-Description");
            UserGroup ug2 = new UserGroup();
            ug2.setGroupName("testGroup2");
            ug2.setDescription("testGroup2-Description");
            UserGroup ug3 = new UserGroup();
            ug3.setGroupName("testGroup3");
            ug3.setDescription("testGroup3-Description");
            this.geoStoreClient.insertUserGroup(ug1);
            this.geoStoreClient.insertUserGroup(ug2);
            this.geoStoreClient.insertUserGroup(ug3);
            HashSet<UserGroup> ugs = new HashSet<UserGroup>();
            ugs.add(ug1);
            ugs.add(ug2);
            ugs.add(ug3);
            User user = new User();
            user.setName("testuser111");
            user.setRole(Role.USER);
            user.setNewPassword("testpw");
            UserAttribute email = new UserAttribute();
            email.setName("email");
            email.setValue("test@geo-solutions.it");
            user.setGroups(ugs);
            this.geoStoreClient.insert(user);
            users = this.geoStoreClient.getUsers(Integer.valueOf(0), Integer.valueOf(3));
            for (RESTUser u : users.getList()) {
                if (!"testuser111".equals(u.getName())) continue;
                Assert.assertEquals((long)3L, (long)u.getGroupsNames().size());
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void createUserTest() {
        try {
            User user = new User();
            user.setName("testuser1");
            user.setRole(Role.USER);
            user.setNewPassword("testpw");
            UserAttribute email = new UserAttribute();
            email.setName("email");
            email.setValue("test@geo-solutions.it");
            UserGroup ug = new UserGroup();
            ug.setGroupName("testgroup1");
            ug.setDescription("testGroup1-Description");
            this.geoStoreClient.insertUserGroup(ug);
            HashSet<UserGroup> ugs = new HashSet<UserGroup>();
            ugs.add(ug);
            user.setGroups(ugs);
            List attrs = new ArrayList<UserAttribute>();
            attrs.add(email);
            user.setAttribute(attrs);
            Long id = this.geoStoreClient.insert(user);
            System.out.println(id);
            User us = this.geoStoreClient.getUser(id.longValue(), Boolean.valueOf(true));
            Assert.assertEquals((long)1L, (long)us.getGroups().size());
            UserGroup ugRetrieved = null;
            for (UserGroup ugIter : us.getGroups()) {
                if (!"testgroup1".equals(ugIter.getGroupName())) continue;
                ugRetrieved = ugIter;
            }
            Assert.assertEquals((Object)"testGroup1-Description", (Object)ugRetrieved.getDescription());
            Assert.assertNotNull((Object)ugRetrieved.getId());
            user.getName().equals("testuser");
            attrs = us.getAttribute();
            Assert.assertNotNull((String)"Missing attribute list", attrs);
            Assert.assertTrue((String)"Attributes missing", (attrs.size() > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void deleteUserTest() {
    }

    @Test
    public void updateUserTest() {
        User userOld = new User();
        userOld.setName("testuser1");
        userOld.setRole(Role.USER);
        userOld.setNewPassword("testpw");
        UserAttribute email = new UserAttribute();
        email.setName("email");
        email.setValue("test@geo-solutions.it");
        ArrayList<UserAttribute> attrs = new ArrayList<UserAttribute>();
        attrs.add(email);
        userOld.setAttribute(attrs);
        Long id = this.geoStoreClient.insert(userOld);
        try {
            User user = new User();
            user.setName("testuser1");
            user.setRole(Role.USER);
            user.setNewPassword("testpw");
            email = new UserAttribute();
            email.setName("email");
            email.setValue("test1@geo-solutions.it");
            attrs = new ArrayList();
            attrs.add(email);
            user.setAttribute(attrs);
            this.geoStoreClient.update(id, user);
            user.getName().equals("testuser");
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void insertGetDeleteAssign_UserGroupTest() {
        long uid1 = this.createUser("u1", Role.USER, "-", new UserGroup[0]);
        User u1 = this.geoStoreClient.getUser(uid1);
        Assert.assertNotNull((Object)u1);
        long uid2 = this.createUser("u2", Role.USER, "-", new UserGroup[0]);
        User u2 = this.geoStoreClient.getUser(uid2);
        Assert.assertNotNull((Object)u2);
        HashSet<User> userSet = new HashSet<User>();
        userSet.add(u1);
        userSet.add(u2);
        UserGroup ug = new UserGroup();
        ug.setGroupName("usergroupTest1");
        long ugid = this.geoStoreClient.insertUserGroup(ug);
        RESTUserGroup restUG1 = this.geoStoreClient.getUserGroup(ugid);
        ug = new UserGroup();
        ug.setGroupName(restUG1.getGroupName());
        Assert.assertNotNull((Object)ug);
        Assert.assertEquals((Object)"usergroupTest1", (Object)ug.getGroupName());
        UserGroupList ugl = this.geoStoreClient.getUserGroups(Integer.valueOf(0), Integer.valueOf(1000), true);
        List ugll = ugl.getUserGroupList();
        Assert.assertEquals((long)2L, (long)ugll.size());
        RESTUserGroup ug1 = (RESTUserGroup)ugll.get(1);
        Assert.assertEquals((Object)"usergroupTest1", (Object)ug1.getGroupName());
        List userAssigned = ug1.getRestUsers().getList();
        Assert.assertEquals(null, (Object)userAssigned);
        this.geoStoreClient.assignUserGroup(uid1, ug1.getId().longValue());
        this.geoStoreClient.assignUserGroup(uid2, ug1.getId().longValue());
        ugl = this.geoStoreClient.getUserGroups(Integer.valueOf(0), Integer.valueOf(1000), true);
        ugll = ugl.getUserGroupList();
        Assert.assertEquals((long)2L, (long)ugll.size());
        User u = this.geoStoreClient.getUser(uid2);
        Set usergroups = u.getGroups();
        Assert.assertEquals((long)1L, (long)usergroups.size());
        this.geoStoreClient.deassignUserGroup(uid2, ug1.getId().longValue());
        u = this.geoStoreClient.getUser(uid2);
        usergroups = u.getGroups();
        Assert.assertNotNull((Object)usergroups);
        Assert.assertEquals((long)0L, (long)usergroups.size());
        this.geoStoreClient.assignUserGroup(uid2, ug1.getId().longValue());
        ugl = this.geoStoreClient.getUserGroups(Integer.valueOf(0), Integer.valueOf(1000), true);
        ugll = ugl.getUserGroupList();
        Assert.assertEquals((long)2L, (long)ugll.size());
        ug1 = (RESTUserGroup)ugll.get(1);
        Assert.assertEquals((Object)"usergroupTest1", (Object)ug1.getGroupName());
        userAssigned = ug1.getRestUsers().getList();
        Assert.assertEquals((long)2L, (long)userAssigned.size());
        UserGroup ug2 = new UserGroup();
        ug2.setGroupName("usergroupTest2");
        ugid = this.geoStoreClient.insertUserGroup(ug2);
        RESTUserGroup restUG = this.geoStoreClient.getUserGroup(ugid);
        Assert.assertNotNull((Object)restUG);
        Assert.assertEquals((Object)"usergroupTest2", (Object)restUG.getGroupName());
        User us = this.geoStoreClient.getUser(((RESTUser)userAssigned.get(0)).getId().longValue());
        Set usergroups2 = us.getGroups();
        Assert.assertEquals((long)1L, (long)usergroups2.size());
        ug2 = new UserGroup();
        ug2.setGroupName(restUG.getGroupName());
        us.getGroups().add(ug2);
        this.geoStoreClient.update(us.getId(), us);
        us = this.geoStoreClient.getUser(((RESTUser)userAssigned.get(0)).getId().longValue());
        Assert.assertEquals((long)2L, (long)us.getGroups().size());
        for (UserGroup gg : us.getGroups()) {
            if (!gg.getGroupName().equals(ug2.getGroupName())) continue;
            us.getGroups().remove(gg);
            break;
        }
        restUG = this.geoStoreClient.getUserGroup(ugid);
        this.geoStoreClient.update(us.getId(), us);
        us = this.geoStoreClient.getUser(((RESTUser)userAssigned.get(0)).getId().longValue());
        Assert.assertEquals((long)1L, (long)us.getGroups().size());
        this.geoStoreClient.deleteUserGroup(ug1.getId().longValue());
        this.geoStoreClient.deleteUserGroup(ugid);
        ugl = this.geoStoreClient.getUserGroups(Integer.valueOf(0), Integer.valueOf(1000), true);
        Assert.assertEquals((long)1L, (long)ugl.getUserGroupList().size());
        UserList ul = this.geoStoreClient.getUsers(Integer.valueOf(0), Integer.valueOf(1000));
        Assert.assertEquals((long)3L, (long)ul.getList().size());
        this.geoStoreClient.deleteUser(Long.valueOf(uid1));
        this.geoStoreClient.deleteUser(Long.valueOf(uid2));
        ul = this.geoStoreClient.getUsers(Integer.valueOf(0), Integer.valueOf(1000));
        Assert.assertEquals((long)1L, (long)ul.getList().size());
    }

    @Test
    public void testStoredDataServices() {
        this.createDefaultCategory();
        this.createUser("user", Role.USER, "user", new UserGroup[0]);
        ShortResource sr = this.createAResource();
        GeoStoreClient userGeoStoreClient = this.createUserClient("user", "user");
        String data = userGeoStoreClient.getData(Long.valueOf(sr.getId()));
        Assert.assertEquals((Object)"we wish you a merry xmas and a happy new year", (Object)data);
        this.createUser("u1", Role.USER, "u1", new UserGroup[0]);
        userGeoStoreClient = this.createUserClient("u1", "u1");
        try {
            userGeoStoreClient.getData(Long.valueOf(sr.getId()));
            Assert.fail((String)"Untrapped exception");
        }
        catch (UniformInterfaceException e) {
            int u1StatusR = e.getResponse().getStatus();
            Assert.assertEquals((long)403L, (long)u1StatusR);
        }
    }

    @Test
    public void testEVERYONEassignmentResources() {
        this.createDefaultCategory();
        this.createUser("user", Role.USER, "user", new UserGroup[0]);
        ShortResource sr = this.createAResource();
        SecurityRuleList srlFinal = this.geoStoreUserClient.getSecurityRules(Long.valueOf(sr.getId()));
        Assert.assertEquals((long)1L, (long)srlFinal.getList().size());
        SecurityRuleList srl = new SecurityRuleList();
        RESTSecurityRule everyoneRule = new RESTSecurityRule();
        Resource r = new Resource();
        r.setId(Long.valueOf(sr.getId()));
        everyoneRule.setCanRead(true);
        everyoneRule.setCanWrite(true);
        RESTUserGroup everyoneGroup = this.geoStoreClient.getUserGroup(GroupReservedNames.EVERYONE.toString());
        RESTUserGroup ug = new RESTUserGroup();
        ug.setGroupName(GroupReservedNames.EVERYONE.toString());
        ug.setId(everyoneGroup.getId());
        everyoneRule.setGroup(ug);
        ArrayList<RESTSecurityRule> restSR = new ArrayList<RESTSecurityRule>();
        restSR.add(everyoneRule);
        restSR.add((RESTSecurityRule)srlFinal.getList().get(0));
        srl.setList(restSR);
        this.geoStoreUserClient.updateSecurityRules(Long.valueOf(sr.getId()), srl);
        srlFinal = this.geoStoreUserClient.getSecurityRules(Long.valueOf(sr.getId()));
        Assert.assertEquals((long)2L, (long)srlFinal.getList().size());
    }

    @Test
    public void testEVERYONEassignmentUsers() {
        RESTUserGroup ug = this.geoStoreClient.getUserGroup(GroupReservedNames.EVERYONE.toString());
        this.createUser("user", Role.USER, "user", new UserGroup[0]);
        User u = this.geoStoreClient.getUser("user");
        int errorCode = -1;
        try {
            this.geoStoreClient.assignUserGroup(u.getId().longValue(), ug.getId().longValue());
        }
        catch (UniformInterfaceException e) {
            errorCode = e.getResponse().getStatus();
        }
        Assert.assertEquals((long)404L, (long)errorCode);
        errorCode = -1;
        try {
            this.geoStoreClient.deassignUserGroup(u.getId().longValue(), ug.getId().longValue());
        }
        catch (UniformInterfaceException e) {
            errorCode = e.getResponse().getStatus();
        }
        Assert.assertEquals((long)404L, (long)errorCode);
    }

    @Test
    public void testUserInitialization() {
        UserList ul = this.geoStoreClient.getUsers(Integer.valueOf(0), Integer.valueOf(100));
        Assert.assertEquals((long)1L, (long)ul.getList().size());
        for (RESTUser u : ul.getList()) {
            Assert.assertNull((Object)u.getGroupsNames());
        }
    }

    @Test
    public void everyoneGroupTest() {
        UserGroupList ugl = this.geoStoreClient.getUserGroups(Integer.valueOf(0), Integer.valueOf(1000), true);
        Assert.assertEquals((long)1L, (long)ugl.getUserGroupList().size());
        Assert.assertEquals((Object)"everyone", (Object)((RESTUserGroup)ugl.getUserGroupList().get(0)).getGroupName());
        this.createUser("user", Role.USER, "user", new UserGroup[0]);
        this.createDefaultCategory();
        ShortResource sr = this.createAResource();
        long uID = this.createUser("u1", Role.USER, "u1", new UserGroup[0]);
        GeoStoreClient userGeoStoreClient = this.createUserClient("u1", "u1");
        int u1StatusR = -1;
        int u1StatusW = -1;
        try {
            userGeoStoreClient.getResource(Long.valueOf(sr.getId()));
        }
        catch (UniformInterfaceException e) {
            u1StatusR = e.getResponse().getStatus();
        }
        Assert.assertEquals((long)403L, (long)u1StatusR);
        try {
            userGeoStoreClient.updateResource(Long.valueOf(sr.getId()), new RESTResource());
        }
        catch (UniformInterfaceException e) {
            u1StatusW = e.getResponse().getStatus();
        }
        Assert.assertEquals((long)403L, (long)u1StatusW);
        RESTUserGroup ugEveryone = this.geoStoreClient.getUserGroup("everyone");
        Assert.assertNotNull((Object)ugEveryone);
        Assert.assertEquals((long)0L, (long)this.geoStoreClient.getUser(uID).getGroups().size());
        int assignError = -1;
        try {
            this.geoStoreClient.assignUserGroup(uID, ugEveryone.getId().longValue());
        }
        catch (UniformInterfaceException e) {
            assignError = e.getResponse().getStatus();
        }
        Assert.assertEquals((long)404L, (long)assignError);
        Assert.assertEquals((long)0L, (long)this.geoStoreClient.getUser(uID).getGroups().size());
        u1StatusR = -1;
        u1StatusW = -1;
        int updateStatus = -1;
        ShortResourceList srl = new ShortResourceList();
        ArrayList<ShortResource> srlArray = new ArrayList<ShortResource>();
        srlArray.add(sr);
        srl.setList(srlArray);
        try {
            this.geoStoreClient.updateSecurityRules(srl, ugEveryone.getId(), false, true);
        }
        catch (UniformInterfaceException e) {
            updateStatus = e.getResponse().getStatus();
        }
        Assert.assertEquals((long)400L, (long)updateStatus);
        this.geoStoreClient.updateSecurityRules(srl, ugEveryone.getId(), true, false);
        userGeoStoreClient.getResource(Long.valueOf(sr.getId()));
        try {
            userGeoStoreClient.updateResource(Long.valueOf(sr.getId()), new RESTResource());
        }
        catch (UniformInterfaceException e) {
            u1StatusW = e.getResponse().getStatus();
        }
        Assert.assertEquals((long)403L, (long)u1StatusW);
    }

    @Test
    public void ListResourcesTest() {
        UserGroup ug = new UserGroup();
        ug.setGroupName("g1");
        long gid = this.geoStoreClient.insertUserGroup(ug);
        UserGroup anotherGroup = new UserGroup();
        anotherGroup.setGroupName("g2");
        long anotherGid = this.geoStoreClient.insertUserGroup(anotherGroup);
        this.createUser("user", Role.USER, "user", ug);
        this.createDefaultCategory();
        ShortResource sr = this.createAResource();
        ShortResource sr2 = this.createAResource();
        ShortResource sr3 = this.createAResource();
        ShortResource sr4 = this.createAResource();
        ShortResourceList srl = this.geoStoreUserClient.getAllShortResource(Integer.valueOf(0), Integer.valueOf(1000));
        ArrayList<ShortResource> listG1 = new ArrayList<ShortResource>();
        ArrayList<ShortResource> listG2 = new ArrayList<ShortResource>();
        int i = 0;
        for (ShortResource r : srl.getList()) {
            if (i < 2) {
                listG1.add(r);
            } else {
                listG2.add(r);
            }
            ++i;
        }
        this.createUser("u1", Role.USER, "u1", ug);
        GeoStoreClient u1Client = this.createUserClient("u1", "u1");
        ShortResourceList srlTmp = u1Client.getAllShortResource(Integer.valueOf(1), Integer.valueOf(1000));
        Assert.assertNull((Object)srlTmp.getList());
        FieldFilter filter = new FieldFilter(BaseField.NAME, "rest%", SearchOperator.LIKE);
        ResourceList rl = u1Client.searchResources((SearchFilter)filter, Integer.valueOf(-1), Integer.valueOf(-1), Boolean.valueOf(false), Boolean.valueOf(false));
        Assert.assertNull((Object)rl.getList());
        UserGroupList ugl = this.geoStoreClient.getUserGroups(Integer.valueOf(0), Integer.valueOf(1000), true);
        long ug1_id = -1L;
        long ug2_id = -1L;
        for (RESTUserGroup tmp_ug : ugl.getUserGroupList()) {
            if (tmp_ug.getGroupName().equalsIgnoreCase("g1")) {
                ug1_id = tmp_ug.getId();
            }
            if (!tmp_ug.getGroupName().equalsIgnoreCase("g2")) continue;
            ug2_id = tmp_ug.getId();
        }
        long errorCode = -1L;
        try {
            this.geoStoreClient.updateSecurityRules(new ShortResourceList(listG1), Long.valueOf(787687L), true, true);
        }
        catch (UniformInterfaceException e) {
            errorCode = e.getResponse().getStatus();
        }
        Assert.assertEquals((long)404L, (long)errorCode);
        this.geoStoreClient.updateSecurityRules(new ShortResourceList(listG1), Long.valueOf(ug1_id), true, true);
        this.geoStoreClient.updateSecurityRules(new ShortResourceList(listG2), Long.valueOf(ug2_id), true, true);
        srl = u1Client.getAllShortResource(Integer.valueOf(0), Integer.valueOf(1000));
        Assert.assertEquals((long)2L, (long)srl.getList().size());
        for (ShortResource r : srl.getList()) {
            if (r.getId() == ((ShortResource)listG1.get(0)).getId() || r.getId() == ((ShortResource)listG1.get(1)).getId()) {
                Assert.assertTrue((boolean)r.isCanDelete());
                Assert.assertTrue((boolean)r.isCanEdit());
                continue;
            }
            Assert.assertTrue((!r.isCanDelete() ? 1 : 0) != 0);
            Assert.assertTrue((!r.isCanEdit() ? 1 : 0) != 0);
        }
        rl = u1Client.searchResources((SearchFilter)filter, Integer.valueOf(-1), Integer.valueOf(-1), Boolean.valueOf(false), Boolean.valueOf(false));
        Assert.assertEquals((long)2L, (long)rl.getList().size());
    }

    @Test
    public void updateSecurityRulesTest() {
        UserGroup ug = new UserGroup();
        ug.setGroupName("usergroupTest1");
        long gid = this.geoStoreClient.insertUserGroup(ug);
        UserGroup ug2 = new UserGroup();
        ug2.setGroupName("unusedGroup");
        long gid2 = this.geoStoreClient.insertUserGroup(ug2);
        UserGroup anotherGroup = new UserGroup();
        anotherGroup.setGroupName("anotherGroup");
        long anotherGid = this.geoStoreClient.insertUserGroup(anotherGroup);
        HashSet<UserGroup> ugroups = new HashSet<UserGroup>();
        ugroups.add(ug);
        ugroups.add(anotherGroup);
        this.createUser("u1", Role.USER, "u1", new UserGroup[0]);
        this.createUser("u2", Role.USER, "u2", ug, anotherGroup);
        GeoStoreClient u1Client = this.createUserClient("u1", "u1");
        GeoStoreClient u2Client = this.createUserClient("u2", "u2");
        this.createUser("user", Role.USER, "user", new UserGroup[0]);
        this.createDefaultCategory();
        ShortResource sr = this.createAResource();
        ShortResource sr2 = this.createAResource();
        try {
            u1Client.getResource(Long.valueOf(sr.getId()), true);
            Assert.fail((String)"Untrapped exception");
        }
        catch (UniformInterfaceException e) {
            Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
        }
        try {
            u2Client.getResource(Long.valueOf(sr.getId()), true);
            Assert.fail((String)"Untrapped exception");
        }
        catch (UniformInterfaceException e) {
            Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
        }
        try {
            u1Client.updateResource(Long.valueOf(sr.getId()), new RESTResource());
            Assert.fail((String)"Untrapped exception");
        }
        catch (UniformInterfaceException e) {
            Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
        }
        try {
            u2Client.updateResource(Long.valueOf(sr.getId()), new RESTResource());
            Assert.fail((String)"Untrapped exception");
        }
        catch (UniformInterfaceException e) {
            Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
        }
        ArrayList<ShortResource> srl = new ArrayList<ShortResource>();
        srl.add(sr);
        ShortResourceList srll = new ShortResourceList(srl);
        ShortResourceList srlf = this.geoStoreClient.getAllShortResource(Integer.valueOf(0), Integer.valueOf(1000));
        Assert.assertEquals((long)2L, (long)srlf.getList().size());
        this.geoStoreClient.updateSecurityRules(srll, Long.valueOf(gid), false, true);
        this.geoStoreClient.updateSecurityRules(srll, Long.valueOf(gid2), false, false);
        srlf = this.geoStoreClient.getAllShortResource(Integer.valueOf(0), Integer.valueOf(1000));
        Assert.assertEquals((long)2L, (long)srlf.getList().size());
        try {
            u1Client.getResource(Long.valueOf(sr.getId()), true);
        }
        catch (UniformInterfaceException e) {
            Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
        }
        try {
            u2Client.getResource(Long.valueOf(sr.getId()), true);
        }
        catch (UniformInterfaceException e) {
            Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
        }
        try {
            u1Client.updateResource(Long.valueOf(sr.getId()), new RESTResource());
        }
        catch (UniformInterfaceException e) {
            Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
        }
        u2Client.updateResource(Long.valueOf(sr.getId()), new RESTResource());
    }

    @Test
    public void getAllGroupsWithoutEveryoneTest() {
        int GROUP_NUM = 3;
        this.addSomeUserGroups(3, "randomGroups");
        ExtGroupList res = this.geoStoreClient.searchUserGroup(Integer.valueOf(0), Integer.valueOf(10), "*");
        Assert.assertEquals((String)"Bad number of user group", (long)3L, (long)res.getCount());
    }

    @Test
    public void getAllGroupsWithEveryoneTest() {
        int grpCount = 3;
        this.addSomeUserGroups(grpCount, "randomGroups");
        ExtGroupList res = this.geoStoreClient.searchUserGroup(Integer.valueOf(0), Integer.valueOf(10), "*", true);
        Assert.assertEquals((long)(grpCount + 1), (long)res.getCount());
    }

    @Test
    public void searchGroupTest() {
        int grpNum = 4;
        int targetGrpNum = 2;
        String targetGrpPrefix = "target";
        this.addSomeUserGroups(grpNum, "smokeGrp");
        this.addSomeUserGroups(targetGrpNum, targetGrpPrefix);
        ExtGroupList searchResult = this.geoStoreClient.searchUserGroup(Integer.valueOf(0), Integer.valueOf(10), "*" + targetGrpPrefix + "*");
        Assert.assertTrue((searchResult.getList().size() == targetGrpNum ? 1 : 0) != 0);
    }

    @Test
    public void noGroupsForNormalUserTest() {
        this.addSomeUserGroups(8, "randomGrp");
        this.createUser("user", Role.USER, "user", new UserGroup[0]);
        GeoStoreClient client = this.createUserClient("user", "user");
        ExtGroupList result = client.searchUserGroup(Integer.valueOf(0), Integer.valueOf(10), "*");
        Assert.assertEquals((long)result.getCount(), (long)0L);
    }

    @Test
    public void allGroupsOfAnUserTest() {
        int grpTestUserNum = 5;
        int grpUUserNum = 3;
        String usrTestName = "test";
        String usrTestPasswd = "test";
        User testUser = new User();
        testUser.setName(usrTestName);
        testUser.setRole(Role.USER);
        testUser.setNewPassword(usrTestPasswd);
        Set<UserGroup> testUserGroups = this.createSomeGroups(grpTestUserNum, usrTestName);
        this.addSomeUserGroups(testUserGroups);
        testUser.setGroups(testUserGroups);
        this.geoStoreClient.insert(testUser);
        User u = new User();
        u.setName("u");
        u.setRole(Role.USER);
        Set<UserGroup> uGroups = this.createSomeGroups(grpUUserNum, "u");
        this.addSomeUserGroups(uGroups);
        u.setGroups(uGroups);
        this.geoStoreClient.insert(u);
        GeoStoreClient userClient = this.createUserClient(usrTestName, usrTestPasswd);
        ExtGroupList result = userClient.searchUserGroup(Integer.valueOf(0), Integer.valueOf(10), "*");
        Assert.assertEquals((long)result.getCount(), (long)grpTestUserNum);
    }

    @Test
    public void userGroupsPaginationTest() {
        int totalGrps = 10;
        int pageSize = 3;
        int[] expectedItems = new int[]{3, 3, 3, 1};
        this.addSomeUserGroups(totalGrps, "paging");
        for (int page = 0; page < expectedItems.length; ++page) {
            ExtGroupList result = this.geoStoreClient.searchUserGroup(Integer.valueOf(page * pageSize), Integer.valueOf(pageSize), "*");
            Assert.assertTrue((expectedItems[page] == result.getList().size() ? 1 : 0) != 0);
        }
    }

    protected Set<UserGroup> createSomeGroups(int amount, String namePrefix) {
        HashSet<UserGroup> grps = new HashSet<UserGroup>();
        for (int i = 0; i < amount; ++i) {
            UserGroup grp = new UserGroup();
            grp.setGroupName(namePrefix + i);
            grp.setDescription(namePrefix + i + "-Description");
            grps.add(grp);
        }
        return grps;
    }

    protected void addSomeUserGroups(int n, String namePrefix) {
        for (UserGroup g : this.createSomeGroups(n, namePrefix)) {
            this.geoStoreClient.insertUserGroup(g);
        }
    }

    protected void addSomeUserGroups(Set<UserGroup> groups) {
        for (UserGroup g : groups) {
            this.geoStoreClient.insertUserGroup(g);
        }
    }

    protected void removeAllUsers(GeoStoreClient client) {
        UserList users = this.geoStoreClient.getUsers(Integer.valueOf(0), Integer.valueOf(1000));
        List usersList = users.getList();
        usersList = usersList == null ? new ArrayList() : usersList;
        for (RESTUser u : usersList) {
            if ("admin".equals(u.getName())) continue;
            try {
                this.geoStoreClient.deleteUser(u.getId());
            }
            catch (Exception e) {
                LOGGER.error("Error removing " + String.valueOf(u));
            }
        }
    }

    protected void removeAllUserGroup(GeoStoreClient client) {
        UserGroupList groups = this.geoStoreClient.getUserGroups(Integer.valueOf(0), Integer.valueOf(1000), true);
        List groupList = groups.getUserGroupList();
        groupList = groupList == null ? new ArrayList() : groupList;
        for (RESTUserGroup ug : groupList) {
            try {
                this.geoStoreClient.deleteUserGroup(ug.getId().longValue());
            }
            catch (Exception e) {
                LOGGER.error("Error removing " + String.valueOf(ug));
            }
        }
    }

    protected Long createDefaultCategory() {
        Long catid = this.geoStoreClient.insert(new RESTCategory("TestCategory1"));
        Assert.assertNotNull((Object)catid);
        return catid;
    }

    protected ShortResource createAResource() {
        RESTStoredData storedData = new RESTStoredData();
        storedData.setData("we wish you a merry xmas and a happy new year");
        ArrayList<ShortAttribute> attrList = new ArrayList<ShortAttribute>();
        attrList.add(new ShortAttribute("stringAtt", "OrigStringValue", DataType.STRING));
        String timeid = Long.toString(System.currentTimeMillis());
        RESTResource origResource = new RESTResource();
        origResource.setCategory(new RESTCategory("TestCategory1"));
        origResource.setName("rest_test_resource_" + timeid);
        origResource.setStore(storedData);
        origResource.setAttribute(attrList);
        GeoStoreClient userGeoStoreClient = this.createUserClient("user", "user");
        Long rid = userGeoStoreClient.insert(origResource);
        origResource.setId(rid);
        ShortResource sr = new ShortResource();
        sr.setId(rid.longValue());
        sr.setName("rest_test_resource_" + timeid);
        return sr;
    }

    protected void removeAllResources(GeoStoreClient client) {
        FieldFilter filter = new FieldFilter(BaseField.NAME, "*", SearchOperator.IS_NOT_NULL);
        ShortResourceList resources = client.searchResources((SearchFilter)filter);
        if (resources.getList() != null) {
            LOGGER.info("Found " + resources.getList().size() + " resources");
            for (ShortResource shortResource : resources.getList()) {
                LOGGER.info("Found resource " + String.valueOf(shortResource) + " . Deleting...");
                client.deleteResource(Long.valueOf(shortResource.getId()));
            }
        } else {
            LOGGER.info("No resource found");
        }
        resources = client.searchResources((SearchFilter)filter);
        Assert.assertNull((String)"Not all resources have been deleted", (Object)resources.getList());
    }

    protected void removeAllCategories(GeoStoreClient client) {
        CategoryList categories = client.getCategories();
        if (categories.getList() != null) {
            LOGGER.info("Found " + categories.getList().size() + " categories");
            for (Category category : categories.getList()) {
                LOGGER.info("Found category " + String.valueOf(category) + " . Deleting...");
                client.deleteCategory(category.getId());
            }
        } else {
            LOGGER.info("No category found");
        }
        categories = client.getCategories();
        Assert.assertNull((String)"Not all categories have been deleted", (Object)categories.getList());
    }

    protected long createUser(String name, Role role, String pw, UserGroup ... group) {
        User user = new User();
        user.setName(name);
        user.setRole(role);
        user.setNewPassword(pw);
        if (group != null) {
            user.setGroups(new HashSet<UserGroup>(Arrays.asList(group)));
        }
        return this.geoStoreClient.insert(user);
    }
}

