/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.dao.ResourceDAO;
import it.geosolutions.geostore.core.dao.UserDAO;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.StoredData;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.CategoryService;
import it.geosolutions.geostore.services.FavoriteService;
import it.geosolutions.geostore.services.ResourcePermissionService;
import it.geosolutions.geostore.services.ResourceService;
import it.geosolutions.geostore.services.StoredDataService;
import it.geosolutions.geostore.services.TagService;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.dto.ResourceSearchParameters;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.RESTResourceService;
import it.geosolutions.geostore.services.rest.RESTUserService;
import it.geosolutions.geostore.services.rest.model.RESTCategory;
import it.geosolutions.geostore.services.rest.model.RESTResource;
import it.geosolutions.geostore.services.rest.model.SecurityRuleList;
import it.geosolutions.geostore.services.rest.utils.Convert;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;

public class ServiceTestBase {
    protected static RESTResourceService restResourceService;
    protected static RESTUserService restUserService;
    protected static StoredDataService storedDataService;
    protected static ResourceService resourceService;
    protected static CategoryService categoryService;
    protected static UserService userService;
    protected static UserGroupService userGroupService;
    protected static TagService tagService;
    protected static FavoriteService favoriteService;
    protected static ResourcePermissionService resourcePermissionService;
    protected static ResourceDAO resourceDAO;
    protected static UserDAO userDAO;
    protected static ClassPathXmlApplicationContext ctx;
    protected final Logger LOGGER = LogManager.getLogger(this.getClass());
    @Rule
    public TestName testName = new TestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceTestBase() {
        Class<ServiceTestBase> clazz = ServiceTestBase.class;
        synchronized (ServiceTestBase.class) {
            if (ctx == null) {
                String[] paths = new String[]{"classpath*:applicationContext.xml"};
                ctx = new ClassPathXmlApplicationContext(paths);
                restResourceService = (RESTResourceService)ctx.getBean("restResourceService", RESTResourceService.class);
                restUserService = (RESTUserService)ctx.getBean("restUserService", RESTUserService.class);
                storedDataService = (StoredDataService)ctx.getBean("storedDataService", StoredDataService.class);
                resourceService = (ResourceService)ctx.getBean("resourceService");
                categoryService = (CategoryService)ctx.getBean("categoryService");
                userService = (UserService)ctx.getBean("userService");
                userGroupService = (UserGroupService)ctx.getBean("userGroupService");
                tagService = (TagService)ctx.getBean("tagService");
                favoriteService = (FavoriteService)ctx.getBean("favoriteService");
                resourcePermissionService = (ResourcePermissionService)ctx.getBean("resourcePermissionService");
                resourceDAO = (ResourceDAO)ctx.getBean("resourceDAO");
                userDAO = (UserDAO)ctx.getBean("userDAO");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Before
    public void setUp() throws Exception {
        this.testCheckServices();
        this.LOGGER.info("################ Running " + this.getClass().getSimpleName() + "::" + this.testName.getMethodName());
        this.removeAll();
    }

    public void testCheckServices() {
        Assert.assertNotNull((Object)restResourceService);
        Assert.assertNotNull((Object)restUserService);
        Assert.assertNotNull((Object)storedDataService);
        Assert.assertNotNull((Object)resourceService);
        Assert.assertNotNull((Object)categoryService);
        Assert.assertNotNull((Object)userService);
        Assert.assertNotNull((Object)userGroupService);
        Assert.assertNotNull((Object)tagService);
        Assert.assertNotNull((Object)resourcePermissionService);
        Assert.assertNotNull((Object)resourceDAO);
        Assert.assertNotNull((Object)userDAO);
    }

    protected void removeAll() throws NotFoundServiceEx, BadRequestServiceEx, InternalErrorServiceEx {
        this.LOGGER.info("***** removeAll()");
        this.removeAllTag();
        this.removeAllResource();
        this.removeAllStoredData();
        this.removeAllCategory();
        this.removeAllUser();
        this.removeAllUserGroup();
    }

    private void removeAllTag() throws BadRequestServiceEx {
        tagService.getAll(null, null, null).forEach(item -> {
            this.LOGGER.info("Removing tag: {}", (Object)item.getName());
            try {
                tagService.delete(item.getId().longValue());
            }
            catch (NotFoundServiceEx e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void removeAllUserGroup() throws BadRequestServiceEx, NotFoundServiceEx {
        List list = userGroupService.getAll(null, null);
        for (UserGroup item : list) {
            this.LOGGER.info("Removing User: " + item.getGroupName());
            boolean ret = userGroupService.delete(item.getId().longValue());
            Assert.assertTrue((String)"Group not removed", (boolean)ret);
        }
        Assert.assertEquals((String)"Group have not been properly deleted", (long)0L, (long)userService.getCount(null));
    }

    private void removeAllUser() throws BadRequestServiceEx {
        List list = userService.getAll(null, null);
        for (User item : list) {
            this.LOGGER.info("Removing User: " + item.getName());
            boolean ret = userService.delete(item.getId().longValue());
            Assert.assertTrue((String)"User not removed", (boolean)ret);
        }
        Assert.assertEquals((String)"User have not been properly deleted", (long)0L, (long)userService.getCount(null));
    }

    private void removeAllCategory() throws BadRequestServiceEx {
        List list = categoryService.getAll(null, null);
        for (Category item : list) {
            this.LOGGER.info("Removing " + String.valueOf(item));
            boolean ret = categoryService.delete(item.getId().longValue());
            Assert.assertTrue((String)"Category not removed", (boolean)ret);
        }
        Assert.assertEquals((String)"Category have not been properly deleted", (long)0L, (long)categoryService.getCount(null));
    }

    protected void removeAllStoredData() throws NotFoundServiceEx {
        List list = storedDataService.getAll();
        for (StoredData item : list) {
            this.LOGGER.info("Removing " + String.valueOf(item));
            boolean ret = storedDataService.delete(item.getId().longValue());
            Assert.assertTrue((String)"Data not removed", (boolean)ret);
        }
    }

    private void removeAllResource() throws BadRequestServiceEx, InternalErrorServiceEx {
        List list = resourceService.getAll(ResourceSearchParameters.builder().authUser(this.buildFakeAdminUser()).build());
        for (ShortResource item : list) {
            this.LOGGER.info("Removing " + String.valueOf(item));
            boolean ret = resourceService.delete(item.getId());
            Assert.assertTrue((String)"Resource not removed", (boolean)ret);
        }
        Assert.assertEquals((String)"Resource have not been properly deleted", (long)0L, (long)resourceService.getCount(null));
    }

    protected long createData(String data, Resource resource) throws Exception {
        return storedDataService.update(resource.getId().longValue(), data);
    }

    protected long createResource(String name, String description, String catName, boolean advertised) throws Exception {
        Category category = new Category();
        category.setName(catName);
        categoryService.insert(category);
        Resource resource = new Resource();
        resource.setName(name);
        resource.setDescription(description);
        resource.setCategory(category);
        resource.setCreator("USER1");
        resource.setEditor("USER2");
        resource.setAdvertised(Boolean.valueOf(advertised));
        return resourceService.insert(resource);
    }

    protected long restCreateResource(String name, String description, String catName, long userId, boolean advertised) throws Exception {
        RESTResource resource = new RESTResource();
        resource.setName(name);
        resource.setDescription(description);
        resource.setCategory(new RESTCategory(catName));
        resource.setAdvertised(advertised);
        SimpleSecurityContext sc = new SimpleSecurityContext(userId);
        return restResourceService.insert((SecurityContext)sc, resource);
    }

    protected long restCreateResource(String name, String description, String catName, long userId, SecurityRuleList rules, boolean advertised) throws Exception {
        long resId = this.restCreateResource(name, description, catName, userId, advertised);
        SimpleSecurityContext sc = new SimpleSecurityContext(userId);
        restResourceService.updateSecurityRules((SecurityContext)sc, resId, rules);
        return resId;
    }

    protected long createResource(String name, String description, Category category, boolean advertised) throws Exception {
        Resource resource = new Resource();
        resource.setName(name);
        resource.setDescription(description);
        resource.setCategory(category);
        resource.setCreator("USER1");
        resource.setEditor("USER2");
        resource.setAdvertised(Boolean.valueOf(advertised));
        return resourceService.insert(resource);
    }

    protected long createResource(String name, String description, String catName, List<SecurityRule> rules, boolean advertised) throws Exception {
        Category category = new Category();
        category.setName(catName);
        categoryService.insert(category);
        Resource resource = new Resource();
        resource.setName(name);
        resource.setDescription(description);
        resource.setCategory(category);
        resource.setSecurity(rules);
        resource.setCreator("USER1");
        resource.setEditor("USER2");
        resource.setAdvertised(Boolean.valueOf(advertised));
        return resourceService.insert(resource);
    }

    protected Category createCategory(String name) throws Exception {
        Category category = new Category();
        category.setName(name);
        long id = categoryService.insert(category);
        return categoryService.get(id);
    }

    protected long createUser(String name, Role role, String password) throws Exception {
        User user = new User();
        user.setName(name);
        user.setRole(role);
        user.setNewPassword(password);
        UserAttribute attr = new UserAttribute();
        attr.setName("attname");
        attr.setValue("attvalue");
        user.setAttribute(Collections.singletonList(attr));
        return userService.insert(user);
    }

    protected long restCreateUser(String name, Role role, Set<UserGroup> groups, String password) throws Exception {
        User user = new User();
        user.setName(name);
        user.setRole(role);
        if (groups != null && !groups.isEmpty()) {
            user.setGroups(groups);
        }
        user.setNewPassword(password);
        UserAttribute attr = new UserAttribute();
        attr.setName("attname");
        attr.setValue("RESTattvalue");
        user.setAttribute(Collections.singletonList(attr));
        return restUserService.insert(null, user);
    }

    protected <T> T getTargetObject(Object proxy, Class<T> targetClass) throws Exception {
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return (T)((Advised)proxy).getTargetSource().getTarget();
        }
        return (T)proxy;
    }

    protected long createUser(String name, Role role, String password, List<UserAttribute> attributes) throws Exception {
        User user = new User();
        user.setName(name);
        user.setRole(role);
        user.setNewPassword(password);
        user.setAttribute(attributes);
        return userService.insert(user);
    }

    protected long createGroup(String name) throws Exception {
        UserGroup group = new UserGroup();
        group.setGroupName(name);
        return userGroupService.insert(group);
    }

    protected RESTResource createRESTResource(Resource resource) {
        RESTResource ret = new RESTResource();
        ret.setCategory(new RESTCategory(resource.getCategory().getName()));
        ret.setName(resource.getName());
        ret.setDescription(resource.getDescription());
        ret.setMetadata(resource.getMetadata());
        ret.setCreator(resource.getCreator());
        ret.setEditor(resource.getEditor());
        if (resource.getData() != null) {
            ret.setData(resource.getData().getData());
        }
        if (CollectionUtils.isNotEmpty((Collection)resource.getAttribute())) {
            ret.setAttribute(Convert.convertToShortAttributeList((List)resource.getAttribute()));
        }
        return ret;
    }

    protected User buildFakeAdminUser() {
        User user = new User();
        user.setRole(Role.ADMIN);
        user.setName("ThisIsNotARealUser");
        return user;
    }

    static {
        ctx = null;
    }

    class SimpleSecurityContext
    implements SecurityContext {
        private Principal userPrincipal;

        public SimpleSecurityContext() {
        }

        public SimpleSecurityContext(long userId) {
            this.userPrincipal = new UsernamePasswordAuthenticationToken(userDAO.find(Long.valueOf(userId)), null);
        }

        public Principal getUserPrincipal() {
            return this.userPrincipal;
        }

        public void setUserPrincipal(Principal userPrincipal) {
            this.userPrincipal = userPrincipal;
        }

        public boolean isUserInRole(String role) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isSecure() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getAuthenticationScheme() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

