/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.utils;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.security.password.PwEncoder;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MockedUserService
implements UserService {
    private static final Random RANDOM = new Random();
    private final Map<Long, User> USERS = new ConcurrentHashMap<Long, User>();

    public long insert(User user) throws BadRequestServiceEx, NotFoundServiceEx {
        Long id = RANDOM.nextLong();
        user.setId(id);
        String password = user.getPassword() != null ? user.getPassword() : (user.getNewPassword() != null ? user.getNewPassword() : null);
        user.setPassword(password == null ? null : PwEncoder.encode((String)password));
        this.USERS.put(id, user);
        return id;
    }

    public long update(User user) throws NotFoundServiceEx, BadRequestServiceEx {
        Long id = null;
        if (user.getId() != null && this.USERS.containsKey(user.getId())) {
            id = user.getId();
            this.USERS.put(id, user);
        }
        return id;
    }

    public boolean delete(long id) {
        return this.USERS.containsKey(id) && this.USERS.remove(id) != null;
    }

    public User get(long id) {
        return this.USERS.get(id);
    }

    public User get(String name) throws NotFoundServiceEx {
        for (User user : this.USERS.values()) {
            if (!user.getName().equals(name)) continue;
            return user;
        }
        throw new NotFoundServiceEx("User not found");
    }

    public List<User> getAll(Integer page, Integer entries) throws BadRequestServiceEx {
        LinkedList<User> users = new LinkedList<User>();
        for (User user : this.USERS.values()) {
            users.add(user);
        }
        return users;
    }

    public List<User> getAll(Integer page, Integer entries, String nameLike, boolean includeAttributes) throws BadRequestServiceEx {
        return this.getAll(page, entries);
    }

    public long getCount(String nameLike) {
        return 0L;
    }

    public void updateAttributes(long id, List<UserAttribute> attributes) throws NotFoundServiceEx {
    }

    public boolean insertSpecialUsers() {
        return false;
    }

    public Collection<User> getByAttribute(UserAttribute attribute) {
        return null;
    }

    public Collection<User> getByGroup(UserGroup ug) {
        LinkedList<User> ret = new LinkedList<User>();
        block0: for (User user : this.USERS.values()) {
            Set groups = user.getGroups();
            if (groups == null) continue;
            for (UserGroup group : groups) {
                if (group.getId() != ug.getId() && !group.getGroupName().equals(ug.getGroupName())) continue;
                ret.add(user);
                continue block0;
            }
        }
        return ret;
    }
}

