/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.utils;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GeoStoreContext
implements ApplicationContextAware {
    private static final Logger LOGGER = LogManager.getLogger(GeoStoreContext.class);
    static ApplicationContext context;

    public static <T> Map<String, T> beans(Class<T> clazz) {
        Map result = null;
        try {
            if (context != null) {
                result = context.getBeansOfType(clazz);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while retrieving the bean of type {}", (Object)clazz.getSimpleName(), (Object)e);
        }
        return result;
    }

    public static <T> T bean(Class<T> clazz) {
        Object result = null;
        try {
            if (context != null) {
                result = context.getBean(clazz);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while retrieving the bean of type {}", (Object)clazz.getSimpleName(), (Object)e);
        }
        return (T)result;
    }

    public static Object bean(String name) {
        Object result = null;
        try {
            if (context != null) {
                result = context.getBean(name);
            }
        }
        catch (BeansException e) {
            LOGGER.error("Error while retrieving the bean with name {}", (Object)name, (Object)e);
        }
        return result;
    }

    public static <T> T bean(String name, Class<T> clazz) {
        return clazz.cast(GeoStoreContext.bean(name));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }
}

