/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.services.rest.security.TokenAuthenticationFilter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;

public class WebServiceTokenAuthenticationFilter
extends TokenAuthenticationFilter {
    private static final Logger LOGGER = LogManager.getLogger(WebServiceTokenAuthenticationFilter.class);
    private final String url;
    Pattern searchUserRegex = null;
    int connectTimeout = 5;
    int readTimeout = 10;
    HttpClientBuilder clientBuilder = HttpClientBuilder.create();
    private HttpClient httpClient = null;
    private RequestConfig connectionConfig;

    public WebServiceTokenAuthenticationFilter(String url) {
        this.url = url;
    }

    public void setSearchUser(String searchUser) {
        this.searchUserRegex = Pattern.compile(searchUser);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.clientBuilder.useSystemProperties().build();
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Authentication checkToken(String token) {
        String webServiceUrl = this.url.replace("{token}", token);
        HttpClient client = this.getHttpClient();
        this.connectionConfig = RequestConfig.custom().setConnectionRequestTimeout(this.connectTimeout * 1000).setSocketTimeout(this.readTimeout * 1000).build();
        HttpGet method = null;
        try {
            LOGGER.debug("Issuing request to webservice: " + this.url);
            method = new HttpGet(webServiceUrl);
            method.setConfig(this.connectionConfig);
            HttpResponse httpResponse = client.execute((HttpUriRequest)method);
            if (this.getStatusCode(httpResponse) == 200) {
                String response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8").replace("\r", "").replace("\n", "");
                if (response != null) {
                    if (this.searchUserRegex == null) {
                        Authentication authentication = this.createAuthenticationForUser(response, null, "");
                        return authentication;
                    }
                    Matcher matcher = this.searchUserRegex.matcher(response);
                    if (matcher.find()) {
                        Authentication authentication = this.createAuthenticationForUser(matcher.group(1), null, response);
                        return authentication;
                    }
                    LOGGER.warn("Error in getting username from webservice response cannot find userName in response");
                } else {
                    LOGGER.error("No response received from webservice: " + this.url);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading data from webservice: " + this.url, (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return null;
    }

    public int getStatusCode(HttpResponse response) {
        if (response != null) {
            StatusLine statusLine = response.getStatusLine();
            return statusLine.getStatusCode();
        }
        return -1;
    }
}

