/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.keycloak.GeoStoreKeycloakAuthenticator;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakRequestWrapper;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakSessionServiceDelegate;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakTokenDetails;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.keycloak.adapters.springsecurity.token.SpringSecurityAdapterTokenStoreFactory;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.enums.TokenStore;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class KeyCloakHelper {
    private static final Logger LOGGER = LogManager.getLogger(KeycloakSessionServiceDelegate.class);
    protected final SpringSecurityAdapterTokenStoreFactory adapterTokenStoreFactory = new SpringSecurityAdapterTokenStoreFactory();
    protected AdapterDeploymentContext keycloakContext;

    public KeyCloakHelper(AdapterDeploymentContext keycloakContext) {
        this.keycloakContext = keycloakContext;
    }

    public KeycloakDeployment getDeployment(HttpServletRequest request, HttpServletResponse response) {
        SimpleHttpFacade exchange = new SimpleHttpFacade(request, response);
        return this.getDeployment((HttpFacade)exchange);
    }

    public KeycloakDeployment getDeployment(HttpFacade exchange) {
        KeycloakDeployment deployment = this.keycloakContext.resolveDeployment(exchange);
        deployment.setTokenStore(TokenStore.COOKIE);
        deployment.setDelegateBearerErrorResponseSending(true);
        return deployment;
    }

    public RequestAuthenticator getAuthenticator(HttpServletRequest request, HttpServletResponse response, KeycloakDeployment deployment) {
        request = new KeyCloakRequestWrapper((HttpServletRequest)request);
        AdapterTokenStore tokenStore = this.adapterTokenStoreFactory.createAdapterTokenStore(deployment, request, response);
        SimpleHttpFacade simpleHttpFacade = new SimpleHttpFacade(request, response);
        return new GeoStoreKeycloakAuthenticator((HttpFacade)simpleHttpFacade, (HttpServletRequest)request, deployment, tokenStore, -1);
    }

    public AccessTokenResponse refreshToken(AdapterConfig adapter, String refreshToken) {
        Configuration clientConf = this.getClientConfiguration(adapter);
        String url = adapter.getAuthServerUrl() + "/realms/" + adapter.getRealm() + "/protocol/openid-connect/token";
        String clientId = adapter.getResource();
        String secret = (String)adapter.getCredentials().get("secret");
        Http http = new Http(clientConf, (params, headers) -> {});
        return (AccessTokenResponse)http.post(url).authentication().client().form().param("grant_type", "refresh_token").param("refresh_token", refreshToken).param("client_id", clientId).param("client_secret", secret).response().json(AccessTokenResponse.class).execute();
    }

    public Configuration getClientConfiguration(AdapterConfig config) {
        String serverUrl = config.getAuthServerUrl();
        String realm = config.getRealm();
        String resource = config.getResource();
        Map credentials = config.getCredentials();
        return new Configuration(serverUrl, realm, resource, credentials, null);
    }

    public Authentication updateAuthentication(TokenAuthenticationCache cache, String oldToken, String newToken, String refreshToken, long expiresIn) {
        Authentication authentication = cache.get(oldToken);
        if (authentication == null) {
            authentication = SecurityContextHolder.getContext().getAuthentication();
        }
        if (authentication instanceof PreAuthenticatedAuthenticationToken) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info("Updating the cache and the SecurityContext with new Auth details");
            }
            cache.removeEntry(oldToken);
            PreAuthenticatedAuthenticationToken updated = new PreAuthenticatedAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), authentication.getAuthorities());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Updating keycloak details.");
            }
            KeycloakTokenDetails details = new KeycloakTokenDetails(newToken, refreshToken, expiresIn);
            updated.setDetails((Object)details);
            cache.putCacheEntry(newToken, (Authentication)updated);
            SecurityContextHolder.getContext().setAuthentication((Authentication)updated);
            authentication = updated;
        }
        return authentication;
    }
}

