/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.utils;

import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.rest.utils.GeoStorePrincipal;
import java.security.Principal;
import org.apache.cxf.security.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeoStoreSecurityContext
implements SecurityContext {
    private static final Logger LOGGER = LogManager.getLogger(GeoStoreSecurityContext.class);
    private GeoStorePrincipal principal;

    public void setPrincipal(GeoStorePrincipal principal) {
        this.principal = principal;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        boolean ret = this.isUserInRoleAux(role);
        LOGGER.info("User " + this.principal.getName() + " in " + role + " : " + ret);
        return ret;
    }

    public boolean isUserInRoleAux(String role) {
        if (Role.GUEST.name().equals(role)) {
            return this.principal.isGuest();
        }
        if (this.principal.isGuest()) {
            return false;
        }
        return this.principal.getUser().getRole().name().equals(role);
    }
}

