/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.service.impl;

import it.geosolutions.geostore.core.model.Tag;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.impl.RESTTagServiceImpl;
import it.geosolutions.geostore.services.rest.model.TagList;
import it.geosolutions.geostore.services.rest.utils.MockSecurityContext;
import java.util.List;
import javax.ws.rs.core.SecurityContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RESTTagServiceImplTest
extends ServiceTestBase {
    RESTTagServiceImpl restService;

    @Before
    public void setUp() throws BadRequestServiceEx, NotFoundServiceEx {
        this.restService = new RESTTagServiceImpl();
        this.restService.setTagService(tagService);
    }

    @After
    public void tearDown() throws Exception {
        this.removeAll();
    }

    @Test
    public void testGetAllWithPagination() throws Exception {
        Tag tag_a = new Tag("tag-A", "#4561aa", "dusky");
        Tag tag_b = new Tag("tag-B", "black", null);
        Tag tag_c = new Tag("tag-C", "navy", "kind of blue");
        long userID = this.createUser("user", Role.USER, "user");
        MockSecurityContext sc = new MockSecurityContext(userService.get(userID));
        tagService.insert(tag_a);
        tagService.insert(tag_b);
        tagService.insert(tag_c);
        TagList firstPage = this.restService.getAll((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(2), null);
        RESTTagServiceImplTest.assertEquals((long)3L, (long)firstPage.getCount());
        RESTTagServiceImplTest.assertEquals(List.of(tag_a, tag_b), (Object)firstPage.getList());
        TagList secondPage = this.restService.getAll((SecurityContext)sc, Integer.valueOf(1), Integer.valueOf(2), null);
        RESTTagServiceImplTest.assertEquals((long)3L, (long)firstPage.getCount());
        RESTTagServiceImplTest.assertEquals(List.of(tag_c), (Object)secondPage.getList());
    }
}

