/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.RESTUserGroupService;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.RESTUserGroup;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import it.geosolutions.geostore.services.rest.model.UserGroupList;
import it.geosolutions.geostore.services.rest.model.UserList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RESTUserGroupServiceImpl
implements RESTUserGroupService {
    private static final Logger LOGGER = LogManager.getLogger(RESTUserGroupServiceImpl.class);
    private UserGroupService userGroupService;
    private UserService userService;

    public void setUserGroupService(UserGroupService userGroupService) {
        this.userGroupService = userGroupService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public long insert(SecurityContext sc, RESTUserGroup userGroup) {
        if (userGroup == null) {
            throw new BadRequestWebEx("User is null");
        }
        if (userGroup.getId() != null) {
            throw new BadRequestWebEx("Id should be null");
        }
        long id = -1L;
        try {
            UserGroup group = new UserGroup();
            group.setGroupName(userGroup.getGroupName());
            group.setDescription(userGroup.getDescription());
            group.setEnabled(true);
            List ugAttrs = userGroup.getAttributes();
            if (ugAttrs != null) {
                userGroup.setAttributes(null);
            }
            id = this.userGroupService.insert(group);
            if (ugAttrs != null) {
                this.userGroupService.updateAttributes(id, ugAttrs);
            }
        }
        catch (BadRequestServiceEx | NotFoundServiceEx e) {
            throw new BadRequestWebEx(e.getMessage());
        }
        return id;
    }

    public void delete(SecurityContext sc, long id) throws NotFoundWebEx {
        if (id < 0L) {
            throw new BadRequestWebEx("The user group id you provide is < 0... not good...");
        }
        try {
            this.userGroupService.delete(id);
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
        catch (BadRequestServiceEx e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public RESTUserGroup get(SecurityContext sc, long id, boolean includeAttributes) throws NotFoundWebEx {
        try {
            UserGroup g = this.userGroupService.get(id);
            Collection users = this.userService.getByGroup(g);
            RESTUserGroup group = new RESTUserGroup(g.getId(), g.getGroupName(), new HashSet(users), g.getDescription());
            if (includeAttributes) {
                group.setAttributes(g.getAttributes());
            }
            return group;
        }
        catch (BadRequestServiceEx e) {
            throw new BadRequestWebEx("UserGroup Not found");
        }
    }

    public void assignUserGroup(SecurityContext sc, long userId, long groupId) throws NotFoundWebEx {
        if (userId < 0L || groupId < 0L) {
            throw new BadRequestWebEx("The user group or user id you provide is < 0... not good...");
        }
        try {
            this.userGroupService.assignUserGroup(userId, groupId);
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
    }

    public void deassignUserGroup(SecurityContext sc, long userId, long groupId) throws NotFoundWebEx {
        if (userId < 0L || groupId < 0L) {
            throw new BadRequestWebEx("The user group or user id you provide is < 0... not good...");
        }
        try {
            this.userGroupService.deassignUserGroup(userId, groupId);
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
    }

    public UserGroupList getAll(SecurityContext sc, Integer page, Integer entries, boolean all, boolean includeUsers, String nameLike) throws BadRequestWebEx {
        try {
            List restUserGroups = this.userGroupService.getAll(page, entries, nameLike, all).stream().map(ug -> this.createRestUserGroup((UserGroup)ug, includeUsers)).collect(Collectors.toList());
            long count = 0L;
            if (!restUserGroups.isEmpty()) {
                count = this.userGroupService.getCount(nameLike, all);
            }
            return new UserGroupList(restUserGroups, count);
        }
        catch (BadRequestServiceEx e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BadRequestWebEx(e.getMessage());
        }
    }

    private RESTUserGroup createRestUserGroup(UserGroup userGroup, boolean includeUsers) {
        return new RESTUserGroup(userGroup.getId(), userGroup.getGroupName(), (Set)(includeUsers ? new HashSet(this.userService.getByGroup(userGroup)) : Collections.emptySet()), userGroup.getDescription());
    }

    public ShortResourceList updateSecurityRules(SecurityContext sc, ShortResourceList resourcesToSet, Long groupId, Boolean canRead, Boolean canWrite) throws BadRequestWebEx, NotFoundWebEx {
        List srll = new ArrayList();
        if (groupId == null || groupId < 0L) {
            throw new BadRequestWebEx("The groupId is null or less than 0...");
        }
        if (resourcesToSet == null || resourcesToSet.isEmpty()) {
            throw new BadRequestWebEx("The resources set provided is null or empty...");
        }
        List sl = resourcesToSet.getList();
        ArrayList<Long> slOnlyIds = new ArrayList<Long>();
        for (ShortResource sr : sl) {
            if (sr.getId() < 0L) {
                throw new BadRequestWebEx("One or more ids in resource set is less than 0... check the resources list.");
            }
            slOnlyIds.add(sr.getId());
        }
        try {
            srll = this.userGroupService.updateSecurityRules(groupId, slOnlyIds, canRead.booleanValue(), canWrite.booleanValue());
        }
        catch (NotFoundServiceEx e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new NotFoundWebEx(e.getMessage());
        }
        catch (BadRequestServiceEx e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BadRequestWebEx(e.getMessage());
        }
        ShortResourceList srl = new ShortResourceList(srll);
        return srl;
    }

    public long update(SecurityContext sc, long id, RESTUserGroup newGroup) throws NotFoundWebEx {
        try {
            UserGroup old = this.userGroupService.get(id);
            if (old == null) {
                throw new NotFoundWebEx("UserGroup not found");
            }
            old = this.updateGroupObject(newGroup, old);
            this.updateAttributes(newGroup, old);
            old.setAttributes(null);
            id = this.userGroupService.update(old);
            return id;
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
        catch (BadRequestServiceEx e) {
            throw new BadRequestWebEx(e.getMessage());
        }
    }

    private UserGroup updateGroupObject(RESTUserGroup newGroup, UserGroup old) {
        UserList users;
        String description;
        String name = newGroup.getGroupName();
        if (name != null && !name.trim().isEmpty()) {
            old.setGroupName(name);
        }
        if ((description = newGroup.getDescription()) != null && !description.trim().isEmpty()) {
            old.setDescription(description);
        }
        if ((users = newGroup.getRestUsers()) != null && users.getList() != null && !users.getList().isEmpty()) {
            old.setUsers(users.getList().stream().map(u -> {
                User user = new User();
                user.setId(u.getId());
                return user;
            }).collect(Collectors.toList()));
        }
        return old;
    }

    private void updateAttributes(RESTUserGroup newGroup, UserGroup oldGroup) throws NotFoundServiceEx {
        List attributes = newGroup.getAttributes();
        List newList = Collections.emptyList();
        if (attributes != null && !attributes.isEmpty()) {
            newList = new ArrayList(attributes.size());
            for (UserGroupAttribute attr : attributes) {
                UserGroupAttribute attribute = new UserGroupAttribute();
                attribute.setName(attr.getName());
                attribute.setValue(attr.getValue());
                newList.add(attribute);
            }
        }
        this.userGroupService.updateAttributes(oldGroup.getId().longValue(), newList);
    }

    public RESTUserGroup get(SecurityContext sc, String name, boolean includeAttributes) throws NotFoundWebEx {
        UserGroup ug = name != null && name.equalsIgnoreCase(GroupReservedNames.EVERYONE.groupName()) ? this.userGroupService.get(null) : this.userGroupService.get(name);
        RESTUserGroup result = null;
        if (ug != null) {
            Collection users = this.userService.getByGroup(ug);
            result = new RESTUserGroup(ug.getId(), ug.getGroupName(), new HashSet(users), ug.getDescription());
            if (includeAttributes) {
                result.setAttributes(ug.getAttributes());
            }
        }
        return result;
    }

    public UserGroupList getByAttribute(SecurityContext sc, String name, String value, boolean ignoreCase) {
        return this.getGroups(name, Collections.singletonList(value), ignoreCase);
    }

    public UserGroupList getByAttribute(SecurityContext sc, String name, List<String> values, boolean ignoreCase) {
        return this.getGroups(name, values, ignoreCase);
    }

    private UserGroupList getGroups(String name, List<String> values, boolean ignoreCase) {
        UserGroupList groupList;
        Collection groups = this.userGroupService.findByAttribute(name, values, ignoreCase);
        if (groups != null && !groups.isEmpty()) {
            Stream groupStream = groups.stream();
            List restGroups = groupStream.map(g -> new RESTUserGroup(g, Collections.emptySet())).collect(Collectors.toList());
            groupList = new UserGroupList(restGroups, (long)restGroups.size());
        } else {
            groupList = new UserGroupList();
        }
        return groupList;
    }
}

