/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.security.password.SecurityUtils;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.rest.RESTSessionService;
import it.geosolutions.geostore.services.rest.SessionServiceDelegate;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.SessionToken;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakHelper;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakCookieUtils;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakTokenDetails;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.utils.GeoStoreContext;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.keycloak.adapters.springsecurity.token.SpringSecurityAdapterTokenStoreFactory;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class KeycloakSessionServiceDelegate
implements SessionServiceDelegate {
    private static final Logger LOGGER = LogManager.getLogger(KeycloakSessionServiceDelegate.class);
    private final UserService userService;

    public KeycloakSessionServiceDelegate(RESTSessionService restSessionService, UserService userService) {
        restSessionService.registerDelegate("keycloak", (SessionServiceDelegate)this);
        this.userService = userService;
    }

    public SessionToken refresh(String refreshToken, String accessToken) {
        HttpServletRequest request = OAuth2Utils.getRequest();
        if (accessToken == null) {
            accessToken = OAuth2Utils.tokenFromParamsOrBearer("access_token", request);
        }
        if (accessToken == null) {
            throw new NotFoundWebEx("The accessToken is missing");
        }
        if (refreshToken == null) {
            refreshToken = OAuth2Utils.getParameterValue("refresh_token", request);
        }
        TokenAuthenticationCache cache = this.cache();
        Date tokenExpiration = this.tokenExpirationTime(accessToken, cache);
        Date fiveMinutesFromNow = OAuth2Utils.fiveMinutesFromNow();
        SessionToken sessionToken = refreshToken != null && (tokenExpiration == null || fiveMinutesFromNow.after(tokenExpiration)) ? this.doRefresh(accessToken, refreshToken, cache) : this.sessionToken(accessToken, refreshToken, null);
        return sessionToken;
    }

    private SessionToken doRefresh(String accessToken, String refreshToken, TokenAuthenticationCache cache) {
        KeyCloakConfiguration configuration = GeoStoreContext.bean(KeyCloakConfiguration.class);
        AdapterConfig adapter = configuration.readAdapterConfig();
        KeyCloakHelper helper = GeoStoreContext.bean(KeyCloakHelper.class);
        AccessTokenResponse response = helper.refreshToken(adapter, refreshToken);
        String newAccessToken = response.getToken();
        long exp = response.getExpiresIn();
        String newRefreshToken = response.getRefreshToken();
        Authentication updated = helper.updateAuthentication(cache, accessToken, newAccessToken, newRefreshToken, exp);
        SimpleHttpFacade facade = new SimpleHttpFacade(OAuth2Utils.getRequest(), OAuth2Utils.getResponse());
        KeycloakDeployment deployment = helper.getDeployment((HttpFacade)facade);
        KeycloakCookieUtils.setTokenCookie(deployment, (HttpFacade)facade, (KeycloakTokenDetails)updated.getDetails());
        return this.sessionToken(newAccessToken, newRefreshToken);
    }

    private Date tokenExpirationTime(String accessToken, TokenAuthenticationCache cache) {
        Date result = null;
        Authentication authentication = cache.get(accessToken);
        if (authentication != null && authentication.getDetails() instanceof KeycloakTokenDetails) {
            KeycloakTokenDetails details = (KeycloakTokenDetails)authentication.getDetails();
            result = details.getExpiration();
        }
        return result;
    }

    private SessionToken sessionToken(String accessToken, String refreshToken) {
        return this.sessionToken(accessToken, refreshToken, null);
    }

    private SessionToken sessionToken(String accessToken, String refreshToken, Date expires) {
        SessionToken sessionToken = new SessionToken();
        sessionToken.setAccessToken(accessToken);
        sessionToken.setRefreshToken(refreshToken);
        if (expires != null) {
            sessionToken.setExpires(Long.valueOf(expires.getTime()));
        }
        sessionToken.setTokenType("bearer");
        return sessionToken;
    }

    public void doLogout(String sessionId) {
        HttpServletRequest request = OAuth2Utils.getRequest();
        HttpServletResponse response = OAuth2Utils.getResponse();
        AdapterConfig configuration = GeoStoreContext.bean(KeyCloakConfiguration.class).readAdapterConfig();
        if (request == null || response == null || configuration == null) {
            LOGGER.warn("Request, response, or configuration is null, unable to proceed with logout.");
            return;
        }
        KeyCloakHelper helper = GeoStoreContext.bean(KeyCloakHelper.class);
        KeycloakDeployment deployment = helper.getDeployment(request, response);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String refreshToken = null;
        if (authentication.getDetails() instanceof KeycloakTokenDetails) {
            refreshToken = ((KeycloakTokenDetails)authentication.getDetails()).getRefreshToken();
        }
        String logoutUrl = deployment.getLogoutUrl().build(new Object[0]).toString();
        Configuration clientConfiguration = helper.getClientConfiguration(configuration);
        Http http = new Http(clientConfiguration, (params, headers) -> {});
        String clientId = configuration.getResource();
        String secret = (String)configuration.getCredentials().get("secret");
        try {
            http.post(logoutUrl).form().param("client_id", clientId).param("client_secret", secret).param("refresh_token", refreshToken).execute();
        }
        catch (Exception e) {
            LOGGER.error("Error while performing global logout.", (Throwable)e);
        }
        SpringSecurityAdapterTokenStoreFactory factory = new SpringSecurityAdapterTokenStoreFactory();
        AdapterTokenStore tokenStore = factory.createAdapterTokenStore(deployment, OAuth2Utils.getRequest(), OAuth2Utils.getResponse());
        if (tokenStore != null) {
            tokenStore.logout();
        }
        this.internalLogout(sessionId, request, response);
    }

    private void internalLogout(String accessToken, HttpServletRequest request, HttpServletResponse response) {
        block4: {
            TokenAuthenticationCache cache = GeoStoreContext.bean("keycloakCache", TokenAuthenticationCache.class);
            if (cache.get(accessToken) != null) {
                cache.removeEntry(accessToken);
            }
            SecurityContextHolder.clearContext();
            try {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
                request.logout();
            }
            catch (ServletException e) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.warn("Error while logging out from servlet request.", (Throwable)e);
            }
        }
    }

    protected TokenAuthenticationCache cache() {
        return GeoStoreContext.bean("keycloakCache", TokenAuthenticationCache.class);
    }

    public User getUser(String sessionId, boolean refresh, boolean autorefresh) {
        String username = this.getUserName(sessionId, refresh, autorefresh);
        if (username != null) {
            User user;
            try {
                user = this.userService.get(username);
            }
            catch (Exception e) {
                LOGGER.warn("Issue while retrieving user. Will return just the username.", (Throwable)e);
                user = new User();
                user.setName(username);
            }
            return user;
        }
        return null;
    }

    public String getUserName(String sessionId, boolean refresh, boolean autorefresh) {
        TokenAuthenticationCache cache = this.cache();
        Authentication authentication = cache.get(sessionId);
        if (authentication != null) {
            Object o;
            if (refresh && autorefresh) {
                KeycloakTokenDetails tokenDetails = (KeycloakTokenDetails)authentication.getDetails();
                String refreshToken = tokenDetails.getRefreshToken();
                String accessToken = tokenDetails.getAccessToken();
                this.doRefresh(accessToken, refreshToken, cache);
            }
            if ((o = authentication.getPrincipal()) != null) {
                return SecurityUtils.getUsername((Object)o);
            }
        }
        return null;
    }
}

