/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.services.rest.security.GeoStoreAuthenticationFilter;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.context.SecurityContextHolder;

public class GeoStoreRequestHeadersAuthenticationFilter
extends GeoStoreAuthenticationFilter {
    private String userNameHeader;
    private String credentialsHeader;

    public void setUserNameHeader(String userNameHeader) {
        this.userNameHeader = userNameHeader;
    }

    public void setCredentialsHeader(String credentialsHeader) {
        this.credentialsHeader = credentialsHeader;
    }

    @Override
    protected void authenticate(HttpServletRequest req) {
        String userName = req.getHeader(this.userNameHeader);
        if (userName != null) {
            String credentials = null;
            if (this.credentialsHeader != null && (credentials = req.getHeader(this.credentialsHeader)).trim().isEmpty()) {
                credentials = null;
            }
            SecurityContextHolder.getContext().setAuthentication(this.createAuthenticationForUser(userName, credentials, this.getHeadersMap(req)));
        }
    }

    private Object getHeadersMap(HttpServletRequest req) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement().toString();
            headers.put(this.cleanHeaderName(headerName), req.getHeader(headerName));
        }
        return headers;
    }

    private String cleanHeaderName(String headerName) {
        return headerName.replaceAll("[^a-zA-Z0-9_$]", "_");
    }
}

