/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenDetails;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.ExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.web.client.RestTemplate;

public class TokenAuthenticationCache
implements ApplicationContextAware {
    private static final Logger LOGGER = LogManager.getLogger(TokenAuthenticationCache.class);
    private final Cache<String, Authentication> cache;
    private final int cacheSize = 1000;
    private final int cacheExpirationMinutes = 8;
    private ApplicationContext context;

    public TokenAuthenticationCache() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(8L, TimeUnit.HOURS).removalListener(notification -> {
            if (notification.getCause().equals((Object)RemovalCause.EXPIRED)) {
                Authentication authentication = (Authentication)notification.getValue();
                this.revokeAuthIfRefreshExpired(authentication);
            }
        });
        this.cache = cacheBuilder.build();
    }

    protected void revokeAuthIfRefreshExpired(Authentication authentication) {
        OAuth2AccessToken accessToken;
        OAuth2RefreshToken refreshToken;
        TokenDetails tokenDetails = OAuth2Utils.getTokenDetails(authentication);
        if (tokenDetails != null && tokenDetails.getAccessToken() != null && (refreshToken = (accessToken = tokenDetails.getAccessToken()).getRefreshToken()) instanceof ExpiringOAuth2RefreshToken) {
            RestTemplate template;
            ResponseEntity responseEntity;
            OAuth2Configuration.Endpoint revokeEndpoint;
            ExpiringOAuth2RefreshToken expiring = (ExpiringOAuth2RefreshToken)refreshToken;
            OAuth2Configuration configuration = (OAuth2Configuration)this.context.getBean(tokenDetails.getProvider());
            if (configuration != null && configuration.isEnabled() && expiring.getExpiration().after(new Date()) && (revokeEndpoint = configuration.buildRevokeEndpoint(expiring.getValue(), accessToken.getValue(), configuration)) != null && (responseEntity = (template = new RestTemplate()).exchange(revokeEndpoint.getUrl(), revokeEndpoint.getMethod(), null, String.class, new Object[0])).getStatusCode().value() != 200) {
                LOGGER.error("Error while revoking authorization. Error is: {}", responseEntity.getBody());
            }
        }
    }

    public Authentication get(String accessToken) {
        return (Authentication)this.cache.asMap().get(accessToken);
    }

    public Authentication putCacheEntry(String accessToken, Authentication authentication) {
        Authentication old = this.get(accessToken);
        TokenDetails oldDetails = OAuth2Utils.getTokenDetails(old);
        if (oldDetails != null) {
            TokenDetails newDetails = OAuth2Utils.getTokenDetails(authentication);
            OAuth2AccessToken newToken = newDetails.getAccessToken();
            OAuth2AccessToken oldToken = oldDetails.getAccessToken();
            if (newToken.getRefreshToken() == null && oldToken != null) {
                DefaultOAuth2AccessToken defaultOAuth2AccessToken = new DefaultOAuth2AccessToken(newToken.getValue());
                defaultOAuth2AccessToken.setRefreshToken(oldToken.getRefreshToken());
                newDetails.setAccessToken((OAuth2AccessToken)defaultOAuth2AccessToken);
            }
        }
        this.cache.put((Object)accessToken, (Object)authentication);
        return authentication;
    }

    public void removeEntry(String accessToken) {
        this.cache.invalidate((Object)accessToken);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

