/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2.google;

import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreOAuthRestTemplate;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2GeoStoreSecurityConfiguration;
import it.geosolutions.geostore.services.rest.security.oauth2.google.GoogleOAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.google.GoogleTokenServices;
import it.geosolutions.geostore.services.rest.security.oauth2.google.OpenIdFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;

@Configuration(value="googleSecConfig")
@EnableOAuth2Client
public class OAuthGoogleSecurityConfiguration
extends OAuth2GeoStoreSecurityConfiguration {
    static final String CONF_BEAN_NAME = "googleOAuth2Config";

    @Override
    public OAuth2ProtectedResourceDetails resourceDetails() {
        AuthorizationCodeResourceDetails details = (AuthorizationCodeResourceDetails)super.resourceDetails();
        details.setTokenName("authorization_code");
        return details;
    }

    @Override
    @Bean(value={"googleOAuth2Config"})
    public OAuth2Configuration configuration() {
        return new GoogleOAuth2Configuration();
    }

    @Override
    @Bean(value={"googleOpenIdRestTemplate"})
    @Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public GeoStoreOAuthRestTemplate oauth2RestTemplate() {
        return super.oauth2RestTemplate();
    }

    @Bean
    public OpenIdFilter googleOpenIdFilter() {
        return new OpenIdFilter(this.googleTokenServices(), this.oauth2RestTemplate(), this.configuration(), this.oAuth2Cache());
    }

    @Bean
    public GoogleTokenServices googleTokenServices() {
        return new GoogleTokenServices(this.configuration().getPrincipalKey());
    }

    @Bean
    public TokenAuthenticationCache oAuth2Cache() {
        return new TokenAuthenticationCache();
    }
}

